/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.policy;

import alluxio.client.block.BlockWorkerInfo;
import alluxio.client.file.policy.FileWriteLocationPolicy;
import alluxio.wire.WorkerNetAddress;
import com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class SpecificHostPolicy
implements FileWriteLocationPolicy {
    private final String mHostname;

    public SpecificHostPolicy(String hostname) {
        this.mHostname = (String)Preconditions.checkNotNull((Object)hostname);
    }

    @Override
    public WorkerNetAddress getWorkerForNextBlock(List<BlockWorkerInfo> workerInfoList, long blockSizeBytes) {
        for (BlockWorkerInfo info : workerInfoList) {
            if (!info.getNetAddress().getHost().equals(this.mHostname)) continue;
            return info.getNetAddress();
        }
        return null;
    }
}

