/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.lineage;

import alluxio.AlluxioURI;
import alluxio.client.lineage.LineageClient;
import alluxio.client.lineage.LineageContext;
import alluxio.client.lineage.LineageMasterClient;
import alluxio.client.lineage.options.CreateLineageOptions;
import alluxio.client.lineage.options.DeleteLineageOptions;
import alluxio.client.lineage.options.GetLineageInfoListOptions;
import alluxio.exception.AlluxioException;
import alluxio.exception.ConnectionFailedException;
import alluxio.exception.FileDoesNotExistException;
import alluxio.exception.LineageDeletionException;
import alluxio.exception.LineageDoesNotExistException;
import alluxio.job.CommandLineJob;
import alluxio.job.Job;
import alluxio.wire.LineageInfo;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class AbstractLineageClient
implements LineageClient {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    protected LineageContext mContext = LineageContext.INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long createLineage(List<AlluxioURI> inputFiles, List<AlluxioURI> outputFiles, Job job, CreateLineageOptions options) throws FileDoesNotExistException, AlluxioException, IOException {
        Preconditions.checkState((boolean)(job instanceof CommandLineJob), (Object)"Only command line jobs are supported by createLineage");
        LineageMasterClient masterClient = this.mContext.acquireMasterClient();
        try {
            long lineageId = masterClient.createLineage(this.stripURIList(inputFiles), this.stripURIList(outputFiles), (CommandLineJob)job);
            LOG.info("Created lineage {}", (Object)lineageId);
            long l = lineageId;
            return l;
        }
        finally {
            this.mContext.releaseMasterClient(masterClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteLineage(long lineageId, DeleteLineageOptions options) throws IOException, LineageDoesNotExistException, LineageDeletionException, AlluxioException {
        LineageMasterClient masterClient = this.mContext.acquireMasterClient();
        try {
            boolean result = masterClient.deleteLineage(lineageId, options.isCascade());
            LOG.info("{} delete lineage {}", (Object)(result ? "Succeeded to " : "Failed to "), (Object)lineageId);
            boolean bl = result;
            return bl;
        }
        finally {
            this.mContext.releaseMasterClient(masterClient);
        }
    }

    @Override
    public List<LineageInfo> getLineageInfoList(GetLineageInfoListOptions options) throws IOException {
        LineageMasterClient masterClient = this.mContext.acquireMasterClient();
        try {
            List<LineageInfo> list = masterClient.getLineageInfoList();
            return list;
        }
        catch (ConnectionFailedException e) {
            throw new IOException(e);
        }
        finally {
            this.mContext.releaseMasterClient(masterClient);
        }
    }

    private List<String> stripURIList(List<AlluxioURI> uris) {
        ArrayList<String> pathStrings = new ArrayList<String>(uris.size());
        for (AlluxioURI uri : uris) {
            pathStrings.add(uri.getPath());
        }
        return pathStrings;
    }
}

