/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.lineage;

import alluxio.AlluxioURI;
import alluxio.client.ClientContext;
import alluxio.client.lineage.AbstractLineageClient;
import alluxio.client.lineage.options.CreateLineageOptions;
import alluxio.client.lineage.options.DeleteLineageOptions;
import alluxio.client.lineage.options.GetLineageInfoListOptions;
import alluxio.exception.AlluxioException;
import alluxio.exception.FileDoesNotExistException;
import alluxio.exception.LineageDeletionException;
import alluxio.exception.LineageDoesNotExistException;
import alluxio.job.Job;
import alluxio.wire.LineageInfo;
import java.io.IOException;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class AlluxioLineage
extends AbstractLineageClient {
    private static AlluxioLineage sAlluxioLineage;

    public static synchronized AlluxioLineage get() {
        if (sAlluxioLineage == null) {
            if (!ClientContext.getConf().getBoolean("alluxio.user.lineage.enabled")) {
                throw new IllegalStateException("Lineage is not enabled in the configuration.");
            }
            sAlluxioLineage = new AlluxioLineage();
        }
        return sAlluxioLineage;
    }

    protected AlluxioLineage() {
    }

    public long createLineage(List<AlluxioURI> inputFiles, List<AlluxioURI> outputFiles, Job job) throws FileDoesNotExistException, AlluxioException, IOException {
        return this.createLineage(inputFiles, outputFiles, job, CreateLineageOptions.defaults());
    }

    public boolean deleteLineage(long lineageId) throws IOException, LineageDoesNotExistException, LineageDeletionException, AlluxioException {
        return this.deleteLineage(lineageId, DeleteLineageOptions.defaults());
    }

    public List<LineageInfo> getLineageInfoList() throws IOException {
        return this.getLineageInfoList(GetLineageInfoListOptions.defaults());
    }
}

