/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.lineage;

import alluxio.client.ClientContext;
import alluxio.client.lineage.LineageMasterClient;
import alluxio.client.lineage.LineageMasterClientPool;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public enum LineageContext {
    INSTANCE;

    private LineageMasterClientPool mLineageMasterClientPool;

    private LineageContext() {
        this.reset();
    }

    public LineageMasterClient acquireMasterClient() {
        return (LineageMasterClient)((Object)this.mLineageMasterClientPool.acquire());
    }

    public void releaseMasterClient(LineageMasterClient masterClient) {
        this.mLineageMasterClientPool.release((Object)masterClient);
    }

    public void reset() {
        if (this.mLineageMasterClientPool != null) {
            this.mLineageMasterClientPool.close();
        }
        this.mLineageMasterClientPool = new LineageMasterClientPool(ClientContext.getMasterAddress());
    }
}

