/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.lineage;

import alluxio.AlluxioURI;
import alluxio.client.file.BaseFileSystem;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.options.CreateFileOptions;
import alluxio.client.lineage.DummyFileOutputStream;
import alluxio.client.lineage.LineageContext;
import alluxio.client.lineage.LineageFileOutStream;
import alluxio.client.lineage.LineageMasterClient;
import alluxio.exception.AlluxioException;
import alluxio.exception.FileDoesNotExistException;
import alluxio.exception.LineageDoesNotExistException;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class LineageFileSystem
extends BaseFileSystem {
    private LineageContext mLineageContext = LineageContext.INSTANCE;

    public static synchronized LineageFileSystem get() {
        return new LineageFileSystem();
    }

    protected LineageFileSystem() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long reinitializeFile(AlluxioURI path, CreateFileOptions options) throws LineageDoesNotExistException, IOException, AlluxioException {
        LineageMasterClient masterClient = this.mLineageContext.acquireMasterClient();
        try {
            long l = masterClient.reinitializeFile(path.getPath(), options.getBlockSizeBytes(), options.getTtl());
            return l;
        }
        finally {
            this.mLineageContext.releaseMasterClient(masterClient);
        }
    }

    @Override
    public FileOutStream createFile(AlluxioURI path, CreateFileOptions options) throws IOException, AlluxioException {
        long fileId;
        try {
            fileId = this.reinitializeFile(path, options);
        }
        catch (LineageDoesNotExistException e) {
            return super.createFile(path, options);
        }
        if (fileId == -1L) {
            return new DummyFileOutputStream(path, options.toOutStreamOptions());
        }
        return new LineageFileOutStream(path, options.toOutStreamOptions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportLostFile(AlluxioURI path) throws IOException, FileDoesNotExistException, AlluxioException {
        LineageMasterClient masterClient = this.mLineageContext.acquireMasterClient();
        try {
            masterClient.reportLostFile(path.getPath());
        }
        finally {
            this.mLineageContext.releaseMasterClient(masterClient);
        }
    }
}

