/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.lineage;

import alluxio.AbstractClient;
import alluxio.AbstractMasterClient;
import alluxio.Configuration;
import alluxio.exception.AlluxioException;
import alluxio.exception.ConnectionFailedException;
import alluxio.exception.LineageDoesNotExistException;
import alluxio.job.CommandLineJob;
import alluxio.thrift.AlluxioService;
import alluxio.thrift.AlluxioTException;
import alluxio.thrift.LineageInfo;
import alluxio.thrift.LineageMasterClientService;
import alluxio.wire.CommandLineJobInfo;
import alluxio.wire.ThriftUtils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.thrift.TException;

@ThreadSafe
public final class LineageMasterClient
extends AbstractMasterClient {
    private LineageMasterClientService.Client mClient = null;

    public LineageMasterClient(InetSocketAddress masterAddress, Configuration configuration) {
        super(masterAddress, configuration);
    }

    protected AlluxioService.Client getClient() {
        return this.mClient;
    }

    protected String getServiceName() {
        return "LineageMasterClient";
    }

    protected long getServiceVersion() {
        return 1L;
    }

    protected void afterConnect() throws IOException {
        this.mClient = new LineageMasterClientService.Client(this.mProtocol);
    }

    public synchronized long createLineage(final List<String> inputFiles, final List<String> outputFiles, final CommandLineJob job) throws IOException, AlluxioException {
        return (Long)this.retryRPC((AbstractClient.RpcCallableThrowsAlluxioTException)new AbstractClient.RpcCallableThrowsAlluxioTException<Long>(){

            public Long call() throws AlluxioTException, TException {
                return LineageMasterClient.this.mClient.createLineage(inputFiles, outputFiles, ThriftUtils.toThrift((CommandLineJobInfo)job.generateCommandLineJobInfo()));
            }
        });
    }

    public synchronized boolean deleteLineage(final long lineageId, final boolean cascade) throws IOException, AlluxioException {
        return (Boolean)this.retryRPC((AbstractClient.RpcCallableThrowsAlluxioTException)new AbstractClient.RpcCallableThrowsAlluxioTException<Boolean>(){

            public Boolean call() throws AlluxioTException, TException {
                return LineageMasterClient.this.mClient.deleteLineage(lineageId, cascade);
            }
        });
    }

    public synchronized long reinitializeFile(final String path, final long blockSizeBytes, final long ttl) throws IOException, LineageDoesNotExistException, AlluxioException {
        return (Long)this.retryRPC((AbstractClient.RpcCallableThrowsAlluxioTException)new AbstractClient.RpcCallableThrowsAlluxioTException<Long>(){

            public Long call() throws AlluxioTException, TException {
                return LineageMasterClient.this.mClient.reinitializeFile(path, blockSizeBytes, ttl);
            }
        });
    }

    public synchronized List<alluxio.wire.LineageInfo> getLineageInfoList() throws ConnectionFailedException, IOException {
        return (List)this.retryRPC((AbstractClient.RpcCallable)new AbstractClient.RpcCallable<List<alluxio.wire.LineageInfo>>(){

            public List<alluxio.wire.LineageInfo> call() throws TException {
                ArrayList<alluxio.wire.LineageInfo> result = new ArrayList<alluxio.wire.LineageInfo>();
                for (LineageInfo lineageInfo : LineageMasterClient.this.mClient.getLineageInfoList()) {
                    result.add(ThriftUtils.fromThrift((LineageInfo)lineageInfo));
                }
                return result;
            }
        });
    }

    public synchronized void reportLostFile(final String path) throws IOException, AlluxioException {
        this.retryRPC((AbstractClient.RpcCallableThrowsAlluxioTException)new AbstractClient.RpcCallableThrowsAlluxioTException<Void>(){

            public Void call() throws AlluxioTException, TException {
                LineageMasterClient.this.mClient.reportLostFile(path);
                return null;
            }
        });
    }
}

