/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.netty;

import alluxio.exception.ExceptionMessage;
import alluxio.network.protocol.RPCMessage;
import alluxio.network.protocol.RPCResponse;
import com.google.common.base.Preconditions;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
@NotThreadSafe
public final class ClientHandler
extends SimpleChannelInboundHandler<RPCMessage> {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private final Set<ResponseListener> mListeners = new HashSet<ResponseListener>(4);

    public void addListener(ResponseListener listener) {
        this.mListeners.add((ResponseListener)Preconditions.checkNotNull((Object)listener));
    }

    public void removeListener(ResponseListener listener) {
        this.mListeners.remove(listener);
    }

    public void channelRead0(ChannelHandlerContext ctx, RPCMessage msg) throws IOException {
        if (!(msg instanceof RPCResponse)) {
            throw new IllegalArgumentException(ExceptionMessage.NO_RPC_HANDLER.getMessage(new Object[]{msg.getType()}));
        }
        this.handleResponse(ctx, (RPCResponse)msg);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        LOG.warn("Exception thrown while processing request", cause);
        ctx.close();
    }

    private void handleResponse(ChannelHandlerContext ctx, RPCResponse resp) throws IOException {
        for (ResponseListener listener : this.mListeners) {
            listener.onResponseReceived(resp);
        }
    }

    public static interface ResponseListener {
        public void onResponseReceived(RPCResponse var1);
    }
}

