/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.netty;

import alluxio.Configuration;
import alluxio.client.ClientContext;
import alluxio.client.netty.ClientHandler;
import alluxio.network.ChannelType;
import alluxio.network.protocol.RPCMessage;
import alluxio.network.protocol.RPCMessageDecoder;
import alluxio.network.protocol.RPCMessageEncoder;
import alluxio.util.network.NettyUtils;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class NettyClient {
    private static final RPCMessageEncoder ENCODER = new RPCMessageEncoder();
    private static final RPCMessageDecoder DECODER = new RPCMessageDecoder();
    private static final Configuration CONF = ClientContext.getConf();
    private static final ChannelType CHANNEL_TYPE = (ChannelType)CONF.getEnum("alluxio.user.network.netty.channel", ChannelType.class);
    private static final Class<? extends SocketChannel> CLIENT_CHANNEL_CLASS = NettyUtils.getClientChannelClass((ChannelType)CHANNEL_TYPE);
    private static final EventLoopGroup WORKER_GROUP = NettyUtils.createEventLoop((ChannelType)CHANNEL_TYPE, (int)CONF.getInt("alluxio.user.network.netty.worker.threads"), (String)"netty-client-worker-%d", (boolean)true);
    public static final long TIMEOUT_MS = CONF.getInt("alluxio.user.network.netty.timeout.ms");

    public static Bootstrap createClientBootstrap(final ClientHandler handler) {
        Bootstrap boot = new Bootstrap();
        ((Bootstrap)boot.group(WORKER_GROUP)).channel(CLIENT_CHANNEL_CLASS);
        boot.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        boot.option(ChannelOption.TCP_NODELAY, (Object)true);
        boot.option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        boot.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast(new ChannelHandler[]{RPCMessage.createFrameDecoder()});
                pipeline.addLast(new ChannelHandler[]{ENCODER});
                pipeline.addLast(new ChannelHandler[]{DECODER});
                pipeline.addLast(new ChannelHandler[]{handler});
            }
        });
        return boot;
    }
}

