/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.netty;

import alluxio.client.RemoteBlockReader;
import alluxio.client.netty.ClientHandler;
import alluxio.client.netty.NettyClient;
import alluxio.client.netty.SingleResponseListener;
import alluxio.exception.ExceptionMessage;
import alluxio.network.protocol.RPCBlockReadRequest;
import alluxio.network.protocol.RPCBlockReadResponse;
import alluxio.network.protocol.RPCErrorResponse;
import alluxio.network.protocol.RPCMessage;
import alluxio.network.protocol.RPCResponse;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class NettyRemoteBlockReader
implements RemoteBlockReader {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private final Bootstrap mClientBootstrap;
    private final ClientHandler mHandler = new ClientHandler();
    private RPCBlockReadResponse mReadResponse = null;

    public NettyRemoteBlockReader() {
        this.mClientBootstrap = NettyClient.createClientBootstrap(this.mHandler);
    }

    @Override
    public ByteBuffer readRemoteBlock(InetSocketAddress address, long blockId, long offset, long length, long lockId, long sessionId) throws IOException {
        try {
            ChannelFuture f = this.mClientBootstrap.connect((SocketAddress)address).sync();
            LOG.info("Connected to remote machine {}", (Object)address);
            Channel channel = f.channel();
            SingleResponseListener listener = new SingleResponseListener();
            this.mHandler.addListener(listener);
            channel.writeAndFlush((Object)new RPCBlockReadRequest(blockId, offset, length, lockId, sessionId));
            RPCResponse response = listener.get(NettyClient.TIMEOUT_MS, TimeUnit.MILLISECONDS);
            channel.close().sync();
            switch (response.getType()) {
                case RPC_BLOCK_READ_RESPONSE: {
                    RPCBlockReadResponse blockResponse = (RPCBlockReadResponse)response;
                    LOG.info("Data {} from remote machine {} received", (Object)blockId, (Object)address);
                    RPCResponse.Status status = blockResponse.getStatus();
                    if (status == RPCResponse.Status.SUCCESS) {
                        this.close();
                        this.mReadResponse = blockResponse;
                        return blockResponse.getPayloadDataBuffer().getReadOnlyByteBuffer();
                    }
                    throw new IOException(status.getMessage() + " response: " + blockResponse);
                }
                case RPC_ERROR_RESPONSE: {
                    RPCErrorResponse error = (RPCErrorResponse)response;
                    throw new IOException(error.getStatus().getMessage());
                }
            }
            throw new IOException(ExceptionMessage.UNEXPECTED_RPC_RESPONSE.getMessage(new Object[]{response.getType(), RPCMessage.Type.RPC_BLOCK_READ_RESPONSE}));
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.mReadResponse != null) {
            this.mReadResponse.getPayloadDataBuffer().release();
            this.mReadResponse = null;
        }
    }
}

