/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.netty;

import alluxio.client.RemoteBlockWriter;
import alluxio.client.netty.ClientHandler;
import alluxio.client.netty.NettyClient;
import alluxio.client.netty.SingleResponseListener;
import alluxio.exception.ExceptionMessage;
import alluxio.network.protocol.RPCBlockWriteRequest;
import alluxio.network.protocol.RPCBlockWriteResponse;
import alluxio.network.protocol.RPCErrorResponse;
import alluxio.network.protocol.RPCMessage;
import alluxio.network.protocol.RPCResponse;
import alluxio.network.protocol.databuffer.DataBuffer;
import alluxio.network.protocol.databuffer.DataByteArrayChannel;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class NettyRemoteBlockWriter
implements RemoteBlockWriter {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private final Bootstrap mClientBootstrap;
    private final ClientHandler mHandler = new ClientHandler();
    private boolean mOpen = false;
    private InetSocketAddress mAddress;
    private long mBlockId;
    private long mSessionId;
    private long mWrittenBytes;

    public NettyRemoteBlockWriter() {
        this.mClientBootstrap = NettyClient.createClientBootstrap(this.mHandler);
    }

    @Override
    public void open(InetSocketAddress address, long blockId, long sessionId) throws IOException {
        if (this.mOpen) {
            throw new IOException(ExceptionMessage.WRITER_ALREADY_OPEN.getMessage(new Object[]{this.mAddress, this.mBlockId, this.mSessionId}));
        }
        this.mAddress = address;
        this.mBlockId = blockId;
        this.mSessionId = sessionId;
        this.mWrittenBytes = 0L;
        this.mOpen = true;
    }

    @Override
    public void close() {
        if (this.mOpen) {
            this.mOpen = false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void write(byte[] bytes, int offset, int length) throws IOException {
        SingleResponseListener listener = new SingleResponseListener();
        try {
            ChannelFuture f = this.mClientBootstrap.connect((SocketAddress)this.mAddress).sync();
            LOG.info("Connected to remote machine {}", (Object)this.mAddress);
            Channel channel = f.channel();
            this.mHandler.addListener(listener);
            channel.writeAndFlush((Object)new RPCBlockWriteRequest(this.mSessionId, this.mBlockId, this.mWrittenBytes, (long)length, (DataBuffer)new DataByteArrayChannel(bytes, (long)offset, (long)length)));
            RPCResponse response = listener.get(NettyClient.TIMEOUT_MS, TimeUnit.MILLISECONDS);
            channel.close().sync();
            switch (response.getType()) {
                case RPC_BLOCK_WRITE_RESPONSE: {
                    RPCBlockWriteResponse resp = (RPCBlockWriteResponse)response;
                    RPCResponse.Status status = resp.getStatus();
                    LOG.info("status: {} from remote machine {} received", (Object)status, (Object)this.mAddress);
                    if (status != RPCResponse.Status.SUCCESS) {
                        throw new IOException(ExceptionMessage.BLOCK_WRITE_ERROR.getMessage(new Object[]{this.mBlockId, this.mSessionId, this.mAddress, status.getMessage()}));
                    }
                    this.mWrittenBytes += (long)length;
                    return;
                }
                case RPC_ERROR_RESPONSE: {
                    RPCErrorResponse error = (RPCErrorResponse)response;
                    throw new IOException(error.getStatus().getMessage());
                }
                default: {
                    throw new IOException(ExceptionMessage.UNEXPECTED_RPC_RESPONSE.getMessage(new Object[]{response.getType(), RPCMessage.Type.RPC_BLOCK_WRITE_RESPONSE}));
                }
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            this.mHandler.removeListener(listener);
        }
    }
}

