/*
 * Decompiled with CFR 0.152.
 */
package alluxio.hadoop;

import alluxio.Configuration;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.hadoop.io.DefaultStringifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class ConfUtils {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");

    private ConfUtils() {
    }

    public static void storeToHadoopConfiguration(Configuration source, org.apache.hadoop.conf.Configuration target) {
        target.set("io.serializations", "org.apache.hadoop.io.serializer.JavaSerialization,org.apache.hadoop.io.serializer.WritableSerialization");
        Properties confProperties = source.getInternalProperties();
        try {
            DefaultStringifier.store((org.apache.hadoop.conf.Configuration)target, (Object)confProperties, (String)"alluxio.conf.site");
        }
        catch (IOException ex) {
            LOG.error("Unable to store Alluxio configuration in Hadoop configuration", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public static Configuration loadFromHadoopConfiguration(org.apache.hadoop.conf.Configuration source) {
        Properties alluxioConfProperties = null;
        if (source.get("alluxio.conf.site") != null) {
            LOG.info("Found Alluxio configuration site from Job configuration for Alluxio");
            try {
                alluxioConfProperties = (Properties)DefaultStringifier.load((org.apache.hadoop.conf.Configuration)source, (String)"alluxio.conf.site", Properties.class);
            }
            catch (IOException e) {
                LOG.error("Unable to load Alluxio configuration from Hadoop configuration", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        if (alluxioConfProperties == null) {
            alluxioConfProperties = new Properties();
        }
        for (Map.Entry entry : source) {
            String propertyName = (String)entry.getKey();
            if (!propertyName.startsWith("alluxio.") && !propertyName.equals("fs.s3n.awsAccessKeyId") && !propertyName.equals("fs.s3n.awsSecretAccessKey")) continue;
            alluxioConfProperties.put(propertyName, entry.getValue());
        }
        LOG.info("Loading Alluxio properties from Hadoop configuration: {}", (Object)alluxioConfProperties);
        return new Configuration(alluxioConfProperties);
    }
}

