/*
 * Decompiled with CFR 0.152.
 */
package alluxio.hadoop;

import alluxio.AlluxioURI;
import alluxio.Configuration;
import alluxio.client.ClientContext;
import alluxio.client.ReadType;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.URIStatus;
import alluxio.client.file.options.OpenFileOptions;
import alluxio.exception.AlluxioException;
import alluxio.exception.ExceptionMessage;
import alluxio.exception.FileDoesNotExistException;
import alluxio.util.io.BufferUtils;
import com.google.common.primitives.Ints;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PositionedReadable;
import org.apache.hadoop.fs.Seekable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class HdfsFileInputStream
extends InputStream
implements Seekable,
PositionedReadable {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private long mCurrentPosition;
    private Path mHdfsPath;
    private org.apache.hadoop.conf.Configuration mHadoopConf;
    private int mHadoopBufferSize;
    private FileSystem.Statistics mStatistics;
    private URIStatus mFileInfo;
    private FSDataInputStream mHdfsInputStream = null;
    private FileInStream mAlluxioFileInputStream = null;
    private boolean mClosed = false;
    private int mBufferLimit = 0;
    private int mBufferPosition = 0;
    private byte[] mBuffer;

    public HdfsFileInputStream(AlluxioURI uri, Path hdfsPath, org.apache.hadoop.conf.Configuration conf, int bufferSize, FileSystem.Statistics stats) throws IOException {
        LOG.debug("HdfsFileInputStream({}, {}, {}, {}, {})", new Object[]{uri, hdfsPath, conf, bufferSize, stats});
        Configuration configuration = ClientContext.getConf();
        long bufferBytes = configuration.getBytes("alluxio.user.file.buffer.bytes");
        this.mBuffer = new byte[Ints.checkedCast((long)bufferBytes) * 4];
        this.mCurrentPosition = 0L;
        alluxio.client.file.FileSystem fs = FileSystem.Factory.get();
        this.mHdfsPath = hdfsPath;
        this.mHadoopConf = conf;
        this.mHadoopBufferSize = bufferSize;
        this.mStatistics = stats;
        try {
            this.mFileInfo = fs.getStatus(uri);
            this.mAlluxioFileInputStream = fs.openFile(uri, OpenFileOptions.defaults().setReadType(ReadType.CACHE));
        }
        catch (FileDoesNotExistException e) {
            throw new FileNotFoundException(ExceptionMessage.HDFS_FILE_NOT_FOUND.getMessage(new Object[]{hdfsPath, uri}));
        }
        catch (AlluxioException e) {
            throw new IOException(e);
        }
    }

    @Override
    public int available() throws IOException {
        throw new IOException(ExceptionMessage.NOT_SUPPORTED.getMessage(new Object[0]));
    }

    @Override
    public void close() throws IOException {
        if (this.mAlluxioFileInputStream != null) {
            this.mAlluxioFileInputStream.close();
        }
        if (this.mHdfsInputStream != null) {
            this.mHdfsInputStream.close();
        }
        this.mClosed = true;
    }

    private void getHdfsInputStream() throws IOException {
        if (this.mHdfsInputStream == null) {
            FileSystem fs = this.mHdfsPath.getFileSystem(this.mHadoopConf);
            this.mHdfsInputStream = fs.open(this.mHdfsPath, this.mHadoopBufferSize);
            this.mHdfsInputStream.seek(this.mCurrentPosition);
        }
    }

    private void getHdfsInputStream(long position) throws IOException {
        if (this.mHdfsInputStream == null) {
            FileSystem fs = this.mHdfsPath.getFileSystem(this.mHadoopConf);
            this.mHdfsInputStream = fs.open(this.mHdfsPath, this.mHadoopBufferSize);
        }
        this.mHdfsInputStream.seek(position);
    }

    public long getPos() throws IOException {
        return this.mCurrentPosition;
    }

    @Override
    public int read() throws IOException {
        if (this.mClosed) {
            throw new IOException("Cannot read from a closed stream.");
        }
        if (this.mAlluxioFileInputStream != null) {
            int ret = 0;
            try {
                ret = this.mAlluxioFileInputStream.read();
                if (this.mStatistics != null && ret != -1) {
                    this.mStatistics.incrementBytesRead(1L);
                }
                ++this.mCurrentPosition;
                return ret;
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mAlluxioFileInputStream.close();
                this.mAlluxioFileInputStream = null;
            }
        }
        this.getHdfsInputStream();
        return this.readFromHdfsBuffer();
    }

    @Override
    public int read(byte[] b) throws IOException {
        throw new IOException(ExceptionMessage.NOT_SUPPORTED.getMessage(new Object[0]));
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.mClosed) {
            throw new IOException("Cannot read from a closed stream.");
        }
        if (this.mAlluxioFileInputStream != null) {
            int ret = 0;
            try {
                ret = this.mAlluxioFileInputStream.read(b, off, len);
                if (this.mStatistics != null && ret != -1) {
                    this.mStatistics.incrementBytesRead((long)ret);
                }
                this.mCurrentPosition += (long)ret;
                return ret;
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mAlluxioFileInputStream.close();
                this.mAlluxioFileInputStream = null;
            }
        }
        this.getHdfsInputStream();
        int byteRead = this.readFromHdfsBuffer();
        if (byteRead == -1) {
            return -1;
        }
        b[off] = (byte)byteRead;
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int read(long position, byte[] buffer, int offset, int length) throws IOException {
        if (this.mClosed) {
            throw new IOException(ExceptionMessage.READ_CLOSED_STREAM.getMessage(new Object[0]));
        }
        int ret = -1;
        long oldPos = this.getPos();
        if (position < 0L || position >= this.mFileInfo.getLength()) {
            return ret;
        }
        if (this.mAlluxioFileInputStream != null) {
            try {
                this.mAlluxioFileInputStream.seek(position);
                ret = this.mAlluxioFileInputStream.read(buffer, offset, length);
                if (this.mStatistics != null && ret != -1) {
                    this.mStatistics.incrementBytesRead((long)ret);
                }
                int n = ret;
                return n;
            }
            finally {
                this.mAlluxioFileInputStream.seek(oldPos);
            }
        }
        try {
            this.getHdfsInputStream(position);
            ret = this.mHdfsInputStream.read(buffer, offset, length);
            if (this.mStatistics != null && ret != -1) {
                this.mStatistics.incrementBytesRead((long)ret);
            }
            int n = ret;
            return n;
        }
        finally {
            if (this.mHdfsInputStream != null) {
                this.mHdfsInputStream.seek(oldPos);
            }
        }
    }

    private int readFromHdfsBuffer() throws IOException {
        if (this.mBufferPosition < this.mBufferLimit) {
            if (this.mStatistics != null) {
                this.mStatistics.incrementBytesRead(1L);
            }
            ++this.mCurrentPosition;
            return BufferUtils.byteToInt((byte)this.mBuffer[this.mBufferPosition++]);
        }
        LOG.error("Reading from HDFS directly");
        while ((this.mBufferLimit = this.mHdfsInputStream.read(this.mBuffer)) == 0) {
            LOG.error("Read 0 bytes in readFromHdfsBuffer for {}", (Object)this.mHdfsPath);
        }
        if (this.mBufferLimit == -1) {
            return -1;
        }
        this.mBufferPosition = 0;
        if (this.mStatistics != null) {
            this.mStatistics.incrementBytesRead(1L);
        }
        ++this.mCurrentPosition;
        return BufferUtils.byteToInt((byte)this.mBuffer[this.mBufferPosition++]);
    }

    public void readFully(long position, byte[] buffer) throws IOException {
        throw new IOException(ExceptionMessage.NOT_SUPPORTED.getMessage(new Object[0]));
    }

    public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
        throw new IOException(ExceptionMessage.NOT_SUPPORTED.getMessage(new Object[0]));
    }

    public void seek(long pos) throws IOException {
        if (pos == this.mCurrentPosition) {
            return;
        }
        if (pos < 0L) {
            throw new IOException(ExceptionMessage.SEEK_NEGATIVE.getMessage(new Object[]{pos}));
        }
        if (pos > this.mFileInfo.getLength()) {
            throw new IOException(ExceptionMessage.SEEK_PAST_EOF.getMessage(new Object[]{pos, this.mFileInfo.getLength()}));
        }
        if (this.mAlluxioFileInputStream != null) {
            this.mAlluxioFileInputStream.seek(pos);
        } else {
            this.getHdfsInputStream(pos);
            this.mBufferLimit = -1;
        }
        this.mCurrentPosition = pos;
    }

    public boolean seekToNewSource(long targetPos) throws IOException {
        throw new IOException(ExceptionMessage.NOT_SUPPORTED.getMessage(new Object[0]));
    }
}

