/*
 * Decompiled with CFR 0.152.
 */
package alluxio;

import alluxio.Configuration;
import alluxio.Version;
import alluxio.master.AlluxioMaster;
import alluxio.underfs.UnderFileSystem;
import alluxio.util.UnderFileSystemUtils;
import alluxio.util.io.PathUtils;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class Format {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private static final String USAGE = String.format("java -cp %s alluxio.Format <MASTER/WORKER>", Version.ALLUXIO_JAR);

    private static boolean formatFolder(String name, String folder, Configuration configuration) throws IOException {
        UnderFileSystem ufs = UnderFileSystem.get((String)folder, (Configuration)configuration);
        LOG.info("Formatting {}:{}", (Object)name, (Object)folder);
        if (ufs.exists(folder)) {
            for (String file : ufs.list(folder)) {
                if (ufs.delete(PathUtils.concatPath((Object)folder, (Object[])new Object[]{file}), true)) continue;
                LOG.info("Failed to remove {}:{}", (Object)name, (Object)file);
                return false;
            }
        } else if (!ufs.mkdirs(folder, true)) {
            LOG.info("Failed to create {}:{}", (Object)name, (Object)folder);
            return false;
        }
        return true;
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            LOG.info(USAGE);
            System.exit(-1);
        }
        Configuration configuration = new Configuration();
        if ("MASTER".equals(args[0].toUpperCase())) {
            String masterJournal = configuration.get("alluxio.master.journal.folder");
            if (!Format.formatFolder("JOURNAL_FOLDER", masterJournal, configuration)) {
                System.exit(-1);
            }
            for (String masterServiceName : AlluxioMaster.getServiceNames()) {
                if (Format.formatFolder(masterServiceName + "_JOURNAL_FOLDER", PathUtils.concatPath((Object)masterJournal, (Object[])new Object[]{masterServiceName}), configuration)) continue;
                System.exit(-1);
            }
            UnderFileSystemUtils.touch((String)PathUtils.concatPath((Object)masterJournal, (Object[])new Object[]{"_format_" + System.currentTimeMillis()}), (Configuration)configuration);
        } else if ("WORKER".equals(args[0].toUpperCase())) {
            String workerDataFolder = configuration.get("alluxio.worker.data.folder");
            int storageLevels = configuration.getInt("alluxio.worker.tieredstore.levels");
            for (int level = 0; level < storageLevels; ++level) {
                String tierLevelDirPath = String.format("alluxio.worker.tieredstore.level%d.dirs.path", level);
                String[] dirPaths = configuration.get(tierLevelDirPath).split(",");
                String name = "TIER_" + level + "_DIR_PATH";
                for (String dirPath : dirPaths) {
                    String dirWorkerDataFolder = PathUtils.concatPath((Object)dirPath.trim(), (Object[])new Object[]{workerDataFolder});
                    UnderFileSystem ufs = UnderFileSystem.get((String)dirWorkerDataFolder, (Configuration)configuration);
                    if (!ufs.exists(dirWorkerDataFolder) || Format.formatFolder(name, dirWorkerDataFolder, configuration)) continue;
                    System.exit(-1);
                }
            }
        } else {
            LOG.info(USAGE);
            System.exit(-1);
        }
    }

    private Format() {
    }
}

