/*
 * Decompiled with CFR 0.152.
 */
package alluxio;

import com.google.common.base.Preconditions;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class SessionInfo {
    private final long mSessionId;
    private long mLastHeartbeatMs;
    private int mSessionTimeoutMs;

    public SessionInfo(long sessionId, int sessionTimeoutMs) {
        Preconditions.checkArgument((sessionId > 0L ? 1 : 0) != 0, (Object)("Invalid session id " + sessionId));
        Preconditions.checkArgument((sessionTimeoutMs > 0 ? 1 : 0) != 0, (Object)"Invalid session timeout");
        this.mSessionId = sessionId;
        this.mLastHeartbeatMs = System.currentTimeMillis();
        this.mSessionTimeoutMs = sessionTimeoutMs;
    }

    public long getSessionId() {
        return this.mSessionId;
    }

    public synchronized void heartbeat() {
        this.mLastHeartbeatMs = System.currentTimeMillis();
    }

    public synchronized boolean timeout() {
        return System.currentTimeMillis() - this.mLastHeartbeatMs > (long)this.mSessionTimeoutMs;
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder("SessionInfo(");
        sb.append(" mSessionId: ").append(this.mSessionId);
        sb.append(", mLastHeartbeatMs: ").append(this.mLastHeartbeatMs);
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SessionInfo)) {
            return false;
        }
        SessionInfo that = (SessionInfo)o;
        return this.mSessionId == that.mSessionId;
    }

    public int hashCode() {
        return (int)(this.mSessionId ^ this.mSessionId >>> 32);
    }
}

