/*
 * Decompiled with CFR 0.152.
 */
package alluxio;

import alluxio.Configuration;
import alluxio.SessionInfo;
import alluxio.worker.WorkerContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class Sessions {
    public static final int DATASERVER_SESSION_ID = -1;
    public static final int CHECKPOINT_SESSION_ID = -2;
    public static final int MIGRATE_DATA_SESSION_ID = -3;
    public static final int MASTER_COMMAND_SESSION_ID = -4;
    public static final int ACCESS_BLOCK_SESSION_ID = -5;
    public static final int KEYVALUE_SESSION_ID = -6;
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private final Map<Long, SessionInfo> mSessions = new HashMap<Long, SessionInfo>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> getTimedOutSessions() {
        LOG.debug("Worker is checking all sessions' status for timeouts.");
        ArrayList<Long> ret = new ArrayList<Long>();
        Map<Long, SessionInfo> map = this.mSessions;
        synchronized (map) {
            for (Map.Entry<Long, SessionInfo> entry : this.mSessions.entrySet()) {
                if (!entry.getValue().timeout()) continue;
                ret.add(entry.getKey());
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeSession(long sessionId) {
        LOG.info("Cleaning up session {}", (Object)sessionId);
        Map<Long, SessionInfo> map = this.mSessions;
        synchronized (map) {
            this.mSessions.remove(sessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionHeartbeat(long sessionId) {
        Map<Long, SessionInfo> map = this.mSessions;
        synchronized (map) {
            if (this.mSessions.containsKey(sessionId)) {
                this.mSessions.get(sessionId).heartbeat();
            } else {
                Configuration conf = WorkerContext.getConf();
                int sessionTimeoutMs = conf.getInt("alluxio.worker.session.timeout.ms");
                this.mSessions.put(sessionId, new SessionInfo(sessionId, sessionTimeoutMs));
            }
        }
    }
}

