/*
 * Decompiled with CFR 0.152.
 */
package alluxio;

import alluxio.Configuration;
import com.google.common.collect.ImmutableBiMap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class StorageTierAssoc {
    private final ImmutableBiMap<String, Integer> mAliasToOrdinal;

    protected StorageTierAssoc(Configuration conf, String levelsProperty, String aliasFormat) {
        int levels = conf.getInt(levelsProperty);
        ImmutableBiMap.Builder builder = new ImmutableBiMap.Builder();
        for (int i = 0; i < levels; ++i) {
            String alias = conf.get(String.format(aliasFormat, i));
            builder.put((Object)alias, (Object)i);
        }
        this.mAliasToOrdinal = builder.build();
    }

    protected StorageTierAssoc(List<String> storageTierAliases) {
        ImmutableBiMap.Builder builder = new ImmutableBiMap.Builder();
        for (int ordinal = 0; ordinal < storageTierAliases.size(); ++ordinal) {
            builder.put((Object)storageTierAliases.get(ordinal), (Object)ordinal);
        }
        this.mAliasToOrdinal = builder.build();
    }

    public String getAlias(int ordinal) {
        return (String)this.mAliasToOrdinal.inverse().get((Object)ordinal);
    }

    public int getOrdinal(String alias) {
        return (Integer)this.mAliasToOrdinal.get((Object)alias);
    }

    public int size() {
        return this.mAliasToOrdinal.size();
    }

    public List<String> getOrderedStorageAliases() {
        int size = this.size();
        ArrayList<String> ret = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            ret.add(this.getAlias(i));
        }
        return ret;
    }
}

