/*
 * Decompiled with CFR 0.152.
 */
package alluxio;

import alluxio.Configuration;
import alluxio.Constants;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class ValidateConf {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");

    private static boolean validate() {
        HashSet<String> validProperties = new HashSet<String>();
        try {
            for (Field field : Constants.class.getDeclaredFields()) {
                String name;
                if (!field.getType().isAssignableFrom(String.class) || !(name = (String)field.get(null)).startsWith("alluxio.")) continue;
                validProperties.add(name.trim());
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        validProperties.add("alluxio.version");
        Pattern aliasPattern = Pattern.compile("alluxio.worker.tieredstore.level%d.alias".replace("%d", "\\d+").replace(".", "\\."));
        Pattern dirsPathPattern = Pattern.compile("alluxio.worker.tieredstore.level%d.dirs.path".replace("%d", "\\d+").replace(".", "\\."));
        Pattern dirsQuotaPattern = Pattern.compile("alluxio.worker.tieredstore.level%d.dirs.quota".replace("%d", "\\d+").replace(".", "\\."));
        Pattern reservedRatioPattern = Pattern.compile("alluxio.worker.tieredstore.level%d.reserved.ratio".replace("%d", "\\d+").replace(".", "\\."));
        Configuration configuration = new Configuration();
        boolean valid = true;
        for (Map.Entry entry : configuration.toMap().entrySet()) {
            String propertyName = (String)entry.getKey();
            if (aliasPattern.matcher(propertyName).matches() || dirsPathPattern.matcher(propertyName).matches() || dirsQuotaPattern.matcher(propertyName).matches() || reservedRatioPattern.matcher(propertyName).matches() || !propertyName.startsWith("alluxio.") || validProperties.contains(propertyName)) continue;
            System.err.println("Unsupported or deprecated property " + propertyName);
            valid = false;
        }
        return valid;
    }

    public static void main(String[] args) {
        if (!ValidateConf.validate()) {
            System.exit(-1);
        }
        System.out.println("All configuration entries are valid.");
        System.exit(0);
    }

    private ValidateConf() {
    }
}

