/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master;

import alluxio.master.Master;
import alluxio.master.journal.Journal;
import alluxio.master.journal.JournalInputStream;
import alluxio.master.journal.JournalOutputStream;
import alluxio.master.journal.JournalTailer;
import alluxio.master.journal.JournalTailerThread;
import alluxio.master.journal.JournalWriter;
import alluxio.master.journal.ReadWriteJournal;
import alluxio.proto.journal.Journal;
import alluxio.util.ThreadFactoryUtils;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public abstract class AbstractMaster
implements Master {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private static final long SHUTDOWN_TIMEOUT_MS = 10000L;
    private final int mNumThreads;
    private ExecutorService mExecutorService = null;
    private Journal mJournal;
    private boolean mIsLeader = false;
    private JournalTailerThread mStandbyJournalTailer = null;
    private JournalWriter mJournalWriter = null;

    protected AbstractMaster(Journal journal, int numThreads) {
        this.mJournal = (Journal)Preconditions.checkNotNull((Object)journal);
        this.mNumThreads = numThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processJournalCheckpoint(JournalInputStream inputStream) throws IOException {
        try {
            Journal.JournalEntry entry;
            while ((entry = inputStream.getNextEntry()) != null) {
                this.processJournalEntry(entry);
            }
        }
        finally {
            inputStream.close();
        }
    }

    @Override
    public void start(boolean isLeader) throws IOException {
        this.mIsLeader = isLeader;
        if (this.mExecutorService == null) {
            this.mExecutorService = Executors.newFixedThreadPool(this.mNumThreads, ThreadFactoryUtils.build((String)(this.getClass().getSimpleName() + "-%d"), (boolean)true));
        }
        LOG.info("{}: Starting {} master.", (Object)this.getName(), (Object)(this.mIsLeader ? "leader" : "standby"));
        if (this.mIsLeader) {
            JournalTailer catchupTailer;
            Preconditions.checkState((boolean)(this.mJournal instanceof ReadWriteJournal));
            this.mJournalWriter = ((ReadWriteJournal)this.mJournal).getNewWriter();
            this.mJournalWriter.completeAllLogs();
            if (this.mStandbyJournalTailer != null && this.mStandbyJournalTailer.getLatestJournalTailer() != null && this.mStandbyJournalTailer.getLatestJournalTailer().isValid()) {
                LOG.info("{}: finish processing remaining journal entries (standby -> master).", (Object)this.getName());
                catchupTailer = this.mStandbyJournalTailer.getLatestJournalTailer();
                catchupTailer.processNextJournalLogFiles();
            } else {
                catchupTailer = new JournalTailer(this, this.mJournal);
                if (catchupTailer.checkpointExists()) {
                    LOG.info("{}: process entire journal before becoming leader master.", (Object)this.getName());
                    catchupTailer.processJournalCheckpoint(true);
                    catchupTailer.processNextJournalLogFiles();
                } else {
                    LOG.info("{}: journal checkpoint does not exist, nothing to process.", (Object)this.getName());
                }
            }
            long latestSequenceNumber = catchupTailer.getLatestSequenceNumber();
            JournalOutputStream checkpointStream = this.mJournalWriter.getCheckpointOutputStream(latestSequenceNumber);
            this.streamToJournalCheckpoint(checkpointStream);
            checkpointStream.close();
        } else {
            this.mStandbyJournalTailer = new JournalTailerThread(this, this.mJournal);
            this.mStandbyJournalTailer.start();
        }
    }

    @Override
    public void stop() throws IOException {
        LOG.info("{}: Stopping {} master.", (Object)this.getName(), (Object)(this.mIsLeader ? "leader" : "standby"));
        if (this.mIsLeader) {
            if (this.mJournalWriter != null) {
                this.mJournalWriter.close();
                this.mJournalWriter = null;
            }
        } else if (this.mStandbyJournalTailer != null) {
            this.mStandbyJournalTailer.shutdownAndJoin();
        }
        if (this.mExecutorService != null) {
            this.mExecutorService.shutdownNow();
            String awaitFailureMessage = "waiting for {} executor service to shut down. Daemons may still be running";
            try {
                if (!this.mExecutorService.awaitTermination(10000L, TimeUnit.MILLISECONDS)) {
                    LOG.warn("Timed out " + awaitFailureMessage, (Object)this.getClass().getSimpleName());
                }
            }
            catch (InterruptedException e) {
                LOG.warn("Interrupted while " + awaitFailureMessage, (Object)this.getClass().getSimpleName());
            }
            this.mExecutorService = null;
        }
    }

    @Override
    public void upgradeToReadWriteJournal(ReadWriteJournal journal) {
        this.mJournal = (Journal)Preconditions.checkNotNull((Object)journal);
    }

    protected void writeJournalEntry(Journal.JournalEntry entry) {
        Preconditions.checkNotNull((Object)this.mJournalWriter, (Object)"Cannot write entry: journal writer is null.");
        try {
            this.mJournalWriter.getEntryOutputStream().writeEntry(entry);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void flushJournal() {
        Preconditions.checkNotNull((Object)this.mJournalWriter, (Object)"Cannot flush journal: journal writer is null.");
        try {
            this.mJournalWriter.getEntryOutputStream().flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected ExecutorService getExecutorService() {
        return this.mExecutorService;
    }
}

