/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master;

import alluxio.Configuration;
import alluxio.Version;
import alluxio.master.AbstractMaster;
import alluxio.master.FaultTolerantAlluxioMaster;
import alluxio.master.Master;
import alluxio.master.MasterContext;
import alluxio.master.MasterFactory;
import alluxio.master.block.BlockMaster;
import alluxio.master.file.FileSystemMaster;
import alluxio.master.journal.ReadWriteJournal;
import alluxio.master.lineage.LineageMaster;
import alluxio.metrics.MetricsSystem;
import alluxio.security.authentication.AuthenticationUtils;
import alluxio.underfs.UnderFileSystem;
import alluxio.util.LineageUtils;
import alluxio.util.network.NetworkAddressUtils;
import alluxio.web.MasterUIWebServer;
import alluxio.web.UIWebServer;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.thrift.TMultiplexedProcessor;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportFactory;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class AlluxioMaster {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private final int mMaxWorkerThreads;
    private final int mMinWorkerThreads;
    private final int mPort;
    private final TServerSocket mTServerSocket;
    private final InetSocketAddress mMasterAddress;
    private final MetricsSystem mMasterMetricsSystem;
    protected BlockMaster mBlockMaster;
    protected FileSystemMaster mFileSystemMaster;
    protected LineageMaster mLineageMaster;
    protected List<Master> mAdditionalMasters;
    protected final ReadWriteJournal mBlockMasterJournal;
    protected final ReadWriteJournal mFileSystemMasterJournal;
    protected final ReadWriteJournal mLineageMasterJournal;
    private UIWebServer mWebServer = null;
    private TServer mMasterServiceServer = null;
    private boolean mIsServing = false;
    private long mStartTimeMs = -1L;
    private static List<String> sServiceNames;
    private static ServiceLoader<MasterFactory> sServiceLoader;

    public static void main(String[] args) {
        if (args.length != 0) {
            LOG.info("java -cp {} alluxio.Master", (Object)Version.ALLUXIO_JAR);
            System.exit(-1);
        }
        try {
            Factory.create().start();
        }
        catch (Exception e) {
            LOG.error("Uncaught exception terminating Master", (Throwable)e);
            System.exit(-1);
        }
    }

    private static ServiceLoader<MasterFactory> getServiceLoader() {
        if (sServiceLoader != null) {
            return sServiceLoader;
        }
        sServiceLoader = ServiceLoader.load(MasterFactory.class, MasterFactory.class.getClassLoader());
        return sServiceLoader;
    }

    public static List<String> getServiceNames() {
        if (sServiceNames != null) {
            return sServiceNames;
        }
        sServiceNames = Lists.newArrayList();
        sServiceNames.add("BlockMaster");
        sServiceNames.add("FileSystemMaster");
        sServiceNames.add("LineageMaster");
        for (MasterFactory factory : AlluxioMaster.getServiceLoader()) {
            if (!factory.isEnabled()) continue;
            sServiceNames.add(factory.getName());
        }
        return sServiceNames;
    }

    protected AlluxioMaster() {
        Configuration conf = MasterContext.getConf();
        this.mMinWorkerThreads = conf.getInt("alluxio.master.worker.threads.min");
        this.mMaxWorkerThreads = conf.getInt("alluxio.master.worker.threads.max");
        Preconditions.checkArgument((this.mMaxWorkerThreads >= this.mMinWorkerThreads ? 1 : 0) != 0, (Object)"alluxio.master.worker.threads.max can not be less than alluxio.master.worker.threads.min");
        try {
            if (!conf.getBoolean("alluxio.test.mode")) {
                Preconditions.checkState((conf.getInt("alluxio.master.port") > 0 ? 1 : 0) != 0, (Object)"Master rpc port is only allowed to be zero in test mode.");
                Preconditions.checkState((conf.getInt("alluxio.master.web.port") > 0 ? 1 : 0) != 0, (Object)"Master web port is only allowed to be zero in test mode.");
            }
            this.mTServerSocket = new TServerSocket(NetworkAddressUtils.getBindAddress((NetworkAddressUtils.ServiceType)NetworkAddressUtils.ServiceType.MASTER_RPC, (Configuration)conf));
            this.mPort = NetworkAddressUtils.getThriftPort((TServerSocket)this.mTServerSocket);
            conf.set("alluxio.master.port", Integer.toString(this.mPort));
            this.mMasterAddress = NetworkAddressUtils.getConnectAddress((NetworkAddressUtils.ServiceType)NetworkAddressUtils.ServiceType.MASTER_RPC, (Configuration)conf);
            String journalDirectory = conf.get("alluxio.master.journal.folder");
            if (!journalDirectory.endsWith("/")) {
                journalDirectory = journalDirectory + "/";
            }
            Preconditions.checkState((boolean)this.isJournalFormatted(journalDirectory), (Object)("Alluxio was not formatted! The journal folder is " + journalDirectory));
            this.mBlockMasterJournal = new ReadWriteJournal(BlockMaster.getJournalDirectory(journalDirectory));
            this.mFileSystemMasterJournal = new ReadWriteJournal(FileSystemMaster.getJournalDirectory(journalDirectory));
            this.mLineageMasterJournal = new ReadWriteJournal(LineageMaster.getJournalDirectory(journalDirectory));
            this.mBlockMaster = new BlockMaster(this.mBlockMasterJournal);
            this.mFileSystemMaster = new FileSystemMaster(this.mBlockMaster, this.mFileSystemMasterJournal);
            if (LineageUtils.isLineageEnabled((Configuration)MasterContext.getConf())) {
                this.mLineageMaster = new LineageMaster(this.mFileSystemMaster, this.mLineageMasterJournal);
            }
            this.mAdditionalMasters = Lists.newArrayList();
            ArrayList masters = Lists.newArrayList((Object[])new AbstractMaster[]{this.mBlockMaster, this.mFileSystemMaster});
            for (MasterFactory factory : AlluxioMaster.getServiceLoader()) {
                Master master = factory.create(masters, journalDirectory);
                if (master == null) continue;
                this.mAdditionalMasters.add(master);
            }
            MasterContext.getMasterSource().registerGauges(this);
            this.mMasterMetricsSystem = new MetricsSystem("master", MasterContext.getConf());
            this.mMasterMetricsSystem.registerSource(MasterContext.getMasterSource());
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
    }

    public InetSocketAddress getMasterAddress() {
        return this.mMasterAddress;
    }

    public String getRPCBindHost() {
        return NetworkAddressUtils.getThriftSocket((TServerSocket)this.mTServerSocket).getInetAddress().getHostAddress();
    }

    public int getRPCLocalPort() {
        return this.mPort;
    }

    public String getWebBindHost() {
        if (this.mWebServer != null) {
            return this.mWebServer.getBindHost();
        }
        return "";
    }

    public int getWebLocalPort() {
        if (this.mWebServer != null) {
            return this.mWebServer.getLocalPort();
        }
        return -1;
    }

    public FileSystemMaster getFileSystemMaster() {
        return this.mFileSystemMaster;
    }

    public BlockMaster getBlockMaster() {
        return this.mBlockMaster;
    }

    public long getStarttimeMs() {
        return this.mStartTimeMs;
    }

    boolean isServing() {
        return this.mIsServing;
    }

    public void start() throws Exception {
        this.startMasters(true);
        this.startServing();
    }

    public void stop() throws Exception {
        if (this.mIsServing) {
            LOG.info("Stopping RPC server on Alluxio Master @ {}", (Object)this.mMasterAddress);
            this.stopServing();
            this.stopMasters();
            this.mTServerSocket.close();
            this.mIsServing = false;
        } else {
            LOG.info("Stopping Alluxio Master @ {}", (Object)this.mMasterAddress);
        }
    }

    protected void startMasters(boolean isLeader) {
        try {
            this.connectToUFS();
            this.mBlockMaster.start(isLeader);
            this.mFileSystemMaster.start(isLeader);
            if (LineageUtils.isLineageEnabled((Configuration)MasterContext.getConf())) {
                this.mLineageMaster.start(isLeader);
            }
            for (Master master : this.mAdditionalMasters) {
                master.start(isLeader);
            }
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
    }

    protected void stopMasters() {
        try {
            if (LineageUtils.isLineageEnabled((Configuration)MasterContext.getConf())) {
                this.mLineageMaster.stop();
            }
            for (Master master : this.mAdditionalMasters) {
                master.stop();
            }
            this.mBlockMaster.stop();
            this.mFileSystemMaster.stop();
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
    }

    private void startServing() {
        this.startServing("", "");
    }

    protected void startServing(String startMessage, String stopMessage) {
        this.mMasterMetricsSystem.start();
        this.startServingWebServer();
        LOG.info("Alluxio Master version {} started @ {} {}", new Object[]{Version.VERSION, this.mMasterAddress, startMessage});
        this.startServingRPCServer();
        LOG.info("Alluxio Master version {} ended @ {} {}", new Object[]{Version.VERSION, this.mMasterAddress, stopMessage});
    }

    protected void startServingWebServer() {
        Configuration conf = MasterContext.getConf();
        this.mWebServer = new MasterUIWebServer(NetworkAddressUtils.ServiceType.MASTER_WEB, NetworkAddressUtils.getBindAddress((NetworkAddressUtils.ServiceType)NetworkAddressUtils.ServiceType.MASTER_WEB, (Configuration)conf), this, conf);
        this.mWebServer.addHandler((AbstractHandler)this.mMasterMetricsSystem.getServletHandler());
        this.mWebServer.startWebServer();
    }

    private void registerServices(TMultiplexedProcessor processor, Map<String, TProcessor> services) {
        for (Map.Entry<String, TProcessor> service : services.entrySet()) {
            processor.registerProcessor(service.getKey(), service.getValue());
        }
    }

    protected void startServingRPCServer() {
        TTransportFactory transportFactory;
        TMultiplexedProcessor processor = new TMultiplexedProcessor();
        this.registerServices(processor, this.mBlockMaster.getServices());
        this.registerServices(processor, this.mFileSystemMaster.getServices());
        if (LineageUtils.isLineageEnabled((Configuration)MasterContext.getConf())) {
            this.registerServices(processor, this.mLineageMaster.getServices());
        }
        for (Master master : this.mAdditionalMasters) {
            this.registerServices(processor, master.getServices());
        }
        try {
            transportFactory = AuthenticationUtils.getServerTransportFactory((Configuration)MasterContext.getConf());
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        TThreadPoolServer.Args args = (TThreadPoolServer.Args)((TThreadPoolServer.Args)((TThreadPoolServer.Args)new TThreadPoolServer.Args((TServerTransport)this.mTServerSocket).maxWorkerThreads(this.mMaxWorkerThreads).minWorkerThreads(this.mMinWorkerThreads).processor((TProcessor)processor)).transportFactory(transportFactory)).protocolFactory((TProtocolFactory)new TBinaryProtocol.Factory(true, true));
        args.stopTimeoutVal = MasterContext.getConf().getBoolean("alluxio.test.mode") ? 0 : 60;
        this.mMasterServiceServer = new TThreadPoolServer(args);
        this.mIsServing = true;
        this.mStartTimeMs = System.currentTimeMillis();
        this.mMasterServiceServer.serve();
    }

    protected void stopServing() throws Exception {
        if (this.mMasterServiceServer != null) {
            this.mMasterServiceServer.stop();
            this.mMasterServiceServer = null;
        }
        if (this.mWebServer != null) {
            this.mWebServer.shutdownWebServer();
            this.mWebServer = null;
        }
        this.mMasterMetricsSystem.stop();
        this.mIsServing = false;
    }

    private boolean isJournalFormatted(String journalDirectory) throws IOException {
        Configuration conf = MasterContext.getConf();
        UnderFileSystem ufs = UnderFileSystem.get((String)journalDirectory, (Configuration)conf);
        if (!ufs.providesStorage()) {
            LOG.info("Journal directory doesn't provide storage: {}", (Object)journalDirectory);
            return true;
        }
        String[] files = ufs.list(journalDirectory);
        if (files == null) {
            return false;
        }
        String formatFilePrefix = conf.get("alluxio.master.format.file_prefix");
        for (String file : files) {
            if (!file.startsWith(formatFilePrefix)) continue;
            return true;
        }
        return false;
    }

    private void connectToUFS() throws IOException {
        Configuration conf = MasterContext.getConf();
        String ufsAddress = conf.get("alluxio.underfs.address");
        UnderFileSystem ufs = UnderFileSystem.get((String)ufsAddress, (Configuration)conf);
        ufs.connectFromMaster(conf, NetworkAddressUtils.getConnectHost((NetworkAddressUtils.ServiceType)NetworkAddressUtils.ServiceType.MASTER_RPC, (Configuration)conf));
    }

    @ThreadSafe
    public static final class Factory {
        public static AlluxioMaster create() {
            if (MasterContext.getConf().getBoolean("alluxio.zookeeper.enabled")) {
                return new FaultTolerantAlluxioMaster();
            }
            return new AlluxioMaster();
        }

        private Factory() {
        }
    }
}

