/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master;

import alluxio.Configuration;
import alluxio.LeaderSelectorClient;
import alluxio.master.AlluxioMaster;
import alluxio.master.MasterContext;
import alluxio.master.block.BlockMaster;
import alluxio.master.file.FileSystemMaster;
import alluxio.master.journal.ReadOnlyJournal;
import alluxio.master.lineage.LineageMaster;
import alluxio.util.CommonUtils;
import alluxio.util.network.NetworkAddressUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.IOException;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
final class FaultTolerantAlluxioMaster
extends AlluxioMaster {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private LeaderSelectorClient mLeaderSelectorClient = null;

    public FaultTolerantAlluxioMaster() {
        Configuration conf = MasterContext.getConf();
        Preconditions.checkArgument((boolean)conf.getBoolean("alluxio.zookeeper.enabled"));
        try {
            String zkName = NetworkAddressUtils.getConnectHost((NetworkAddressUtils.ServiceType)NetworkAddressUtils.ServiceType.MASTER_RPC, (Configuration)conf) + ":" + this.getMasterAddress().getPort();
            String zkAddress = conf.get("alluxio.zookeeper.address");
            String zkElectionPath = conf.get("alluxio.zookeeper.election.path");
            String zkLeaderPath = conf.get("alluxio.zookeeper.leader.path");
            this.mLeaderSelectorClient = new LeaderSelectorClient(zkAddress, zkElectionPath, zkLeaderPath, zkName);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void start() throws Exception {
        try {
            this.mLeaderSelectorClient.start();
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
        Thread currentThread = Thread.currentThread();
        this.mLeaderSelectorClient.setCurrentMasterThread(currentThread);
        boolean started = false;
        while (true) {
            if (this.mLeaderSelectorClient.isLeader()) {
                this.stopServing();
                this.stopMasters();
                this.mBlockMaster.upgradeToReadWriteJournal(this.mBlockMasterJournal);
                this.mFileSystemMaster.upgradeToReadWriteJournal(this.mFileSystemMasterJournal);
                this.mLineageMaster.upgradeToReadWriteJournal(this.mLineageMasterJournal);
                this.startMasters(true);
                started = true;
                this.startServing("(gained leadership)", "(lost leadership)");
            } else if (this.isServing() || !started) {
                this.stopServing();
                this.stopMasters();
                this.mBlockMaster = new BlockMaster(new ReadOnlyJournal(this.mBlockMasterJournal.getDirectory()));
                this.mFileSystemMaster = new FileSystemMaster(this.mBlockMaster, new ReadOnlyJournal(this.mFileSystemMasterJournal.getDirectory()));
                this.mLineageMaster = new LineageMaster(this.mFileSystemMaster, new ReadOnlyJournal(this.mLineageMasterJournal.getDirectory()));
                this.startMasters(false);
                started = true;
            }
            CommonUtils.sleepMs((Logger)LOG, (long)100L);
        }
    }

    @Override
    public void stop() throws Exception {
        super.stop();
        if (this.mLeaderSelectorClient != null) {
            this.mLeaderSelectorClient.close();
        }
    }
}

