/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master;

import alluxio.Configuration;
import alluxio.master.AlluxioMaster;
import alluxio.master.MasterContext;
import alluxio.metrics.source.Source;
import alluxio.underfs.UnderFileSystem;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.io.IOException;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class MasterSource
implements Source {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private static final String MASTER_SOURCE_NAME = "master";
    private boolean mGaugesRegistered = false;
    private final MetricRegistry mMetricRegistry = new MetricRegistry();
    private final Counter mDirectoriesCreated = this.mMetricRegistry.counter(MetricRegistry.name((String)"DirectoriesCreated", (String[])new String[0]));
    private final Counter mFileBlockInfosGot = this.mMetricRegistry.counter(MetricRegistry.name((String)"FileBlockInfosGot", (String[])new String[0]));
    private final Counter mFileInfosGot = this.mMetricRegistry.counter(MetricRegistry.name((String)"FileInfosGot", (String[])new String[0]));
    private final Counter mFilesCompleted = this.mMetricRegistry.counter(MetricRegistry.name((String)"FilesCompleted", (String[])new String[0]));
    private final Counter mFilesCreated = this.mMetricRegistry.counter(MetricRegistry.name((String)"FilesCreated", (String[])new String[0]));
    private final Counter mFilesFreed = this.mMetricRegistry.counter(MetricRegistry.name((String)"FilesFreed", (String[])new String[0]));
    private final Counter mFilesPersisted = this.mMetricRegistry.counter(MetricRegistry.name((String)"FilesPersisted", (String[])new String[0]));
    private final Counter mNewBlocksGot = this.mMetricRegistry.counter(MetricRegistry.name((String)"NewBlocksGot", (String[])new String[0]));
    private final Counter mPathsDeleted = this.mMetricRegistry.counter(MetricRegistry.name((String)"PathsDeleted", (String[])new String[0]));
    private final Counter mPathsMounted = this.mMetricRegistry.counter(MetricRegistry.name((String)"PathsMounted", (String[])new String[0]));
    private final Counter mPathsRenamed = this.mMetricRegistry.counter(MetricRegistry.name((String)"PathsRenamed", (String[])new String[0]));
    private final Counter mPathsUnmounted = this.mMetricRegistry.counter(MetricRegistry.name((String)"PathsUnmounted", (String[])new String[0]));
    private final Counter mCompleteFileOps = this.mMetricRegistry.counter(MetricRegistry.name((String)"CompleteFileOps", (String[])new String[0]));
    private final Counter mCreateDirectoryOps = this.mMetricRegistry.counter(MetricRegistry.name((String)"CreateDirectoryOps", (String[])new String[0]));
    private final Counter mCreateFileOps = this.mMetricRegistry.counter(MetricRegistry.name((String)"CreateFileOps", (String[])new String[0]));
    private final Counter mDeletePathOps = this.mMetricRegistry.counter(MetricRegistry.name((String)"DeletePathOps", (String[])new String[0]));
    private final Counter mFreeFileOps = this.mMetricRegistry.counter(MetricRegistry.name((String)"FreeFileOps", (String[])new String[0]));
    private final Counter mGetFileBlockInfoOps = this.mMetricRegistry.counter(MetricRegistry.name((String)"GetFileBlockInfoOps", (String[])new String[0]));
    private final Counter mGetFileInfoOps = this.mMetricRegistry.counter(MetricRegistry.name((String)"GetFileInfoOps", (String[])new String[0]));
    private final Counter mGetNewBlockOps = this.mMetricRegistry.counter(MetricRegistry.name((String)"GetNewBlockOps", (String[])new String[0]));
    private final Counter mMountOps = this.mMetricRegistry.counter(MetricRegistry.name((String)"MountOps", (String[])new String[0]));
    private final Counter mRenamePathOps = this.mMetricRegistry.counter(MetricRegistry.name((String)"RenamePathOps", (String[])new String[0]));
    private final Counter mSetAttributeOps = this.mMetricRegistry.counter(MetricRegistry.name((String)"SetAttributeOps", (String[])new String[0]));
    private final Counter mUnmountOps = this.mMetricRegistry.counter(MetricRegistry.name((String)"UnmountOps", (String[])new String[0]));

    public void registerGauges(final AlluxioMaster alluxioMaster) {
        if (this.mGaugesRegistered) {
            return;
        }
        this.mMetricRegistry.register(MetricRegistry.name((String)"CapacityTotal", (String[])new String[0]), (Metric)new Gauge<Long>(){

            public Long getValue() {
                return alluxioMaster.getBlockMaster().getCapacityBytes();
            }
        });
        this.mMetricRegistry.register(MetricRegistry.name((String)"CapacityUsed", (String[])new String[0]), (Metric)new Gauge<Long>(){

            public Long getValue() {
                return alluxioMaster.getBlockMaster().getUsedBytes();
            }
        });
        this.mMetricRegistry.register(MetricRegistry.name((String)"CapacityFree", (String[])new String[0]), (Metric)new Gauge<Long>(){

            public Long getValue() {
                return alluxioMaster.getBlockMaster().getCapacityBytes() - alluxioMaster.getBlockMaster().getUsedBytes();
            }
        });
        this.mMetricRegistry.register(MetricRegistry.name((String)"UnderFsCapacityTotal", (String[])new String[0]), (Metric)new Gauge<Long>(){

            public Long getValue() {
                long ret = 0L;
                try {
                    String ufsDataFolder = MasterContext.getConf().get("alluxio.underfs.address");
                    UnderFileSystem ufs = UnderFileSystem.get((String)ufsDataFolder, (Configuration)MasterContext.getConf());
                    ret = ufs.getSpace(ufsDataFolder, UnderFileSystem.SpaceType.SPACE_TOTAL);
                }
                catch (IOException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
                return ret;
            }
        });
        this.mMetricRegistry.register(MetricRegistry.name((String)"UnderFsCapacityUsed", (String[])new String[0]), (Metric)new Gauge<Long>(){

            public Long getValue() {
                long ret = 0L;
                try {
                    String ufsDataFolder = MasterContext.getConf().get("alluxio.underfs.address");
                    UnderFileSystem ufs = UnderFileSystem.get((String)ufsDataFolder, (Configuration)MasterContext.getConf());
                    ret = ufs.getSpace(ufsDataFolder, UnderFileSystem.SpaceType.SPACE_USED);
                }
                catch (IOException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
                return ret;
            }
        });
        this.mMetricRegistry.register(MetricRegistry.name((String)"UnderFsCapacityFree", (String[])new String[0]), (Metric)new Gauge<Long>(){

            public Long getValue() {
                long ret = 0L;
                try {
                    String ufsDataFolder = MasterContext.getConf().get("alluxio.underfs.address");
                    UnderFileSystem ufs = UnderFileSystem.get((String)ufsDataFolder, (Configuration)MasterContext.getConf());
                    ret = ufs.getSpace(ufsDataFolder, UnderFileSystem.SpaceType.SPACE_FREE);
                }
                catch (IOException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
                return ret;
            }
        });
        this.mMetricRegistry.register(MetricRegistry.name((String)"Workers", (String[])new String[0]), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return alluxioMaster.getBlockMaster().getWorkerCount();
            }
        });
        this.mMetricRegistry.register(MetricRegistry.name((String)"PathsTotal", (String[])new String[0]), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return alluxioMaster.getFileSystemMaster().getNumberOfPaths();
            }
        });
        this.mMetricRegistry.register(MetricRegistry.name((String)"FilesPinned", (String[])new String[0]), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return alluxioMaster.getFileSystemMaster().getNumberOfPinnedFiles();
            }
        });
        this.mGaugesRegistered = true;
    }

    @Override
    public String getName() {
        return MASTER_SOURCE_NAME;
    }

    @Override
    public MetricRegistry getMetricRegistry() {
        return this.mMetricRegistry;
    }

    public void incDirectoriesCreated(long n) {
        this.mDirectoriesCreated.inc(n);
    }

    public void incFileBlockInfosGot(long n) {
        this.mFileBlockInfosGot.inc(n);
    }

    public void incFileInfosGot(long n) {
        this.mFileInfosGot.inc(n);
    }

    public void incFilesCompleted(long n) {
        this.mFilesCompleted.inc(n);
    }

    public void incFilesCreated(long n) {
        this.mFilesCreated.inc(n);
    }

    public void incFilesFreed(long n) {
        this.mFilesFreed.inc(n);
    }

    public void incFilesPersisted(long n) {
        this.mFilesPersisted.inc(n);
    }

    public void incNewBlocksGot(long n) {
        this.mNewBlocksGot.inc(n);
    }

    public void incPathsDeleted(long n) {
        this.mPathsDeleted.inc(n);
    }

    public void incPathsMounted(long n) {
        this.mPathsMounted.inc(n);
    }

    public void incPathsRenamed(long n) {
        this.mPathsRenamed.inc(n);
    }

    public void incPathsUnmounted(long n) {
        this.mPathsUnmounted.inc(n);
    }

    public void incCompleteFileOps(long n) {
        this.mCompleteFileOps.inc(n);
    }

    public void incCreateDirectoriesOps(long n) {
        this.mCreateDirectoryOps.inc();
    }

    public void incCreateFileOps(long n) {
        this.mCreateFileOps.inc(n);
    }

    public void incDeletePathOps(long n) {
        this.mDeletePathOps.inc(n);
    }

    public void incFreeFileOps(long n) {
        this.mFreeFileOps.inc(n);
    }

    public void incGetFileBlockInfoOps(long n) {
        this.mGetFileBlockInfoOps.inc(n);
    }

    public void incGetFileInfoOps(long n) {
        this.mGetFileInfoOps.inc(n);
    }

    public void incGetNewBlockOps(long n) {
        this.mGetNewBlockOps.inc(n);
    }

    public void incMountOps(long n) {
        this.mMountOps.inc(n);
    }

    public void incRenamePathOps(long n) {
        this.mRenamePathOps.inc(n);
    }

    public void incSetAttributeOps(long n) {
        this.mSetAttributeOps.inc(n);
    }

    public void incUnmountOps(long n) {
        this.mUnmountOps.inc(n);
    }
}

