/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master;

import com.google.common.io.Closer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class RecomputeCommand
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private final String mCommand;
    private final String mFilePath;

    public RecomputeCommand(String cmd, String filePath) {
        this.mCommand = cmd;
        this.mFilePath = filePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            LOG.info("Exec {} output to {}", (Object)this.mCommand, (Object)this.mFilePath);
            Process p = Runtime.getRuntime().exec(this.mCommand);
            try (Closer closer = Closer.create();){
                String line;
                BufferedReader bri = (BufferedReader)closer.register((Closeable)new BufferedReader(new InputStreamReader(p.getInputStream())));
                BufferedReader bre = (BufferedReader)closer.register((Closeable)new BufferedReader(new InputStreamReader(p.getErrorStream())));
                File file = new File(this.mFilePath);
                FileWriter fw = new FileWriter(file.getAbsoluteFile());
                BufferedWriter bw = (BufferedWriter)closer.register((Closeable)new BufferedWriter(fw));
                while ((line = bri.readLine()) != null) {
                    bw.write(line + "\n");
                }
                while ((line = bre.readLine()) != null) {
                    bw.write(line + "\n");
                }
                bw.flush();
            }
            p.waitFor();
            LOG.info("Exec {} output to {} done.", (Object)this.mCommand, (Object)this.mFilePath);
        }
        catch (IOException e) {
            LOG.error(e.getMessage());
        }
        catch (InterruptedException e) {
            LOG.error(e.getMessage());
        }
    }
}

