/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.block;

import alluxio.master.block.ContainerIdGenerable;
import alluxio.master.journal.JournalEntryRepresentable;
import alluxio.proto.journal.Block;
import alluxio.proto.journal.Journal;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class BlockContainerIdGenerator
implements JournalEntryRepresentable,
ContainerIdGenerable {
    private final AtomicLong mNextContainerId = new AtomicLong(0L);

    @Override
    public synchronized long getNewContainerId() {
        return this.mNextContainerId.getAndIncrement();
    }

    public synchronized void setNextContainerId(long id) {
        this.mNextContainerId.set(id);
    }

    @Override
    public synchronized Journal.JournalEntry toJournalEntry() {
        Block.BlockContainerIdGeneratorEntry blockContainerIdGenerator = Block.BlockContainerIdGeneratorEntry.newBuilder().setNextContainerId(this.mNextContainerId.get()).build();
        return Journal.JournalEntry.newBuilder().setBlockContainerIdGenerator(blockContainerIdGenerator).build();
    }
}

