/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.block;

import alluxio.Configuration;
import alluxio.MasterStorageTierAssoc;
import alluxio.StorageTierAssoc;
import alluxio.collections.IndexedSet;
import alluxio.exception.BlockInfoException;
import alluxio.exception.ExceptionMessage;
import alluxio.exception.NoWorkerException;
import alluxio.heartbeat.HeartbeatExecutor;
import alluxio.heartbeat.HeartbeatThread;
import alluxio.master.AbstractMaster;
import alluxio.master.MasterContext;
import alluxio.master.block.BlockContainerIdGenerator;
import alluxio.master.block.BlockMasterClientServiceHandler;
import alluxio.master.block.BlockMasterWorkerServiceHandler;
import alluxio.master.block.ContainerIdGenerable;
import alluxio.master.block.meta.MasterBlockInfo;
import alluxio.master.block.meta.MasterBlockLocation;
import alluxio.master.block.meta.MasterWorkerInfo;
import alluxio.master.journal.Journal;
import alluxio.master.journal.JournalInputStream;
import alluxio.master.journal.JournalOutputStream;
import alluxio.master.journal.JournalProtoUtils;
import alluxio.proto.journal.Block;
import alluxio.proto.journal.Journal;
import alluxio.thrift.BlockMasterClientService;
import alluxio.thrift.BlockMasterWorkerService;
import alluxio.thrift.Command;
import alluxio.thrift.CommandType;
import alluxio.util.CommonUtils;
import alluxio.util.FormatUtils;
import alluxio.util.io.PathUtils;
import alluxio.wire.BlockInfo;
import alluxio.wire.BlockLocation;
import alluxio.wire.WorkerInfo;
import alluxio.wire.WorkerNetAddress;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Message;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.thrift.TProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class BlockMaster
extends AbstractMaster
implements ContainerIdGenerable {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    @GuardedBy(value="itself")
    private final Map<Long, MasterBlockInfo> mBlocks = new HashMap<Long, MasterBlockInfo>();
    @GuardedBy(value="mBlocks")
    private final Set<Long> mLostBlocks = new HashSet<Long>();
    private final BlockContainerIdGenerator mBlockContainerIdGenerator = new BlockContainerIdGenerator();
    private final IndexedSet.FieldIndex<MasterWorkerInfo> mIdIndex = new IndexedSet.FieldIndex<MasterWorkerInfo>(){

        public Object getFieldValue(MasterWorkerInfo o) {
            return o.getId();
        }
    };
    private final IndexedSet.FieldIndex<MasterWorkerInfo> mAddressIndex = new IndexedSet.FieldIndex<MasterWorkerInfo>(){

        public Object getFieldValue(MasterWorkerInfo o) {
            return o.getWorkerAddress();
        }
    };
    private StorageTierAssoc mGlobalStorageTierAssoc;
    @GuardedBy(value="itself")
    private final IndexedSet<MasterWorkerInfo> mWorkers = new IndexedSet(this.mIdIndex, new IndexedSet.FieldIndex[]{this.mAddressIndex});
    @GuardedBy(value="mWorkers")
    private final IndexedSet<MasterWorkerInfo> mLostWorkers = new IndexedSet(this.mIdIndex, new IndexedSet.FieldIndex[]{this.mAddressIndex});
    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    private Future<?> mLostWorkerDetectionService;
    private final AtomicLong mNextWorkerId = new AtomicLong(1L);

    public static String getJournalDirectory(String baseDirectory) {
        return PathUtils.concatPath((Object)baseDirectory, (Object[])new Object[]{"BlockMaster"});
    }

    public BlockMaster(Journal journal) {
        super(journal, 2);
    }

    @Override
    public Map<String, TProcessor> getServices() {
        HashMap<String, TProcessor> services = new HashMap<String, TProcessor>();
        services.put("BlockMasterClient", (TProcessor)new BlockMasterClientService.Processor((BlockMasterClientService.Iface)new BlockMasterClientServiceHandler(this)));
        services.put("BlockMasterWorker", (TProcessor)new BlockMasterWorkerService.Processor((BlockMasterWorkerService.Iface)new BlockMasterWorkerServiceHandler(this)));
        return services;
    }

    @Override
    public String getName() {
        return "BlockMaster";
    }

    @Override
    public void processJournalCheckpoint(JournalInputStream inputStream) throws IOException {
        this.mBlocks.clear();
        super.processJournalCheckpoint(inputStream);
    }

    @Override
    public void processJournalEntry(Journal.JournalEntry entry) throws IOException {
        Message innerEntry = JournalProtoUtils.unwrap(entry);
        if (innerEntry instanceof Block.BlockContainerIdGeneratorEntry) {
            this.mBlockContainerIdGenerator.setNextContainerId(((Block.BlockContainerIdGeneratorEntry)innerEntry).getNextContainerId());
        } else if (innerEntry instanceof Block.BlockInfoEntry) {
            Block.BlockInfoEntry blockInfoEntry = (Block.BlockInfoEntry)innerEntry;
            this.mBlocks.put(blockInfoEntry.getBlockId(), new MasterBlockInfo(blockInfoEntry.getBlockId(), blockInfoEntry.getLength()));
        } else {
            throw new IOException(ExceptionMessage.UNEXPECTED_JOURNAL_ENTRY.getMessage(new Object[]{entry}));
        }
    }

    @Override
    public void streamToJournalCheckpoint(JournalOutputStream outputStream) throws IOException {
        outputStream.writeEntry(this.mBlockContainerIdGenerator.toJournalEntry());
        for (MasterBlockInfo blockInfo : this.mBlocks.values()) {
            Block.BlockInfoEntry blockInfoEntry = Block.BlockInfoEntry.newBuilder().setBlockId(blockInfo.getBlockId()).setLength(blockInfo.getLength()).build();
            outputStream.writeEntry(Journal.JournalEntry.newBuilder().setBlockInfo(blockInfoEntry).build());
        }
    }

    @Override
    public void start(boolean isLeader) throws IOException {
        super.start(isLeader);
        this.mGlobalStorageTierAssoc = new MasterStorageTierAssoc(MasterContext.getConf());
        if (isLeader) {
            this.mLostWorkerDetectionService = this.getExecutorService().submit((Runnable)new HeartbeatThread("Master Lost Worker Detection", (HeartbeatExecutor)new LostWorkerDetectionHeartbeatExecutor(), (long)MasterContext.getConf().getInt("alluxio.master.heartbeat.interval.ms")));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWorkerCount() {
        IndexedSet<MasterWorkerInfo> indexedSet = this.mWorkers;
        synchronized (indexedSet) {
            return this.mWorkers.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WorkerInfo> getWorkerInfoList() {
        IndexedSet<MasterWorkerInfo> indexedSet = this.mWorkers;
        synchronized (indexedSet) {
            ArrayList<WorkerInfo> workerInfoList = new ArrayList<WorkerInfo>(this.mWorkers.size());
            for (MasterWorkerInfo masterWorkerInfo : this.mWorkers) {
                workerInfoList.add(masterWorkerInfo.generateClientWorkerInfo());
            }
            return workerInfoList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCapacityBytes() {
        long ret = 0L;
        IndexedSet<MasterWorkerInfo> indexedSet = this.mWorkers;
        synchronized (indexedSet) {
            for (MasterWorkerInfo worker : this.mWorkers) {
                ret += worker.getCapacityBytes();
            }
        }
        return ret;
    }

    public StorageTierAssoc getGlobalStorageTierAssoc() {
        return this.mGlobalStorageTierAssoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getUsedBytes() {
        long ret = 0L;
        IndexedSet<MasterWorkerInfo> indexedSet = this.mWorkers;
        synchronized (indexedSet) {
            for (MasterWorkerInfo worker : this.mWorkers) {
                ret += worker.getUsedBytes();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<WorkerInfo> getLostWorkersInfo() {
        IndexedSet<MasterWorkerInfo> indexedSet = this.mWorkers;
        synchronized (indexedSet) {
            HashSet<WorkerInfo> ret = new HashSet<WorkerInfo>(this.mLostWorkers.size());
            for (MasterWorkerInfo worker : this.mLostWorkers) {
                ret.add(worker.generateClientWorkerInfo());
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBlocks(List<Long> blockIds) {
        Map<Long, MasterBlockInfo> map = this.mBlocks;
        synchronized (map) {
            IndexedSet<MasterWorkerInfo> indexedSet = this.mWorkers;
            synchronized (indexedSet) {
                for (long blockId : blockIds) {
                    MasterBlockInfo masterBlockInfo = this.mBlocks.get(blockId);
                    if (masterBlockInfo == null) continue;
                    for (long workerId : new ArrayList<Long>(masterBlockInfo.getWorkers())) {
                        masterBlockInfo.removeWorker(workerId);
                        MasterWorkerInfo worker = (MasterWorkerInfo)this.mWorkers.getFirstByField(this.mIdIndex, (Object)workerId);
                        if (worker == null) continue;
                        worker.updateToRemovedBlock(true, blockId);
                    }
                    this.mLostBlocks.remove(blockId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNewContainerId() {
        BlockContainerIdGenerator blockContainerIdGenerator = this.mBlockContainerIdGenerator;
        synchronized (blockContainerIdGenerator) {
            long containerId = this.mBlockContainerIdGenerator.getNewContainerId();
            this.writeJournalEntry(this.mBlockContainerIdGenerator.toJournalEntry());
            this.flushJournal();
            return containerId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitBlock(long workerId, long usedBytesOnTier, String tierAlias, long blockId, long length) {
        LOG.debug("Commit block from worker: {}", (Object)FormatUtils.parametersToString((Object[])new Object[]{workerId, usedBytesOnTier, blockId, length}));
        Map<Long, MasterBlockInfo> map = this.mBlocks;
        synchronized (map) {
            IndexedSet<MasterWorkerInfo> indexedSet = this.mWorkers;
            synchronized (indexedSet) {
                MasterWorkerInfo workerInfo = (MasterWorkerInfo)this.mWorkers.getFirstByField(this.mIdIndex, (Object)workerId);
                workerInfo.addBlock(blockId);
                workerInfo.updateUsedBytes(tierAlias, usedBytesOnTier);
                workerInfo.updateLastUpdatedTimeMs();
                MasterBlockInfo masterBlockInfo = this.mBlocks.get(blockId);
                if (masterBlockInfo == null) {
                    masterBlockInfo = new MasterBlockInfo(blockId, length);
                    this.mBlocks.put(blockId, masterBlockInfo);
                    Block.BlockInfoEntry blockInfo = Block.BlockInfoEntry.newBuilder().setBlockId(masterBlockInfo.getBlockId()).setLength(masterBlockInfo.getLength()).build();
                    this.writeJournalEntry(Journal.JournalEntry.newBuilder().setBlockInfo(blockInfo).build());
                    this.flushJournal();
                }
                masterBlockInfo.addWorker(workerId, tierAlias);
                this.mLostBlocks.remove(blockId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitBlockInUFS(long blockId, long length) {
        LOG.debug("Commit block to ufs: {}", (Object)FormatUtils.parametersToString((Object[])new Object[]{blockId, length}));
        Map<Long, MasterBlockInfo> map = this.mBlocks;
        synchronized (map) {
            MasterBlockInfo masterBlockInfo = this.mBlocks.get(blockId);
            if (masterBlockInfo == null) {
                masterBlockInfo = new MasterBlockInfo(blockId, length);
                this.mBlocks.put(blockId, masterBlockInfo);
                Block.BlockInfoEntry blockInfo = Block.BlockInfoEntry.newBuilder().setBlockId(masterBlockInfo.getBlockId()).setLength(masterBlockInfo.getLength()).build();
                this.writeJournalEntry(Journal.JournalEntry.newBuilder().setBlockInfo(blockInfo).build());
                this.flushJournal();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockInfo getBlockInfo(long blockId) throws BlockInfoException {
        Map<Long, MasterBlockInfo> map = this.mBlocks;
        synchronized (map) {
            MasterBlockInfo masterBlockInfo = this.mBlocks.get(blockId);
            if (masterBlockInfo == null) {
                throw new BlockInfoException("Block info not found for " + blockId);
            }
            IndexedSet<MasterWorkerInfo> indexedSet = this.mWorkers;
            synchronized (indexedSet) {
                return this.generateBlockInfo(masterBlockInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BlockInfo> getBlockInfoList(List<Long> blockIds) {
        ArrayList<BlockInfo> ret = new ArrayList<BlockInfo>(blockIds.size());
        Map<Long, MasterBlockInfo> map = this.mBlocks;
        synchronized (map) {
            IndexedSet<MasterWorkerInfo> indexedSet = this.mWorkers;
            synchronized (indexedSet) {
                for (long blockId : blockIds) {
                    MasterBlockInfo masterBlockInfo = this.mBlocks.get(blockId);
                    if (masterBlockInfo == null) continue;
                    ret.add(this.generateBlockInfo(masterBlockInfo));
                }
                return ret;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Long> getTotalBytesOnTiers() {
        HashMap<String, Long> ret = new HashMap<String, Long>();
        IndexedSet<MasterWorkerInfo> indexedSet = this.mWorkers;
        synchronized (indexedSet) {
            for (MasterWorkerInfo worker : this.mWorkers) {
                for (Map.Entry<String, Long> entry : worker.getTotalBytesOnTiers().entrySet()) {
                    Long total = (Long)ret.get(entry.getKey());
                    ret.put(entry.getKey(), (total == null ? 0L : total) + entry.getValue());
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Long> getUsedBytesOnTiers() {
        HashMap<String, Long> ret = new HashMap<String, Long>();
        IndexedSet<MasterWorkerInfo> indexedSet = this.mWorkers;
        synchronized (indexedSet) {
            for (MasterWorkerInfo worker : this.mWorkers) {
                for (Map.Entry<String, Long> entry : worker.getUsedBytesOnTiers().entrySet()) {
                    Long used = (Long)ret.get(entry.getKey());
                    ret.put(entry.getKey(), (used == null ? 0L : used) + entry.getValue());
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getWorkerId(WorkerNetAddress workerNetAddress) {
        IndexedSet<MasterWorkerInfo> indexedSet = this.mWorkers;
        synchronized (indexedSet) {
            if (this.mWorkers.contains(this.mAddressIndex, (Object)workerNetAddress)) {
                long oldWorkerId = ((MasterWorkerInfo)this.mWorkers.getFirstByField(this.mAddressIndex, (Object)workerNetAddress)).getId();
                LOG.warn("The worker {} already exists as id {}.", (Object)workerNetAddress, (Object)oldWorkerId);
                return oldWorkerId;
            }
            if (this.mLostWorkers.contains(this.mAddressIndex, (Object)workerNetAddress)) {
                MasterWorkerInfo lostWorkerInfo = (MasterWorkerInfo)this.mLostWorkers.getFirstByField(this.mAddressIndex, (Object)workerNetAddress);
                long lostWorkerId = lostWorkerInfo.getId();
                LOG.warn("A lost worker {} has requested its old id {}.", (Object)workerNetAddress, (Object)lostWorkerId);
                lostWorkerInfo.updateLastUpdatedTimeMs();
                this.mWorkers.add((Object)lostWorkerInfo);
                this.mLostWorkers.remove((Object)lostWorkerInfo);
                return lostWorkerId;
            }
            long workerId = this.mNextWorkerId.getAndIncrement();
            this.mWorkers.add((Object)new MasterWorkerInfo(workerId, workerNetAddress));
            LOG.info("getWorkerId(): WorkerNetAddress: {} id: {}", (Object)workerNetAddress, (Object)workerId);
            return workerId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void workerRegister(long workerId, List<String> storageTiers, Map<String, Long> totalBytesOnTiers, Map<String, Long> usedBytesOnTiers, Map<String, List<Long>> currentBlocksOnTiers) throws NoWorkerException {
        Map<Long, MasterBlockInfo> map = this.mBlocks;
        synchronized (map) {
            IndexedSet<MasterWorkerInfo> indexedSet = this.mWorkers;
            synchronized (indexedSet) {
                if (!this.mWorkers.contains(this.mIdIndex, (Object)workerId)) {
                    throw new NoWorkerException("Could not find worker id: " + workerId + " to register.");
                }
                MasterWorkerInfo workerInfo = (MasterWorkerInfo)this.mWorkers.getFirstByField(this.mIdIndex, (Object)workerId);
                workerInfo.updateLastUpdatedTimeMs();
                HashSet<Long> blocks = new HashSet<Long>();
                for (List<Long> blockIds : currentBlocksOnTiers.values()) {
                    blocks.addAll(blockIds);
                }
                Set<Long> removedBlocks = workerInfo.register(this.mGlobalStorageTierAssoc, storageTiers, totalBytesOnTiers, usedBytesOnTiers, blocks);
                this.processWorkerRemovedBlocks(workerInfo, removedBlocks);
                this.processWorkerAddedBlocks(workerInfo, currentBlocksOnTiers);
                LOG.info("registerWorker(): {}", (Object)workerInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Command workerHeartbeat(long workerId, Map<String, Long> usedBytesOnTiers, List<Long> removedBlockIds, Map<String, List<Long>> addedBlocksOnTiers) {
        Map<Long, MasterBlockInfo> map = this.mBlocks;
        synchronized (map) {
            IndexedSet<MasterWorkerInfo> indexedSet = this.mWorkers;
            synchronized (indexedSet) {
                if (!this.mWorkers.contains(this.mIdIndex, (Object)workerId)) {
                    LOG.warn("Could not find worker id: {} for heartbeat.", (Object)workerId);
                    return new Command(CommandType.Register, new ArrayList());
                }
                MasterWorkerInfo workerInfo = (MasterWorkerInfo)this.mWorkers.getFirstByField(this.mIdIndex, (Object)workerId);
                this.processWorkerRemovedBlocks(workerInfo, removedBlockIds);
                this.processWorkerAddedBlocks(workerInfo, addedBlocksOnTiers);
                workerInfo.updateUsedBytes(usedBytesOnTiers);
                workerInfo.updateLastUpdatedTimeMs();
                List<Long> toRemoveBlocks = workerInfo.getToRemoveBlocks();
                if (toRemoveBlocks.isEmpty()) {
                    return new Command(CommandType.Nothing, new ArrayList());
                }
                return new Command(CommandType.Free, toRemoveBlocks);
            }
        }
    }

    private void processWorkerRemovedBlocks(MasterWorkerInfo workerInfo, Collection<Long> removedBlockIds) {
        for (long removedBlockId : removedBlockIds) {
            MasterBlockInfo masterBlockInfo = this.mBlocks.get(removedBlockId);
            if (masterBlockInfo == null) {
                LOG.warn("Worker {} removed block {} but block does not exist.", (Object)workerInfo.getId(), (Object)removedBlockId);
                continue;
            }
            LOG.info("Block {} is removed on worker {}.", (Object)removedBlockId, (Object)workerInfo.getId());
            workerInfo.removeBlock(masterBlockInfo.getBlockId());
            masterBlockInfo.removeWorker(workerInfo.getId());
            if (masterBlockInfo.getNumLocations() != 0) continue;
            this.mLostBlocks.add(removedBlockId);
        }
    }

    private void processLostWorker(MasterWorkerInfo latest) {
        Set<Long> lostBlocks = latest.getBlocks();
        this.processWorkerRemovedBlocks(latest, lostBlocks);
    }

    private void processWorkerAddedBlocks(MasterWorkerInfo workerInfo, Map<String, List<Long>> addedBlockIds) {
        for (Map.Entry<String, List<Long>> entry : addedBlockIds.entrySet()) {
            for (long blockId : entry.getValue()) {
                MasterBlockInfo masterBlockInfo = this.mBlocks.get(blockId);
                if (masterBlockInfo != null) {
                    workerInfo.addBlock(blockId);
                    masterBlockInfo.addWorker(workerInfo.getId(), entry.getKey());
                    this.mLostBlocks.remove(blockId);
                    continue;
                }
                LOG.warn("Failed to register workerId: {} to blockId: {}", (Object)workerInfo.getId(), (Object)blockId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Long> getLostBlocks() {
        Map<Long, MasterBlockInfo> map = this.mBlocks;
        synchronized (map) {
            return ImmutableSet.copyOf(this.mLostBlocks);
        }
    }

    private BlockInfo generateBlockInfo(MasterBlockInfo masterBlockInfo) {
        ArrayList<BlockLocation> locations = new ArrayList<BlockLocation>();
        List<MasterBlockLocation> blockLocations = masterBlockInfo.getBlockLocations();
        Collections.sort(blockLocations, new Comparator<MasterBlockLocation>(){

            @Override
            public int compare(MasterBlockLocation o1, MasterBlockLocation o2) {
                return BlockMaster.this.mGlobalStorageTierAssoc.getOrdinal(o1.getTierAlias()) - BlockMaster.this.mGlobalStorageTierAssoc.getOrdinal(o2.getTierAlias());
            }
        });
        for (MasterBlockLocation masterBlockLocation : blockLocations) {
            MasterWorkerInfo workerInfo = (MasterWorkerInfo)this.mWorkers.getFirstByField(this.mIdIndex, (Object)masterBlockLocation.getWorkerId());
            if (workerInfo == null) continue;
            locations.add(new BlockLocation().setWorkerId(masterBlockLocation.getWorkerId()).setWorkerAddress(workerInfo.getWorkerAddress()).setTierAlias(masterBlockLocation.getTierAlias()));
        }
        return new BlockInfo().setBlockId(masterBlockInfo.getBlockId()).setLength(masterBlockInfo.getLength()).setLocations(locations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportLostBlocks(List<Long> blockIds) {
        Map<Long, MasterBlockInfo> map = this.mBlocks;
        synchronized (map) {
            this.mLostBlocks.addAll(blockIds);
        }
    }

    private final class LostWorkerDetectionHeartbeatExecutor
    implements HeartbeatExecutor {
        private LostWorkerDetectionHeartbeatExecutor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void heartbeat() {
            LOG.debug("System status checking.");
            Configuration conf = MasterContext.getConf();
            int masterWorkerTimeoutMs = conf.getInt("alluxio.master.worker.timeout.ms");
            Map map = BlockMaster.this.mBlocks;
            synchronized (map) {
                IndexedSet indexedSet = BlockMaster.this.mWorkers;
                synchronized (indexedSet) {
                    Iterator iter = BlockMaster.this.mWorkers.iterator();
                    while (iter.hasNext()) {
                        MasterWorkerInfo worker = (MasterWorkerInfo)iter.next();
                        long lastUpdate = CommonUtils.getCurrentMs() - worker.getLastUpdatedTimeMs();
                        if (lastUpdate <= (long)masterWorkerTimeoutMs) continue;
                        LOG.error("The worker {} got timed out!", (Object)worker);
                        BlockMaster.this.mLostWorkers.add((Object)worker);
                        iter.remove();
                        BlockMaster.this.processLostWorker(worker);
                    }
                }
            }
        }

        public void close() {
        }
    }
}

