/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.block;

import alluxio.exception.AlluxioException;
import alluxio.master.block.BlockMaster;
import alluxio.thrift.AlluxioTException;
import alluxio.thrift.BlockMasterClientService;
import alluxio.wire.BlockInfo;
import alluxio.wire.ThriftUtils;
import alluxio.wire.WorkerInfo;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class BlockMasterClientServiceHandler
implements BlockMasterClientService.Iface {
    private final BlockMaster mBlockMaster;

    public BlockMasterClientServiceHandler(BlockMaster blockMaster) {
        Preconditions.checkNotNull((Object)blockMaster);
        this.mBlockMaster = blockMaster;
    }

    public long getServiceVersion() {
        return 1L;
    }

    public List<alluxio.thrift.WorkerInfo> getWorkerInfoList() {
        ArrayList<alluxio.thrift.WorkerInfo> workerInfos = new ArrayList<alluxio.thrift.WorkerInfo>();
        for (WorkerInfo workerInfo : this.mBlockMaster.getWorkerInfoList()) {
            workerInfos.add(ThriftUtils.toThrift((WorkerInfo)workerInfo));
        }
        return workerInfos;
    }

    public long getCapacityBytes() {
        return this.mBlockMaster.getCapacityBytes();
    }

    public long getUsedBytes() {
        return this.mBlockMaster.getUsedBytes();
    }

    public alluxio.thrift.BlockInfo getBlockInfo(long blockId) throws AlluxioTException {
        try {
            return ThriftUtils.toThrift((BlockInfo)this.mBlockMaster.getBlockInfo(blockId));
        }
        catch (AlluxioException e) {
            throw e.toAlluxioTException();
        }
    }
}

