/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.block;

import alluxio.exception.AlluxioException;
import alluxio.master.block.BlockMaster;
import alluxio.thrift.AlluxioTException;
import alluxio.thrift.BlockMasterWorkerService;
import alluxio.thrift.Command;
import alluxio.thrift.WorkerNetAddress;
import alluxio.wire.ThriftUtils;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class BlockMasterWorkerServiceHandler
implements BlockMasterWorkerService.Iface {
    private final BlockMaster mBlockMaster;

    public BlockMasterWorkerServiceHandler(BlockMaster blockMaster) {
        Preconditions.checkNotNull((Object)blockMaster);
        this.mBlockMaster = blockMaster;
    }

    public long getServiceVersion() {
        return 1L;
    }

    public long getWorkerId(WorkerNetAddress workerNetAddress) {
        return this.mBlockMaster.getWorkerId(ThriftUtils.fromThrift((WorkerNetAddress)workerNetAddress));
    }

    public void registerWorker(long workerId, List<String> storageTiers, Map<String, Long> totalBytesOnTiers, Map<String, Long> usedBytesOnTiers, Map<String, List<Long>> currentBlocksOnTiers) throws AlluxioTException {
        try {
            this.mBlockMaster.workerRegister(workerId, storageTiers, totalBytesOnTiers, usedBytesOnTiers, currentBlocksOnTiers);
        }
        catch (AlluxioException e) {
            throw e.toAlluxioTException();
        }
    }

    public Command heartbeat(long workerId, Map<String, Long> usedBytesOnTiers, List<Long> removedBlockIds, Map<String, List<Long>> addedBlocksOnTiers) {
        return this.mBlockMaster.workerHeartbeat(workerId, usedBytesOnTiers, removedBlockIds, addedBlocksOnTiers);
    }

    public void commitBlock(long workerId, long usedBytesOnTier, String tierAlias, long blockId, long length) {
        this.mBlockMaster.commitBlock(workerId, usedBytesOnTier, tierAlias, blockId, length);
    }
}

