/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.block.meta;

import alluxio.master.block.meta.MasterBlockLocation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class MasterBlockInfo {
    private final long mBlockId;
    private final long mLength;
    private final Map<Long, String> mWorkerIdToAlias;

    public MasterBlockInfo(long blockId, long length) {
        this.mBlockId = blockId;
        this.mLength = length;
        this.mWorkerIdToAlias = new HashMap<Long, String>();
    }

    public long getLength() {
        return this.mLength;
    }

    public long getBlockId() {
        return this.mBlockId;
    }

    public synchronized void addWorker(long workerId, String tierAlias) {
        this.mWorkerIdToAlias.put(workerId, tierAlias);
    }

    public void removeWorker(long workerId) {
        this.mWorkerIdToAlias.remove(workerId);
    }

    public Set<Long> getWorkers() {
        return Collections.unmodifiableSet(this.mWorkerIdToAlias.keySet());
    }

    public int getNumLocations() {
        return this.mWorkerIdToAlias.size();
    }

    public synchronized List<MasterBlockLocation> getBlockLocations() {
        ArrayList<MasterBlockLocation> ret = new ArrayList<MasterBlockLocation>(this.mWorkerIdToAlias.size());
        for (Map.Entry<Long, String> entry : this.mWorkerIdToAlias.entrySet()) {
            ret.add(new MasterBlockLocation(entry.getKey(), entry.getValue()));
        }
        return ret;
    }

    public synchronized boolean isInTier(String targetTierAlias) {
        for (String tierAlias : this.mWorkerIdToAlias.values()) {
            if (!tierAlias.equals(targetTierAlias)) continue;
            return true;
        }
        return false;
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder("MasterBlockInfo(");
        sb.append("mBlockId: ").append(this.mBlockId);
        sb.append(", mLength: ").append(this.mLength);
        sb.append(")");
        return sb.toString();
    }
}

