/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.block.meta;

import alluxio.StorageTierAssoc;
import alluxio.WorkerStorageTierAssoc;
import alluxio.util.CommonUtils;
import alluxio.wire.WorkerInfo;
import alluxio.wire.WorkerNetAddress;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class MasterWorkerInfo {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private final WorkerNetAddress mWorkerAddress;
    private final long mId;
    private final long mStartTimeMs;
    private long mCapacityBytes;
    private long mUsedBytes;
    private long mLastUpdatedTimeMs;
    private boolean mIsRegistered;
    private StorageTierAssoc mStorageTierAssoc;
    private Map<String, Long> mTotalBytesOnTiers;
    private Map<String, Long> mUsedBytesOnTiers;
    private Set<Long> mBlocks;
    private Set<Long> mToRemoveBlocks;

    public MasterWorkerInfo(long id, WorkerNetAddress address) {
        this.mWorkerAddress = (WorkerNetAddress)Preconditions.checkNotNull((Object)address);
        this.mId = id;
        this.mStartTimeMs = System.currentTimeMillis();
        this.mLastUpdatedTimeMs = System.currentTimeMillis();
        this.mIsRegistered = false;
        this.mStorageTierAssoc = null;
        this.mTotalBytesOnTiers = new HashMap<String, Long>();
        this.mUsedBytesOnTiers = new HashMap<String, Long>();
        this.mBlocks = new HashSet<Long>();
        this.mToRemoveBlocks = new HashSet<Long>();
    }

    public synchronized Set<Long> register(StorageTierAssoc globalStorageTierAssoc, List<String> storageTierAliases, Map<String, Long> totalBytesOnTiers, Map<String, Long> usedBytesOnTiers, Set<Long> blocks) {
        Sets.SetView removedBlocks;
        for (int i = 0; i < storageTierAliases.size() - 1; ++i) {
            if (globalStorageTierAssoc.getOrdinal(storageTierAliases.get(i)) < globalStorageTierAssoc.getOrdinal(storageTierAliases.get(i + 1))) continue;
            throw new IllegalArgumentException("Worker cannot place storage tier " + storageTierAliases.get(i) + " above " + storageTierAliases.get(i + 1) + " in the hierarchy");
        }
        this.mStorageTierAssoc = new WorkerStorageTierAssoc(storageTierAliases);
        if (this.mStorageTierAssoc.size() != totalBytesOnTiers.size() || this.mStorageTierAssoc.size() != usedBytesOnTiers.size()) {
            throw new IllegalArgumentException("totalBytesOnTiers and usedBytesOnTiers should have the same number of tiers as storageTierAliases, but storageTierAliases has " + this.mStorageTierAssoc.size() + " tiers, while totalBytesOnTiers has " + totalBytesOnTiers.size() + " tiers and usedBytesOnTiers has " + usedBytesOnTiers.size() + " tiers");
        }
        this.mTotalBytesOnTiers = new HashMap<String, Long>(totalBytesOnTiers);
        this.mUsedBytesOnTiers = new HashMap<String, Long>(usedBytesOnTiers);
        this.mCapacityBytes = 0L;
        for (long bytes : this.mTotalBytesOnTiers.values()) {
            this.mCapacityBytes += bytes;
        }
        this.mUsedBytes = 0L;
        for (long bytes : this.mUsedBytesOnTiers.values()) {
            this.mUsedBytes += bytes;
        }
        if (this.mIsRegistered) {
            LOG.info("re-registering an existing workerId: {}", (Object)this.mId);
            removedBlocks = Sets.difference(this.mBlocks, blocks);
        } else {
            removedBlocks = Collections.emptySet();
        }
        this.mBlocks = new HashSet<Long>(blocks);
        this.mIsRegistered = true;
        return removedBlocks;
    }

    public synchronized void addBlock(long blockId) {
        this.mBlocks.add(blockId);
    }

    public synchronized void removeBlock(long blockId) {
        this.mBlocks.remove(blockId);
        this.mToRemoveBlocks.remove(blockId);
    }

    public synchronized WorkerInfo generateClientWorkerInfo() {
        return new WorkerInfo().setId(this.mId).setAddress(this.mWorkerAddress).setLastContactSec((int)((CommonUtils.getCurrentMs() - this.mLastUpdatedTimeMs) / 1000L)).setState("In Service").setCapacityBytes(this.mCapacityBytes).setUsedBytes(this.mUsedBytes).setStartTimeMs(this.mStartTimeMs);
    }

    public synchronized WorkerNetAddress getWorkerAddress() {
        return this.mWorkerAddress;
    }

    public synchronized long getAvailableBytes() {
        return this.mCapacityBytes - this.mUsedBytes;
    }

    public synchronized Set<Long> getBlocks() {
        return new HashSet<Long>(this.mBlocks);
    }

    public synchronized long getCapacityBytes() {
        return this.mCapacityBytes;
    }

    public synchronized long getId() {
        return this.mId;
    }

    public synchronized long getLastUpdatedTimeMs() {
        return this.mLastUpdatedTimeMs;
    }

    public synchronized List<Long> getToRemoveBlocks() {
        return new ArrayList<Long>(this.mToRemoveBlocks);
    }

    public synchronized long getUsedBytes() {
        return this.mUsedBytes;
    }

    public synchronized StorageTierAssoc getStorageTierAssoc() {
        return this.mStorageTierAssoc;
    }

    public synchronized Map<String, Long> getTotalBytesOnTiers() {
        return this.mTotalBytesOnTiers;
    }

    public synchronized Map<String, Long> getUsedBytesOnTiers() {
        return this.mUsedBytesOnTiers;
    }

    public synchronized long getStartTime() {
        return this.mStartTimeMs;
    }

    public synchronized boolean isRegistered() {
        return this.mIsRegistered;
    }

    public synchronized Map<String, Long> getFreeBytesOnTiers() {
        HashMap<String, Long> freeCapacityBytes = new HashMap<String, Long>();
        for (Map.Entry<String, Long> entry : this.mTotalBytesOnTiers.entrySet()) {
            freeCapacityBytes.put(entry.getKey(), entry.getValue() - this.mUsedBytesOnTiers.get(entry.getKey()));
        }
        return freeCapacityBytes;
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder("MasterWorkerInfo(");
        sb.append(" ID: ").append(this.mId);
        sb.append(", mWorkerAddress: ").append(this.mWorkerAddress);
        sb.append(", TOTAL_BYTES: ").append(this.mCapacityBytes);
        sb.append(", mUsedBytes: ").append(this.mUsedBytes);
        sb.append(", mAvailableBytes: ").append(this.mCapacityBytes - this.mUsedBytes);
        sb.append(", mLastUpdatedTimeMs: ").append(this.mLastUpdatedTimeMs);
        sb.append(", mBlocks: [ ");
        for (long blockId : this.mBlocks) {
            sb.append(blockId).append(", ");
        }
        sb.append("] )");
        return sb.toString();
    }

    public synchronized void updateLastUpdatedTimeMs() {
        this.mLastUpdatedTimeMs = System.currentTimeMillis();
    }

    public synchronized void updateToRemovedBlock(boolean add, long blockId) {
        if (add) {
            if (this.mBlocks.contains(blockId)) {
                this.mToRemoveBlocks.add(blockId);
            }
        } else {
            this.mToRemoveBlocks.remove(blockId);
        }
    }

    public synchronized void updateUsedBytes(Map<String, Long> usedBytesOnTiers) {
        this.mUsedBytes = 0L;
        this.mUsedBytesOnTiers = usedBytesOnTiers;
        for (long t : this.mUsedBytesOnTiers.values()) {
            this.mUsedBytes += t;
        }
    }

    public synchronized void updateUsedBytes(String tierAlias, long usedBytesOnTier) {
        this.mUsedBytes += usedBytesOnTier - this.mUsedBytesOnTiers.get(tierAlias);
        this.mUsedBytesOnTiers.put(tierAlias, usedBytesOnTier);
    }
}

