/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.file;

import alluxio.AlluxioURI;
import alluxio.Configuration;
import alluxio.collections.Pair;
import alluxio.collections.PrefixList;
import alluxio.exception.AccessControlException;
import alluxio.exception.BlockInfoException;
import alluxio.exception.DirectoryNotEmptyException;
import alluxio.exception.ExceptionMessage;
import alluxio.exception.FileAlreadyCompletedException;
import alluxio.exception.FileAlreadyExistsException;
import alluxio.exception.FileDoesNotExistException;
import alluxio.exception.InvalidFileSizeException;
import alluxio.exception.InvalidPathException;
import alluxio.heartbeat.HeartbeatExecutor;
import alluxio.heartbeat.HeartbeatThread;
import alluxio.master.AbstractMaster;
import alluxio.master.MasterContext;
import alluxio.master.block.BlockId;
import alluxio.master.block.BlockMaster;
import alluxio.master.file.FileSystemMasterClientServiceHandler;
import alluxio.master.file.FileSystemMasterWorkerServiceHandler;
import alluxio.master.file.PermissionChecker;
import alluxio.master.file.meta.FileSystemMasterView;
import alluxio.master.file.meta.Inode;
import alluxio.master.file.meta.InodeDirectory;
import alluxio.master.file.meta.InodeDirectoryIdGenerator;
import alluxio.master.file.meta.InodeFile;
import alluxio.master.file.meta.InodeTree;
import alluxio.master.file.meta.MountTable;
import alluxio.master.file.meta.PersistenceState;
import alluxio.master.file.meta.TtlBucket;
import alluxio.master.file.meta.TtlBucketList;
import alluxio.master.file.meta.options.CreatePathOptions;
import alluxio.master.file.options.CompleteFileOptions;
import alluxio.master.file.options.CreateDirectoryOptions;
import alluxio.master.file.options.CreateFileOptions;
import alluxio.master.file.options.SetAttributeOptions;
import alluxio.master.journal.Journal;
import alluxio.master.journal.JournalOutputStream;
import alluxio.master.journal.JournalProtoUtils;
import alluxio.proto.journal.File;
import alluxio.proto.journal.Journal;
import alluxio.security.User;
import alluxio.security.authentication.PlainSaslServer;
import alluxio.security.authorization.FileSystemAction;
import alluxio.security.authorization.PermissionStatus;
import alluxio.security.group.GroupMappingService;
import alluxio.thrift.CommandType;
import alluxio.thrift.FileSystemCommand;
import alluxio.thrift.FileSystemCommandOptions;
import alluxio.thrift.FileSystemMasterClientService;
import alluxio.thrift.FileSystemMasterWorkerService;
import alluxio.thrift.PersistCommandOptions;
import alluxio.thrift.PersistFile;
import alluxio.underfs.UnderFileSystem;
import alluxio.util.IdUtils;
import alluxio.util.SecurityUtils;
import alluxio.util.io.PathUtils;
import alluxio.wire.BlockInfo;
import alluxio.wire.BlockLocation;
import alluxio.wire.FileBlockInfo;
import alluxio.wire.FileInfo;
import alluxio.wire.WorkerNetAddress;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.protobuf.Message;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.thrift.TProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class FileSystemMaster
extends AbstractMaster {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private final BlockMaster mBlockMaster;
    @GuardedBy(value="itself")
    private final InodeTree mInodeTree;
    @GuardedBy(value="mInodeTree")
    private final MountTable mMountTable;
    @GuardedBy(value="mInodeTree")
    private final Map<Long, Set<Long>> mWorkerToAsyncPersistFiles;
    @GuardedBy(value="mInodeTree")
    private final TtlBucketList mTtlBuckets = new TtlBucketList();
    private final InodeDirectoryIdGenerator mDirectoryIdGenerator;
    private final GroupMappingService mGroupMappingService;
    private final PrefixList mWhitelist;
    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    private Future<?> mTtlCheckerService;
    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    private Future<?> mLostFilesDetectionService;

    public static String getJournalDirectory(String baseDirectory) {
        return PathUtils.concatPath((Object)baseDirectory, (Object[])new Object[]{"FileSystemMaster"});
    }

    public FileSystemMaster(BlockMaster blockMaster, Journal journal) {
        super(journal, 2);
        this.mBlockMaster = blockMaster;
        this.mDirectoryIdGenerator = new InodeDirectoryIdGenerator(this.mBlockMaster);
        this.mMountTable = new MountTable();
        this.mInodeTree = new InodeTree(this.mBlockMaster, this.mDirectoryIdGenerator, this.mMountTable);
        Configuration conf = MasterContext.getConf();
        this.mWhitelist = new PrefixList(conf.getList("alluxio.master.whitelist", ","));
        this.mWorkerToAsyncPersistFiles = Maps.newHashMap();
        this.mGroupMappingService = GroupMappingService.Factory.getUserToGroupsMappingService((Configuration)conf);
    }

    @Override
    public Map<String, TProcessor> getServices() {
        HashMap<String, TProcessor> services = new HashMap<String, TProcessor>();
        services.put("FileSystemMasterClient", (TProcessor)new FileSystemMasterClientService.Processor((FileSystemMasterClientService.Iface)new FileSystemMasterClientServiceHandler(this)));
        services.put("FileSystemMasterWorker", (TProcessor)new FileSystemMasterWorkerService.Processor((FileSystemMasterWorkerService.Iface)new FileSystemMasterWorkerServiceHandler(this)));
        return services;
    }

    @Override
    public String getName() {
        return "FileSystemMaster";
    }

    @Override
    public void processJournalEntry(Journal.JournalEntry entry) throws IOException {
        Message innerEntry = JournalProtoUtils.unwrap(entry);
        if (innerEntry instanceof File.InodeFileEntry || innerEntry instanceof File.InodeDirectoryEntry) {
            this.mInodeTree.addInodeFromJournal(entry);
        } else if (innerEntry instanceof File.InodeLastModificationTimeEntry) {
            File.InodeLastModificationTimeEntry modTimeEntry = (File.InodeLastModificationTimeEntry)innerEntry;
            try {
                Inode inode = this.mInodeTree.getInodeById(modTimeEntry.getId());
                inode.setLastModificationTimeMs(modTimeEntry.getLastModificationTimeMs());
            }
            catch (FileDoesNotExistException e) {
                throw new RuntimeException(e);
            }
        } else if (innerEntry instanceof File.PersistDirectoryEntry) {
            File.PersistDirectoryEntry typedEntry = (File.PersistDirectoryEntry)innerEntry;
            try {
                Inode inode = this.mInodeTree.getInodeById(typedEntry.getId());
                inode.setPersistenceState(PersistenceState.PERSISTED);
            }
            catch (FileDoesNotExistException e) {
                throw new RuntimeException(e);
            }
        } else if (innerEntry instanceof File.CompleteFileEntry) {
            try {
                this.completeFileFromEntry((File.CompleteFileEntry)innerEntry);
            }
            catch (InvalidPathException e) {
                throw new RuntimeException(e);
            }
            catch (InvalidFileSizeException e) {
                throw new RuntimeException(e);
            }
            catch (FileAlreadyCompletedException e) {
                throw new RuntimeException(e);
            }
        } else if (innerEntry instanceof File.SetAttributeEntry) {
            try {
                this.setAttributeFromEntry((File.SetAttributeEntry)innerEntry);
            }
            catch (FileDoesNotExistException e) {
                throw new RuntimeException(e);
            }
        } else if (innerEntry instanceof File.DeleteFileEntry) {
            this.deleteFileFromEntry((File.DeleteFileEntry)innerEntry);
        } else if (innerEntry instanceof File.RenameEntry) {
            this.renameFromEntry((File.RenameEntry)innerEntry);
        } else if (innerEntry instanceof File.InodeDirectoryIdGeneratorEntry) {
            this.mDirectoryIdGenerator.initFromJournalEntry((File.InodeDirectoryIdGeneratorEntry)innerEntry);
        } else if (innerEntry instanceof File.ReinitializeFileEntry) {
            this.resetBlockFileFromEntry((File.ReinitializeFileEntry)innerEntry);
        } else if (innerEntry instanceof File.AddMountPointEntry) {
            try {
                this.mountFromEntry((File.AddMountPointEntry)innerEntry);
            }
            catch (FileAlreadyExistsException e) {
                throw new RuntimeException(e);
            }
            catch (InvalidPathException e) {
                throw new RuntimeException(e);
            }
        } else if (innerEntry instanceof File.DeleteMountPointEntry) {
            try {
                this.unmountFromEntry((File.DeleteMountPointEntry)innerEntry);
            }
            catch (InvalidPathException e) {
                throw new RuntimeException(e);
            }
        } else if (innerEntry instanceof File.AsyncPersistRequestEntry) {
            try {
                long fileId = ((File.AsyncPersistRequestEntry)innerEntry).getFileId();
                this.scheduleAsyncPersistenceInternal(this.getPath(fileId));
            }
            catch (FileDoesNotExistException e) {
                throw new RuntimeException(e);
            }
            catch (InvalidPathException e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new IOException(ExceptionMessage.UNEXPECTED_JOURNAL_ENTRY.getMessage(new Object[]{innerEntry}));
        }
    }

    @Override
    public void streamToJournalCheckpoint(JournalOutputStream outputStream) throws IOException {
        this.mInodeTree.streamToJournalCheckpoint(outputStream);
        outputStream.writeEntry(this.mDirectoryIdGenerator.toJournalEntry());
    }

    @Override
    public void start(boolean isLeader) throws IOException {
        if (isLeader) {
            this.mInodeTree.initializeRoot(PermissionStatus.get((Configuration)MasterContext.getConf(), (boolean)false));
            String defaultUFS = MasterContext.getConf().get("alluxio.underfs.address");
            try {
                this.mMountTable.add(new AlluxioURI("/"), new AlluxioURI(defaultUFS));
            }
            catch (FileAlreadyExistsException e) {
                throw new IOException("Failed to mount the default UFS " + defaultUFS);
            }
            catch (InvalidPathException e) {
                throw new IOException("Failed to mount the default UFS " + defaultUFS);
            }
        }
        super.start(isLeader);
        if (isLeader) {
            this.mTtlCheckerService = this.getExecutorService().submit((Runnable)new HeartbeatThread("Master TTL Check", (HeartbeatExecutor)new MasterInodeTtlCheckExecutor(), (long)MasterContext.getConf().getInt("alluxio.master.ttl.checker.interval.ms")));
            this.mLostFilesDetectionService = this.getExecutorService().submit((Runnable)new HeartbeatThread("Master Lost Files Detection", (HeartbeatExecutor)new LostFilesDetectionHeartbeatExecutor(), (long)MasterContext.getConf().getInt("alluxio.master.heartbeat.interval.ms")));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirectory(long id) {
        InodeTree inodeTree = this.mInodeTree;
        synchronized (inodeTree) {
            Inode inode;
            try {
                inode = this.mInodeTree.getInodeById(id);
            }
            catch (FileDoesNotExistException e) {
                return false;
            }
            return inode.isDirectory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFileId(AlluxioURI path) throws AccessControlException {
        InodeTree inodeTree = this.mInodeTree;
        synchronized (inodeTree) {
            Inode inode;
            try {
                this.checkPermission(FileSystemAction.READ, path, false);
                inode = this.mInodeTree.getInodeByPath(path);
            }
            catch (InvalidPathException e) {
                try {
                    return this.loadMetadata(path, true);
                }
                catch (Exception e2) {
                    return -1L;
                }
            }
            return inode.getId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileInfo getFileInfo(long fileId) throws FileDoesNotExistException {
        MasterContext.getMasterSource().incGetFileInfoOps(1L);
        InodeTree inodeTree = this.mInodeTree;
        synchronized (inodeTree) {
            Inode inode = this.mInodeTree.getInodeById(fileId);
            return this.getFileInfoInternal(inode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileInfo getFileInfo(AlluxioURI path) throws FileDoesNotExistException, InvalidPathException {
        MasterContext.getMasterSource().incGetFileInfoOps(1L);
        InodeTree inodeTree = this.mInodeTree;
        synchronized (inodeTree) {
            Inode inode = this.mInodeTree.getInodeByPath(path);
            return this.getFileInfoInternal(inode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistenceState getPersistenceState(long fileId) throws FileDoesNotExistException {
        InodeTree inodeTree = this.mInodeTree;
        synchronized (inodeTree) {
            Inode inode = this.mInodeTree.getInodeById(fileId);
            return inode.getPersistenceState();
        }
    }

    private FileInfo getFileInfoInternal(Inode inode) throws FileDoesNotExistException {
        AlluxioURI resolvedPath;
        FileInfo fileInfo = inode.generateClientFileInfo(this.mInodeTree.getPath(inode).toString());
        fileInfo.setInMemoryPercentage(this.getInMemoryPercentage(inode));
        AlluxioURI path = this.mInodeTree.getPath(inode);
        try {
            resolvedPath = this.mMountTable.resolve(path);
        }
        catch (InvalidPathException e) {
            throw new FileDoesNotExistException(e.getMessage(), (Throwable)e);
        }
        if (!path.equals((Object)resolvedPath)) {
            fileInfo.setUfsPath(resolvedPath.toString());
        }
        MasterContext.getMasterSource().incFileInfosGot(1L);
        return fileInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FileInfo> getFileInfoList(AlluxioURI path) throws AccessControlException, FileDoesNotExistException, InvalidPathException {
        MasterContext.getMasterSource().incGetFileInfoOps(1L);
        InodeTree inodeTree = this.mInodeTree;
        synchronized (inodeTree) {
            this.getFileId(path);
            Inode inode = this.mInodeTree.getInodeByPath(path);
            ArrayList<FileInfo> ret = new ArrayList<FileInfo>();
            if (inode.isDirectory()) {
                for (Inode child : ((InodeDirectory)inode).getChildren()) {
                    ret.add(this.getFileInfoInternal(child));
                }
            } else {
                ret.add(this.getFileInfoInternal(inode));
            }
            MasterContext.getMasterSource().incFileInfosGot(ret.size());
            return ret;
        }
    }

    public FileSystemMasterView getFileSystemMasterView() {
        return new FileSystemMasterView(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeFile(AlluxioURI path, CompleteFileOptions options) throws BlockInfoException, FileDoesNotExistException, InvalidPathException, InvalidFileSizeException, FileAlreadyCompletedException, AccessControlException {
        MasterContext.getMasterSource().incCompleteFileOps(1L);
        InodeTree inodeTree = this.mInodeTree;
        synchronized (inodeTree) {
            this.checkPermission(FileSystemAction.WRITE, path, false);
            long opTimeMs = System.currentTimeMillis();
            Inode inode = this.mInodeTree.getInodeByPath(path);
            long fileId = inode.getId();
            if (!inode.isFile()) {
                throw new FileDoesNotExistException(ExceptionMessage.PATH_MUST_BE_FILE.getMessage(new Object[]{path}));
            }
            InodeFile fileInode = (InodeFile)inode;
            List<Long> blockIdList = fileInode.getBlockIds();
            List<BlockInfo> blockInfoList = this.mBlockMaster.getBlockInfoList(blockIdList);
            if (!fileInode.isPersisted() && blockInfoList.size() != blockIdList.size()) {
                throw new BlockInfoException("Cannot complete a file without all the blocks committed");
            }
            long inMemoryLength = 0L;
            long fileBlockSize = fileInode.getBlockSizeBytes();
            for (int i = 0; i < blockInfoList.size(); ++i) {
                BlockInfo blockInfo = blockInfoList.get(i);
                inMemoryLength += blockInfo.getLength();
                if (i >= blockInfoList.size() - 1 || blockInfo.getLength() == fileBlockSize) continue;
                throw new BlockInfoException("Block index " + i + " has a block size smaller than the file block size (" + fileInode.getBlockSizeBytes() + ")");
            }
            long length = fileInode.isPersisted() ? options.getUfsLength() : inMemoryLength;
            this.completeFileInternal(fileInode.getBlockIds(), fileId, length, opTimeMs);
            File.CompleteFileEntry completeFileEntry = File.CompleteFileEntry.newBuilder().addAllBlockIds(fileInode.getBlockIds()).setId(fileId).setLength(length).setOpTimeMs(opTimeMs).build();
            this.writeJournalEntry(Journal.JournalEntry.newBuilder().setCompleteFile(completeFileEntry).build());
            this.flushJournal();
        }
    }

    void completeFileInternal(List<Long> blockIds, long fileId, long length, long opTimeMs) throws FileDoesNotExistException, InvalidPathException, InvalidFileSizeException, FileAlreadyCompletedException {
        InodeFile inode = (InodeFile)this.mInodeTree.getInodeById(fileId);
        inode.setBlockIds(blockIds);
        inode.setLastModificationTimeMs(opTimeMs);
        inode.complete(length);
        if (inode.isPersisted()) {
            long currLength = length;
            for (long blockId : inode.getBlockIds()) {
                long blockSize = Math.min(currLength, inode.getBlockSizeBytes());
                this.mBlockMaster.commitBlockInUFS(blockId, blockSize);
                currLength -= blockSize;
            }
        }
        MasterContext.getMasterSource().incFilesCompleted(1L);
    }

    private void completeFileFromEntry(File.CompleteFileEntry entry) throws InvalidPathException, InvalidFileSizeException, FileAlreadyCompletedException {
        try {
            this.completeFileInternal(entry.getBlockIdsList(), entry.getId(), entry.getLength(), entry.getOpTimeMs());
        }
        catch (FileDoesNotExistException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long create(AlluxioURI path, CreateFileOptions options) throws AccessControlException, InvalidPathException, FileAlreadyExistsException, BlockInfoException, IOException {
        MasterContext.getMasterSource().incCreateFileOps(1L);
        InodeTree inodeTree = this.mInodeTree;
        synchronized (inodeTree) {
            this.checkPermission(FileSystemAction.WRITE, path, true);
            InodeTree.CreatePathResult createResult = this.createInternal(path, options);
            List<Inode> created = createResult.getCreated();
            this.writeJournalEntry(this.mDirectoryIdGenerator.toJournalEntry());
            this.journalCreatePathResult(createResult);
            this.flushJournal();
            return created.get(created.size() - 1).getId();
        }
    }

    InodeTree.CreatePathResult createInternal(AlluxioURI path, CreateFileOptions options) throws InvalidPathException, FileAlreadyExistsException, BlockInfoException, IOException {
        CreatePathOptions createPathOptions = new CreatePathOptions.Builder(MasterContext.getConf()).setBlockSizeBytes(options.getBlockSizeBytes()).setDirectory(false).setOperationTimeMs(options.getOperationTimeMs()).setPersisted(options.isPersisted()).setRecursive(options.isRecursive()).setTtl(options.getTtl()).setPermissionStatus(PermissionStatus.get((Configuration)MasterContext.getConf(), (boolean)true)).build();
        InodeTree.CreatePathResult createResult = this.mInodeTree.createPath(path, createPathOptions);
        List<Inode> created = createResult.getCreated();
        InodeFile inode = (InodeFile)created.get(created.size() - 1);
        if (this.mWhitelist.inList(path.toString())) {
            inode.setCacheable(true);
        }
        this.mTtlBuckets.insert(inode);
        MasterContext.getMasterSource().incFilesCreated(1L);
        MasterContext.getMasterSource().incDirectoriesCreated(created.size() - 1);
        return createResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long reinitializeFile(AlluxioURI path, long blockSizeBytes, long ttl) throws InvalidPathException {
        InodeTree inodeTree = this.mInodeTree;
        synchronized (inodeTree) {
            long id = this.mInodeTree.reinitializeFile(path, blockSizeBytes, ttl);
            File.ReinitializeFileEntry reinitializeFile = File.ReinitializeFileEntry.newBuilder().setPath(path.getPath()).setBlockSizeBytes(blockSizeBytes).setTtl(ttl).build();
            this.writeJournalEntry(Journal.JournalEntry.newBuilder().setReinitializeFile(reinitializeFile).build());
            this.flushJournal();
            return id;
        }
    }

    private void resetBlockFileFromEntry(File.ReinitializeFileEntry entry) {
        try {
            this.mInodeTree.reinitializeFile(new AlluxioURI(entry.getPath()), entry.getBlockSizeBytes(), entry.getTtl());
        }
        catch (InvalidPathException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNewBlockIdForFile(AlluxioURI path) throws FileDoesNotExistException, InvalidPathException {
        Inode inode;
        MasterContext.getMasterSource().incGetNewBlockOps(1L);
        InodeTree inodeTree = this.mInodeTree;
        synchronized (inodeTree) {
            inode = this.mInodeTree.getInodeByPath(path);
        }
        if (!inode.isFile()) {
            throw new FileDoesNotExistException(ExceptionMessage.PATH_MUST_BE_FILE.getMessage(new Object[]{path}));
        }
        MasterContext.getMasterSource().incNewBlocksGot(1L);
        return ((InodeFile)inode).getNewBlockId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfPaths() {
        InodeTree inodeTree = this.mInodeTree;
        synchronized (inodeTree) {
            return this.mInodeTree.getSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfPinnedFiles() {
        InodeTree inodeTree = this.mInodeTree;
        synchronized (inodeTree) {
            return this.mInodeTree.getPinnedSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteFile(AlluxioURI path, boolean recursive) throws IOException, FileDoesNotExistException, DirectoryNotEmptyException, InvalidPathException, AccessControlException {
        MasterContext.getMasterSource().incDeletePathOps(1L);
        InodeTree inodeTree = this.mInodeTree;
        synchronized (inodeTree) {
            this.checkPermission(FileSystemAction.WRITE, path, true);
            Inode inode = this.mInodeTree.getInodeByPath(path);
            long fileId = inode.getId();
            long opTimeMs = System.currentTimeMillis();
            boolean ret = this.deleteFileInternal(fileId, recursive, false, opTimeMs);
            File.DeleteFileEntry deleteFile = File.DeleteFileEntry.newBuilder().setId(fileId).setRecursive(recursive).setOpTimeMs(opTimeMs).build();
            this.writeJournalEntry(Journal.JournalEntry.newBuilder().setDeleteFile(deleteFile).build());
            this.flushJournal();
            return ret;
        }
    }

    private void deleteFileFromEntry(File.DeleteFileEntry entry) {
        MasterContext.getMasterSource().incDeletePathOps(1L);
        try {
            this.deleteFileInternal(entry.getId(), entry.getRecursive(), true, entry.getOpTimeMs());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    boolean deleteFileRecursiveInternal(long fileId, boolean replayed, long opTimeMs) throws FileDoesNotExistException, IOException {
        try {
            return this.deleteFileInternal(fileId, true, replayed, opTimeMs);
        }
        catch (DirectoryNotEmptyException e) {
            throw new IllegalStateException("deleteFileInternal should never throw DirectoryNotEmptyException when recursive is true", e);
        }
    }

    boolean deleteFileInternal(long fileId, boolean recursive, boolean replayed, long opTimeMs) throws FileDoesNotExistException, IOException, DirectoryNotEmptyException {
        Inode inode = this.mInodeTree.getInodeById(fileId);
        if (inode == null) {
            return true;
        }
        if (inode.isDirectory() && !recursive && ((InodeDirectory)inode).getNumberOfChildren() > 0) {
            throw new DirectoryNotEmptyException(ExceptionMessage.DELETE_NONEMPTY_DIRECTORY_NONRECURSIVE, new Object[]{inode.getName()});
        }
        if (this.mInodeTree.isRootId(inode.getId())) {
            return false;
        }
        ArrayList<Inode> delInodes = new ArrayList<Inode>();
        delInodes.add(inode);
        if (inode.isDirectory()) {
            delInodes.addAll(this.mInodeTree.getInodeChildrenRecursive((InodeDirectory)inode));
        }
        for (int i = delInodes.size() - 1; i >= 0; --i) {
            Inode delInode = (Inode)delInodes.get(i);
            if (!replayed && delInode.isPersisted()) {
                try {
                    String ufsPath = this.mMountTable.resolve(this.mInodeTree.getPath(delInode)).toString();
                    UnderFileSystem ufs = UnderFileSystem.get((String)ufsPath, (Configuration)MasterContext.getConf());
                    if (!ufs.exists(ufsPath)) {
                        LOG.warn("File does not exist the underfs: {}", (Object)ufsPath);
                    } else if (!ufs.delete(ufsPath, true)) {
                        LOG.error("Failed to delete {}", (Object)ufsPath);
                        return false;
                    }
                }
                catch (InvalidPathException e) {
                    LOG.warn(e.getMessage());
                }
            }
            if (delInode.isFile()) {
                this.mBlockMaster.removeBlocks(((InodeFile)delInode).getBlockIds());
            }
            this.mInodeTree.deleteInode(delInode, opTimeMs);
        }
        MasterContext.getMasterSource().incPathsDeleted(delInodes.size());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileBlockInfo getFileBlockInfo(long fileId, int fileBlockIndex) throws BlockInfoException, FileDoesNotExistException, InvalidPathException {
        MasterContext.getMasterSource().incGetFileBlockInfoOps(1L);
        InodeTree inodeTree = this.mInodeTree;
        synchronized (inodeTree) {
            Inode inode = this.mInodeTree.getInodeById(fileId);
            if (inode.isDirectory()) {
                throw new FileDoesNotExistException(ExceptionMessage.FILEID_MUST_BE_FILE.getMessage(new Object[]{fileId}));
            }
            InodeFile file = (InodeFile)inode;
            ArrayList<Long> blockIdList = new ArrayList<Long>(1);
            blockIdList.add(file.getBlockIdByIndex(fileBlockIndex));
            List<BlockInfo> blockInfoList = this.mBlockMaster.getBlockInfoList(blockIdList);
            if (blockInfoList.size() != 1) {
                throw new BlockInfoException("FileId " + fileId + " BlockIndex " + fileBlockIndex + " is not a valid block.");
            }
            FileBlockInfo blockInfo = this.generateFileBlockInfo(file, blockInfoList.get(0));
            MasterContext.getMasterSource().incFileBlockInfosGot(1L);
            return blockInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FileBlockInfo> getFileBlockInfoList(AlluxioURI path) throws FileDoesNotExistException, InvalidPathException {
        MasterContext.getMasterSource().incGetFileBlockInfoOps(1L);
        InodeTree inodeTree = this.mInodeTree;
        synchronized (inodeTree) {
            Inode inode = this.mInodeTree.getInodeByPath(path);
            if (inode.isDirectory()) {
                throw new FileDoesNotExistException(ExceptionMessage.PATH_MUST_BE_FILE.getMessage(new Object[]{path}));
            }
            InodeFile file = (InodeFile)inode;
            List<BlockInfo> blockInfoList = this.mBlockMaster.getBlockInfoList(file.getBlockIds());
            ArrayList<FileBlockInfo> ret = new ArrayList<FileBlockInfo>();
            for (BlockInfo blockInfo : blockInfoList) {
                ret.add(this.generateFileBlockInfo(file, blockInfo));
            }
            MasterContext.getMasterSource().incFileBlockInfosGot(ret.size());
            return ret;
        }
    }

    private FileBlockInfo generateFileBlockInfo(InodeFile file, BlockInfo blockInfo) throws InvalidPathException {
        FileBlockInfo fileBlockInfo = new FileBlockInfo();
        fileBlockInfo.setBlockInfo(blockInfo);
        fileBlockInfo.setUfsLocations(new ArrayList());
        long offset = file.getBlockSizeBytes() * BlockId.getSequenceNumber((long)blockInfo.getBlockId());
        fileBlockInfo.setOffset(offset);
        if (fileBlockInfo.getBlockInfo().getLocations().isEmpty() && file.isPersisted()) {
            List locs;
            String ufsPath = this.mMountTable.resolve(this.mInodeTree.getPath(file)).toString();
            UnderFileSystem ufs = UnderFileSystem.get((String)ufsPath, (Configuration)MasterContext.getConf());
            try {
                locs = ufs.getFileLocations(ufsPath, fileBlockInfo.getOffset());
            }
            catch (IOException e) {
                return fileBlockInfo;
            }
            if (locs != null) {
                Iterator i$ = locs.iterator();
                while (i$.hasNext()) {
                    int resolvedPort;
                    String resolvedHost;
                    block7: {
                        String loc;
                        resolvedHost = loc = (String)i$.next();
                        resolvedPort = -1;
                        try {
                            String[] ipport = loc.split(":");
                            if (ipport.length != 2) break block7;
                            resolvedHost = ipport[0];
                            resolvedPort = Integer.parseInt(ipport[1]);
                        }
                        catch (NumberFormatException e) {
                            continue;
                        }
                    }
                    fileBlockInfo.getUfsLocations().add(new WorkerNetAddress().setHost(resolvedHost).setDataPort(resolvedPort));
                }
            }
        }
        return fileBlockInfo;
    }

    private boolean isFullyInMemory(InodeFile inode) {
        return this.getInMemoryPercentage(inode) == 100;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AlluxioURI> getInMemoryFiles() {
        ArrayList<AlluxioURI> ret = new ArrayList<AlluxioURI>();
        LinkedList<Pair> nodesQueue = new LinkedList<Pair>();
        InodeTree inodeTree = this.mInodeTree;
        synchronized (inodeTree) {
            nodesQueue.add(new Pair((Object)this.mInodeTree.getRoot(), (Object)new AlluxioURI("/")));
            while (!nodesQueue.isEmpty()) {
                Pair pair = (Pair)nodesQueue.poll();
                InodeDirectory directory = (InodeDirectory)pair.getFirst();
                AlluxioURI curUri = (AlluxioURI)pair.getSecond();
                Set<Inode> children = directory.getChildren();
                for (Inode inode : children) {
                    AlluxioURI newUri = curUri.join(inode.getName());
                    if (inode.isDirectory()) {
                        nodesQueue.add(new Pair((Object)((InodeDirectory)inode), (Object)newUri));
                        continue;
                    }
                    if (!this.isFullyInMemory((InodeFile)inode)) continue;
                    ret.add(newUri);
                }
            }
        }
        return ret;
    }

    private int getInMemoryPercentage(Inode inode) {
        if (!inode.isFile()) {
            return 0;
        }
        InodeFile inodeFile = (InodeFile)inode;
        long length = inodeFile.getLength();
        if (length == 0L) {
            return 100;
        }
        long inMemoryLength = 0L;
        for (BlockInfo info : this.mBlockMaster.getBlockInfoList(inodeFile.getBlockIds())) {
            if (!this.isInTopStorageTier(info)) continue;
            inMemoryLength += info.getLength();
        }
        return (int)(inMemoryLength * 100L / length);
    }

    private boolean isInTopStorageTier(BlockInfo blockInfo) {
        for (BlockLocation location : blockInfo.getLocations()) {
            if (this.mBlockMaster.getGlobalStorageTierAssoc().getOrdinal(location.getTierAlias()) != 0) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InodeTree.CreatePathResult mkdir(AlluxioURI path, CreateDirectoryOptions options) throws InvalidPathException, FileAlreadyExistsException, IOException, AccessControlException {
        LOG.debug("mkdir {} ", (Object)path);
        MasterContext.getMasterSource().incCreateDirectoriesOps(1L);
        InodeTree inodeTree = this.mInodeTree;
        synchronized (inodeTree) {
            try {
                this.checkPermission(FileSystemAction.WRITE, path, true);
                CreatePathOptions createPathOptions = new CreatePathOptions.Builder(MasterContext.getConf()).setAllowExists(options.isAllowExists()).setDirectory(true).setPersisted(options.isPersisted()).setRecursive(options.isRecursive()).setOperationTimeMs(options.getOperationTimeMs()).setPermissionStatus(PermissionStatus.get((Configuration)MasterContext.getConf(), (boolean)true)).build();
                InodeTree.CreatePathResult createResult = this.mInodeTree.createPath(path, createPathOptions);
                LOG.debug("writing journal entry for mkdir {}", (Object)path);
                this.writeJournalEntry(this.mDirectoryIdGenerator.toJournalEntry());
                this.journalCreatePathResult(createResult);
                this.flushJournal();
                LOG.debug("flushed journal for mkdir {}", (Object)path);
                MasterContext.getMasterSource().incDirectoriesCreated(1L);
                return createResult;
            }
            catch (BlockInfoException e) {
                Throwables.propagate((Throwable)e);
            }
        }
        return null;
    }

    private void journalCreatePathResult(InodeTree.CreatePathResult createResult) {
        for (Inode inode : createResult.getModified()) {
            File.InodeLastModificationTimeEntry inodeLastModificationTime = File.InodeLastModificationTimeEntry.newBuilder().setId(inode.getId()).setLastModificationTimeMs(inode.getLastModificationTimeMs()).build();
            this.writeJournalEntry(Journal.JournalEntry.newBuilder().setInodeLastModificationTime(inodeLastModificationTime).build());
        }
        for (Inode inode : createResult.getCreated()) {
            this.writeJournalEntry(inode.toJournalEntry());
        }
        for (Inode inode : createResult.getPersisted()) {
            File.PersistDirectoryEntry persistDirectory = File.PersistDirectoryEntry.newBuilder().setId(inode.getId()).build();
            this.writeJournalEntry(Journal.JournalEntry.newBuilder().setPersistDirectory(persistDirectory).build());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(AlluxioURI srcPath, AlluxioURI dstPath) throws FileAlreadyExistsException, FileDoesNotExistException, InvalidPathException, IOException, AccessControlException {
        MasterContext.getMasterSource().incRenamePathOps(1L);
        InodeTree inodeTree = this.mInodeTree;
        synchronized (inodeTree) {
            this.checkPermission(FileSystemAction.WRITE, srcPath, true);
            this.checkPermission(FileSystemAction.WRITE, dstPath, true);
            Inode srcInode = this.mInodeTree.getInodeByPath(srcPath);
            if (srcPath.equals((Object)dstPath)) {
                return;
            }
            if (srcPath.isRoot()) {
                throw new InvalidPathException(ExceptionMessage.ROOT_CANNOT_BE_RENAMED.getMessage(new Object[0]));
            }
            if (dstPath.isRoot()) {
                throw new InvalidPathException(ExceptionMessage.RENAME_CANNOT_BE_TO_ROOT.getMessage(new Object[0]));
            }
            String srcMount = this.mMountTable.getMountPoint(srcPath);
            String dstMount = this.mMountTable.getMountPoint(dstPath);
            if (srcMount == null && dstMount != null || srcMount != null && dstMount == null || srcMount != null && dstMount != null && !srcMount.equals(dstMount)) {
                throw new InvalidPathException(ExceptionMessage.RENAME_CANNOT_BE_ACROSS_MOUNTS.getMessage(new Object[]{srcPath, dstPath}));
            }
            if (this.mMountTable.isMountPoint(dstPath)) {
                throw new InvalidPathException(ExceptionMessage.RENAME_CANNOT_BE_ONTO_MOUNT_POINT.getMessage(new Object[]{dstPath}));
            }
            if (PathUtils.hasPrefix((String)dstPath.getPath(), (String)srcPath.getPath())) {
                throw new InvalidPathException(ExceptionMessage.RENAME_CANNOT_BE_TO_SUBDIRECTORY.getMessage(new Object[]{srcPath, dstPath}));
            }
            AlluxioURI dstParentURI = dstPath.getParent();
            Inode srcParentInode = this.mInodeTree.getInodeById(srcInode.getParentId());
            if (!srcParentInode.isDirectory()) {
                throw new InvalidPathException(ExceptionMessage.FILE_MUST_HAVE_VALID_PARENT.getMessage(new Object[]{srcPath}));
            }
            Inode dstParentInode = this.mInodeTree.getInodeByPath(dstParentURI);
            if (!dstParentInode.isDirectory()) {
                throw new InvalidPathException(ExceptionMessage.FILE_MUST_HAVE_VALID_PARENT.getMessage(new Object[]{dstPath}));
            }
            InodeDirectory dstParentDirectory = (InodeDirectory)dstParentInode;
            String[] dstComponents = PathUtils.getPathComponents((String)dstPath.getPath());
            if (dstParentDirectory.getChild(dstComponents[dstComponents.length - 1]) != null) {
                throw new FileAlreadyExistsException(ExceptionMessage.FILE_ALREADY_EXISTS.getMessage(new Object[]{dstPath}));
            }
            long opTimeMs = System.currentTimeMillis();
            this.renameInternal(srcInode.getId(), dstPath, false, opTimeMs);
            File.RenameEntry rename = File.RenameEntry.newBuilder().setId(srcInode.getId()).setDstPath(dstPath.getPath()).setOpTimeMs(opTimeMs).build();
            this.writeJournalEntry(Journal.JournalEntry.newBuilder().setRename(rename).build());
            this.flushJournal();
            LOG.debug("Renamed {} to {}", (Object)srcPath, (Object)dstPath);
        }
    }

    void renameInternal(long fileId, AlluxioURI dstPath, boolean replayed, long opTimeMs) throws FileDoesNotExistException, InvalidPathException, IOException {
        Inode srcInode = this.mInodeTree.getInodeById(fileId);
        AlluxioURI srcPath = this.mInodeTree.getPath(srcInode);
        LOG.debug("Renaming {} to {}", (Object)srcPath, (Object)dstPath);
        FileInfo fileInfo = this.getFileInfoInternal(srcInode);
        if (!replayed && fileInfo.isPersisted()) {
            String parentPath;
            String ufsSrcPath = this.mMountTable.resolve(srcPath).toString();
            String ufsDstPath = this.mMountTable.resolve(dstPath).toString();
            UnderFileSystem ufs = UnderFileSystem.get((String)ufsSrcPath, (Configuration)MasterContext.getConf());
            if (!ufs.exists(parentPath = new AlluxioURI(ufsDstPath).getParent().toString()) && !ufs.mkdirs(parentPath, true)) {
                throw new IOException(ExceptionMessage.FAILED_UFS_CREATE.getMessage(new Object[]{parentPath}));
            }
            if (!ufs.rename(ufsSrcPath, ufsDstPath)) {
                throw new IOException(ExceptionMessage.FAILED_UFS_RENAME.getMessage(new Object[]{ufsSrcPath, ufsDstPath}));
            }
        }
        Inode srcParentInode = this.mInodeTree.getInodeById(srcInode.getParentId());
        AlluxioURI dstParentURI = dstPath.getParent();
        Inode dstParentInode = this.mInodeTree.getInodeByPath(dstParentURI);
        ((InodeDirectory)srcParentInode).removeChild(srcInode);
        srcParentInode.setLastModificationTimeMs(opTimeMs);
        srcInode.setParentId(dstParentInode.getId());
        srcInode.setName(dstPath.getName());
        ((InodeDirectory)dstParentInode).addChild(srcInode);
        dstParentInode.setLastModificationTimeMs(opTimeMs);
        MasterContext.getMasterSource().incPathsRenamed(1L);
        this.propagatePersisted(srcInode, replayed);
    }

    private void renameFromEntry(File.RenameEntry entry) {
        MasterContext.getMasterSource().incRenamePathOps(1L);
        try {
            this.renameInternal(entry.getId(), new AlluxioURI(entry.getDstPath()), true, entry.getOpTimeMs());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void propagatePersisted(Inode inode, boolean replayed) throws FileDoesNotExistException {
        AlluxioURI path;
        if (!inode.isPersisted()) {
            return;
        }
        Inode handle = inode;
        while (handle.getParentId() != -1L && !this.mMountTable.isMountPoint(path = this.mInodeTree.getPath(handle = this.mInodeTree.getInodeById(handle.getParentId()))) && !handle.isPersisted()) {
            handle.setPersistenceState(PersistenceState.PERSISTED);
            if (replayed) continue;
            File.PersistDirectoryEntry persistDirectory = File.PersistDirectoryEntry.newBuilder().setId(inode.getId()).build();
            this.writeJournalEntry(Journal.JournalEntry.newBuilder().setPersistDirectory(persistDirectory).build());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean free(AlluxioURI path, boolean recursive) throws FileDoesNotExistException, InvalidPathException, AccessControlException {
        MasterContext.getMasterSource().incFreeFileOps(1L);
        InodeTree inodeTree = this.mInodeTree;
        synchronized (inodeTree) {
            this.checkPermission(FileSystemAction.WRITE, path, false);
            Inode inode = this.mInodeTree.getInodeByPath(path);
            if (inode.isDirectory() && !recursive && ((InodeDirectory)inode).getNumberOfChildren() > 0) {
                return false;
            }
            ArrayList<Inode> freeInodes = new ArrayList<Inode>();
            freeInodes.add(inode);
            if (inode.isDirectory()) {
                freeInodes.addAll(this.mInodeTree.getInodeChildrenRecursive((InodeDirectory)inode));
            }
            for (int i = freeInodes.size() - 1; i >= 0; --i) {
                Inode freeInode = (Inode)freeInodes.get(i);
                if (!freeInode.isFile()) continue;
                this.mBlockMaster.removeBlocks(((InodeFile)freeInode).getBlockIds());
            }
            MasterContext.getMasterSource().incFilesFreed(freeInodes.size());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlluxioURI getPath(long fileId) throws FileDoesNotExistException {
        InodeTree inodeTree = this.mInodeTree;
        synchronized (inodeTree) {
            return this.mInodeTree.getPath(this.mInodeTree.getInodeById(fileId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Long> getPinIdList() {
        InodeTree inodeTree = this.mInodeTree;
        synchronized (inodeTree) {
            return this.mInodeTree.getPinIdSet();
        }
    }

    public String getUfsAddress() {
        return MasterContext.getConf().get("alluxio.underfs.address");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getWhiteList() {
        InodeTree inodeTree = this.mInodeTree;
        synchronized (inodeTree) {
            return this.mWhitelist.getList();
        }
    }

    public List<Long> getLostFiles() {
        HashSet lostFiles = Sets.newHashSet();
        for (long blockId : this.mBlockMaster.getLostBlocks()) {
            long containerId = BlockId.getContainerId((long)blockId);
            long fileId = IdUtils.createFileId((long)containerId);
            lostFiles.add(fileId);
        }
        return new ArrayList<Long>(lostFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportLostFile(long fileId) throws FileDoesNotExistException {
        InodeTree inodeTree = this.mInodeTree;
        synchronized (inodeTree) {
            Inode inode = this.mInodeTree.getInodeById(fileId);
            if (inode.isDirectory()) {
                LOG.warn("Reported file is a directory {}", (Object)inode);
                return;
            }
            ArrayList blockIds = Lists.newArrayList();
            try {
                for (FileBlockInfo fileBlockInfo : this.getFileBlockInfoList(this.getPath(fileId))) {
                    blockIds.add(fileBlockInfo.getBlockInfo().getBlockId());
                }
            }
            catch (InvalidPathException e) {
                LOG.info("Failed to get file info {}", (Object)fileId, (Object)e);
            }
            this.mBlockMaster.reportLostBlocks(blockIds);
            LOG.info("Reported file loss of blocks {}. Alluxio will recompute it: {}", (Object)blockIds, (Object)fileId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long loadMetadata(AlluxioURI path, boolean recursive) throws BlockInfoException, FileAlreadyExistsException, FileDoesNotExistException, InvalidPathException, InvalidFileSizeException, FileAlreadyCompletedException, IOException, AccessControlException {
        AlluxioURI ufsPath;
        InodeTree inodeTree = this.mInodeTree;
        synchronized (inodeTree) {
            this.checkPermission(FileSystemAction.READ, path, false);
            ufsPath = this.mMountTable.resolve(path);
        }
        UnderFileSystem ufs = UnderFileSystem.get((String)ufsPath.toString(), (Configuration)MasterContext.getConf());
        try {
            if (!ufs.exists(ufsPath.getPath())) {
                throw new FileDoesNotExistException(ExceptionMessage.PATH_DOES_NOT_EXIST.getMessage(new Object[]{path.getPath()}));
            }
            if (ufs.isFile(ufsPath.getPath())) {
                long ufsBlockSizeByte = ufs.getBlockSizeByte(ufsPath.toString());
                long ufsLength = ufs.getFileSize(ufsPath.toString());
                CreateFileOptions createFileOptions = new CreateFileOptions.Builder(MasterContext.getConf()).setBlockSizeBytes(ufsBlockSizeByte).setRecursive(recursive).setPersisted(true).build();
                long fileId = this.create(path, createFileOptions);
                CompleteFileOptions completeOptions = new CompleteFileOptions.Builder(MasterContext.getConf()).setUfsLength(ufsLength).build();
                this.completeFile(path, completeOptions);
                return fileId;
            }
            return this.loadMetadataDirectory(path, recursive);
        }
        catch (IOException e) {
            LOG.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw e;
        }
    }

    private long loadMetadataDirectory(AlluxioURI path, boolean recursive) throws IOException, FileAlreadyExistsException, InvalidPathException, AccessControlException {
        CreateDirectoryOptions options = new CreateDirectoryOptions.Builder(MasterContext.getConf()).setRecursive(recursive).setPersisted(true).build();
        InodeTree.CreatePathResult result = this.mkdir(path, options);
        List<Inode> inodes = null;
        if (result.getCreated().size() > 0) {
            inodes = result.getCreated();
        } else if (result.getPersisted().size() > 0) {
            inodes = result.getPersisted();
        } else if (result.getModified().size() > 0) {
            inodes = result.getModified();
        }
        if (inodes == null) {
            throw new FileAlreadyExistsException(ExceptionMessage.FILE_ALREADY_EXISTS.getMessage(new Object[]{path}));
        }
        return inodes.get(inodes.size() - 1).getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mount(AlluxioURI alluxioPath, AlluxioURI ufsPath) throws FileAlreadyExistsException, InvalidPathException, IOException, AccessControlException {
        MasterContext.getMasterSource().incMountOps(1L);
        InodeTree inodeTree = this.mInodeTree;
        synchronized (inodeTree) {
            this.checkPermission(FileSystemAction.WRITE, alluxioPath, true);
            this.mountInternal(alluxioPath, ufsPath);
            boolean loadMetadataSuceeded = false;
            try {
                this.loadMetadataDirectory(alluxioPath, false);
                loadMetadataSuceeded = true;
            }
            finally {
                if (!loadMetadataSuceeded) {
                    this.unmountInternal(alluxioPath);
                }
            }
            File.AddMountPointEntry addMountPoint = File.AddMountPointEntry.newBuilder().setAlluxioPath(alluxioPath.toString()).setUfsPath(ufsPath.toString()).build();
            this.writeJournalEntry(Journal.JournalEntry.newBuilder().setAddMountPoint(addMountPoint).build());
            this.flushJournal();
            MasterContext.getMasterSource().incPathsMounted(1L);
        }
    }

    void mountFromEntry(File.AddMountPointEntry entry) throws FileAlreadyExistsException, InvalidPathException, IOException {
        AlluxioURI alluxioURI = new AlluxioURI(entry.getAlluxioPath());
        AlluxioURI ufsURI = new AlluxioURI(entry.getUfsPath());
        this.mountInternal(alluxioURI, ufsURI);
    }

    void mountInternal(AlluxioURI alluxioPath, AlluxioURI ufsPath) throws FileAlreadyExistsException, InvalidPathException, IOException {
        UnderFileSystem ufs = UnderFileSystem.get((String)ufsPath.toString(), (Configuration)MasterContext.getConf());
        if (!ufs.exists(ufsPath.getPath())) {
            throw new IOException(ExceptionMessage.UFS_PATH_DOES_NOT_EXIST.getMessage(new Object[]{ufsPath.getPath()}));
        }
        if (ufs.isFile(ufsPath.getPath())) {
            throw new IOException(ExceptionMessage.PATH_MUST_BE_DIRECTORY.getMessage(new Object[]{ufsPath.getPath()}));
        }
        String defaultUfsPath = MasterContext.getConf().get("alluxio.underfs.address");
        UnderFileSystem defaultUfs = UnderFileSystem.get((String)defaultUfsPath, (Configuration)MasterContext.getConf());
        if (defaultUfs.exists(PathUtils.concatPath((Object)defaultUfsPath, (Object[])new Object[]{alluxioPath.getPath()}))) {
            throw new IOException(ExceptionMessage.MOUNT_PATH_SHADOWS_DEFAULT_UFS.getMessage(new Object[]{alluxioPath}));
        }
        this.mMountTable.add(alluxioPath, ufsPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unmount(AlluxioURI alluxioPath) throws FileDoesNotExistException, InvalidPathException, IOException, AccessControlException {
        MasterContext.getMasterSource().incUnmountOps(1L);
        InodeTree inodeTree = this.mInodeTree;
        synchronized (inodeTree) {
            this.checkPermission(FileSystemAction.WRITE, alluxioPath, true);
            if (this.unmountInternal(alluxioPath)) {
                Inode inode = this.mInodeTree.getInodeByPath(alluxioPath);
                long fileId = inode.getId();
                long opTimeMs = System.currentTimeMillis();
                this.deleteFileRecursiveInternal(fileId, true, opTimeMs);
                File.DeleteFileEntry deleteFile = File.DeleteFileEntry.newBuilder().setId(fileId).setRecursive(true).setOpTimeMs(opTimeMs).build();
                this.writeJournalEntry(Journal.JournalEntry.newBuilder().setDeleteFile(deleteFile).build());
                File.DeleteMountPointEntry deleteMountPoint = File.DeleteMountPointEntry.newBuilder().setAlluxioPath(alluxioPath.toString()).build();
                this.writeJournalEntry(Journal.JournalEntry.newBuilder().setDeleteMountPoint(deleteMountPoint).build());
                this.flushJournal();
                MasterContext.getMasterSource().incPathsUnmounted(1L);
                return true;
            }
        }
        return false;
    }

    void unmountFromEntry(File.DeleteMountPointEntry entry) throws InvalidPathException {
        AlluxioURI alluxioURI = new AlluxioURI(entry.getAlluxioPath());
        if (!this.unmountInternal(alluxioURI)) {
            LOG.error("Failed to unmount {}", (Object)alluxioURI);
        }
    }

    boolean unmountInternal(AlluxioURI alluxioPath) throws InvalidPathException {
        return this.mMountTable.delete(alluxioPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetFile(long fileId) throws FileDoesNotExistException, InvalidPathException, AccessControlException {
        InodeTree inodeTree = this.mInodeTree;
        synchronized (inodeTree) {
            this.free(this.getPath(fileId), false);
            InodeFile inodeFile = (InodeFile)this.mInodeTree.getInodeById(fileId);
            inodeFile.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(AlluxioURI path, SetAttributeOptions options) throws FileDoesNotExistException, AccessControlException, InvalidPathException {
        MasterContext.getMasterSource().incSetAttributeOps(1L);
        boolean rootRequired = options.getOwner() != null;
        boolean ownerRequired = options.getGroup() != null || options.getPermission() != -1;
        InodeTree inodeTree = this.mInodeTree;
        synchronized (inodeTree) {
            this.checkSetAttributePermission(path, rootRequired, ownerRequired);
            long fileId = this.mInodeTree.getInodeByPath(path).getId();
            long opTimeMs = System.currentTimeMillis();
            Inode targetInode = this.mInodeTree.getInodeByPath(path);
            if (options.isRecursive() && targetInode.isDirectory()) {
                List<Inode> inodeChildren = this.mInodeTree.getInodeChildrenRecursive((InodeDirectory)targetInode);
                for (Inode inode : inodeChildren) {
                    this.checkSetAttributePermission(this.mInodeTree.getPath(inode), rootRequired, ownerRequired);
                }
                for (Inode inode : inodeChildren) {
                    long id = inode.getId();
                    this.setAttributeInternal(id, opTimeMs, options);
                    this.journalSetAttribute(id, opTimeMs, options);
                }
            }
            this.setAttributeInternal(fileId, opTimeMs, options);
            this.journalSetAttribute(fileId, opTimeMs, options);
        }
    }

    private void journalSetAttribute(long fileId, long opTimeMs, SetAttributeOptions options) {
        File.SetAttributeEntry.Builder builder = File.SetAttributeEntry.newBuilder().setId(fileId).setOpTimeMs(opTimeMs);
        if (options.getPinned() != null) {
            builder.setPinned(options.getPinned());
        }
        if (options.getTtl() != null) {
            builder.setTtl(options.getTtl());
        }
        if (options.getPersisted() != null) {
            builder.setPersisted(options.getPersisted());
        }
        if (options.getOwner() != null) {
            builder.setOwner(options.getOwner());
        }
        if (options.getGroup() != null) {
            builder.setGroup(options.getGroup());
        }
        if (options.getPermission() != -1) {
            builder.setPermission(options.getPermission().shortValue());
        }
        this.writeJournalEntry(Journal.JournalEntry.newBuilder().setSetAttribute(builder).build());
        this.flushJournal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long scheduleAsyncPersistence(AlluxioURI path) throws FileDoesNotExistException, InvalidPathException {
        InodeTree inodeTree = this.mInodeTree;
        synchronized (inodeTree) {
            long workerId = this.scheduleAsyncPersistenceInternal(path);
            long fileId = this.mInodeTree.getInodeByPath(path).getId();
            File.AsyncPersistRequestEntry asyncPersistRequestEntry = File.AsyncPersistRequestEntry.newBuilder().setFileId(fileId).build();
            this.writeJournalEntry(Journal.JournalEntry.newBuilder().setAsyncPersistRequest(asyncPersistRequestEntry).build());
            this.flushJournal();
            return workerId;
        }
    }

    private long scheduleAsyncPersistenceInternal(AlluxioURI path) throws FileDoesNotExistException, InvalidPathException {
        long workerId = this.getWorkerStoringFile(path);
        if (workerId == -1L) {
            LOG.warn("No worker found to schedule async persistence for file {}", (Object)path);
            return workerId;
        }
        Inode inode = this.mInodeTree.getInodeByPath(path);
        inode.setPersistenceState(PersistenceState.IN_PROGRESS);
        long fileId = inode.getId();
        if (!this.mWorkerToAsyncPersistFiles.containsKey(workerId)) {
            this.mWorkerToAsyncPersistFiles.put(workerId, Sets.newHashSet());
        }
        this.mWorkerToAsyncPersistFiles.get(workerId).add(fileId);
        return workerId;
    }

    private long getWorkerStoringFile(AlluxioURI path) throws FileDoesNotExistException {
        HashMap workerBlockCounts = Maps.newHashMap();
        try {
            List<FileBlockInfo> blockInfoList = this.getFileBlockInfoList(path);
            for (FileBlockInfo fileBlockInfo : blockInfoList) {
                for (BlockLocation blockLocation : fileBlockInfo.getBlockInfo().getLocations()) {
                    if (workerBlockCounts.containsKey(blockLocation.getWorkerId())) {
                        workerBlockCounts.put(blockLocation.getWorkerId(), (Integer)workerBlockCounts.get(blockLocation.getWorkerId()) + 1);
                    } else {
                        workerBlockCounts.put(blockLocation.getWorkerId(), 1);
                    }
                    if (((Integer)workerBlockCounts.get(blockLocation.getWorkerId())).intValue() != blockInfoList.size()) continue;
                    return blockLocation.getWorkerId();
                }
            }
        }
        catch (FileDoesNotExistException e) {
            LOG.error("The file {} to persist does not exist", (Object)path);
            return -1L;
        }
        catch (InvalidPathException e) {
            LOG.error("The file {} to persist is invalid", (Object)path);
            return -1L;
        }
        if (workerBlockCounts.size() == 0) {
            LOG.error("The file " + path + " does not exist on any worker");
            return -1L;
        }
        LOG.error("Not all the blocks of file {} stored on the same worker", (Object)path);
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PersistFile> pollFilesToCheckpoint(long workerId) throws FileDoesNotExistException, InvalidPathException {
        ArrayList filesToPersist = Lists.newArrayList();
        ArrayList fileIdsToPersist = Lists.newArrayList();
        InodeTree inodeTree = this.mInodeTree;
        synchronized (inodeTree) {
            if (!this.mWorkerToAsyncPersistFiles.containsKey(workerId)) {
                return filesToPersist;
            }
            Set<Long> scheduledFiles = this.mWorkerToAsyncPersistFiles.get(workerId);
            for (long fileId : scheduledFiles) {
                InodeFile inode = (InodeFile)this.mInodeTree.getInodeById(fileId);
                if (!inode.isCompleted()) continue;
                fileIdsToPersist.add(fileId);
                ArrayList blockIds = Lists.newArrayList();
                for (FileBlockInfo fileBlockInfo : this.getFileBlockInfoList(this.mInodeTree.getPath(inode))) {
                    blockIds.add(fileBlockInfo.getBlockInfo().getBlockId());
                }
                filesToPersist.add(new PersistFile(fileId, (List)blockIds));
                inode.setPersistenceState(PersistenceState.IN_PROGRESS);
            }
            this.mWorkerToAsyncPersistFiles.get(workerId).removeAll(fileIdsToPersist);
        }
        return filesToPersist;
    }

    public synchronized FileSystemCommand workerHeartbeat(long workerId, List<Long> persistedFiles) throws FileDoesNotExistException, InvalidPathException, AccessControlException {
        for (long fileId : persistedFiles) {
            this.setAttribute(this.getPath(fileId), new SetAttributeOptions.Builder().setPersisted(true).build());
        }
        List<PersistFile> filesToCheckpoint = this.pollFilesToCheckpoint(workerId);
        if (!filesToCheckpoint.isEmpty()) {
            LOG.debug("Sent files {} to worker {} to persist", filesToCheckpoint, (Object)workerId);
        }
        FileSystemCommandOptions options = new FileSystemCommandOptions();
        options.setPersistOptions(new PersistCommandOptions(filesToCheckpoint));
        return new FileSystemCommand(CommandType.Persist, options);
    }

    private void setAttributeInternal(long fileId, long opTimeMs, SetAttributeOptions options) throws FileDoesNotExistException {
        Inode inode = this.mInodeTree.getInodeById(fileId);
        if (options.getPinned() != null) {
            this.mInodeTree.setPinned(inode, options.getPinned(), opTimeMs);
            inode.setLastModificationTimeMs(opTimeMs);
        }
        if (options.getTtl() != null) {
            Preconditions.checkArgument((boolean)inode.isFile(), (Object)"TTL can only be set for files");
            long ttl = options.getTtl();
            InodeFile file = (InodeFile)inode;
            if (file.getTtl() != ttl) {
                this.mTtlBuckets.remove(file);
                file.setTtl(ttl);
                this.mTtlBuckets.insert(file);
                file.setLastModificationTimeMs(opTimeMs);
            }
        }
        if (options.getPersisted() != null) {
            Preconditions.checkArgument((boolean)inode.isFile(), (Object)"Only files can be persisted");
            Preconditions.checkArgument((boolean)((InodeFile)inode).isCompleted(), (Object)"File being persisted must be complete");
            InodeFile file = (InodeFile)inode;
            Preconditions.checkArgument((boolean)options.getPersisted(), (Object)"Cannot set the state of a file to not-persisted");
            if (!file.isPersisted()) {
                file.setPersistenceState(PersistenceState.PERSISTED);
                this.propagatePersisted(file, false);
                file.setLastModificationTimeMs(opTimeMs);
                MasterContext.getMasterSource().incFilesPersisted(1L);
            }
        }
        if (options.getOwner() != null) {
            inode.setUserName(options.getOwner());
        }
        if (options.getGroup() != null) {
            inode.setGroupName(options.getGroup());
        }
        if (options.getPermission() != -1) {
            inode.setPermission(options.getPermission());
        }
    }

    private void setAttributeFromEntry(File.SetAttributeEntry entry) throws FileDoesNotExistException {
        SetAttributeOptions.Builder options = new SetAttributeOptions.Builder();
        if (entry.hasPinned()) {
            options.setPinned(entry.getPinned());
        }
        if (entry.hasTtl()) {
            options.setTtl(entry.getTtl());
        }
        if (entry.hasPersisted()) {
            options.setPersisted(entry.getPersisted());
        }
        if (entry.hasOwner()) {
            options.setOwner(entry.getOwner());
        }
        if (entry.hasGroup()) {
            options.setGroup(entry.getGroup());
        }
        if (entry.hasPermission()) {
            options.setPermission((short)entry.getPermission());
        }
        this.setAttributeInternal(entry.getId(), entry.getOpTimeMs(), options.build());
    }

    private void checkOwner(AlluxioURI path) throws AccessControlException, InvalidPathException {
        if (!SecurityUtils.isSecurityEnabled((Configuration)MasterContext.getConf())) {
            return;
        }
        List<FileInfo> fileInfos = this.collectFileInfoList(path);
        String user = this.getClientUser();
        List<String> groups = this.getGroups(user);
        PermissionChecker.checkOwner(user, groups, path, fileInfos);
    }

    private void checkSetAttributePermission(AlluxioURI path, boolean rootRequired, boolean ownerRequired) throws AccessControlException, InvalidPathException {
        if (!SecurityUtils.isSecurityEnabled((Configuration)MasterContext.getConf())) {
            return;
        }
        if (rootRequired) {
            PermissionChecker.checkSuperuser(this.getClientUser(), this.getGroups(this.getClientUser()));
        }
        if (ownerRequired) {
            this.checkOwner(path);
        }
        this.checkPermission(FileSystemAction.WRITE, path, false);
    }

    private void checkPermission(FileSystemAction action, AlluxioURI path, boolean checkParent) throws AccessControlException {
        if (!SecurityUtils.isSecurityEnabled((Configuration)MasterContext.getConf())) {
            return;
        }
        try {
            List<FileInfo> fileInfos = this.collectFileInfoList(path);
            String user = this.getClientUser();
            List<String> groups = this.getGroups(user);
            String[] pathComponents = PathUtils.getPathComponents((String)path.getPath());
            if (checkParent) {
                if (action.equals((Object)FileSystemAction.WRITE) && fileInfos.size() == 1 && pathComponents.length > 1 || fileInfos.size() == 2 && pathComponents.length == 2) {
                    PermissionChecker.checkOwner(user, groups, path, fileInfos);
                } else {
                    PermissionChecker.checkParentPermission(user, groups, action, path, fileInfos);
                }
            } else {
                PermissionChecker.checkPermission(user, groups, action, path, fileInfos);
            }
        }
        catch (InvalidPathException e) {
            LOG.warn("Invalid Path {} for checking permission: " + e.getMessage(), (Object)path);
        }
    }

    private String getClientUser() throws AccessControlException {
        try {
            User authorizedUser = PlainSaslServer.AuthorizedClientUser.get((Configuration)MasterContext.getConf());
            if (authorizedUser == null) {
                throw new AccessControlException(ExceptionMessage.AUTHORIZED_CLIENT_USER_IS_NULL.getMessage(new Object[0]));
            }
            return authorizedUser.getName();
        }
        catch (IOException e) {
            throw new AccessControlException(e.getMessage());
        }
    }

    private List<String> getGroups(String user) throws AccessControlException {
        try {
            return this.mGroupMappingService.getGroups(user);
        }
        catch (IOException e) {
            throw new AccessControlException(ExceptionMessage.PERMISSION_DENIED.getMessage(new Object[]{e.getMessage()}));
        }
    }

    private List<FileInfo> collectFileInfoList(AlluxioURI path) throws InvalidPathException {
        ArrayList fileInfos = Lists.newArrayList();
        for (Inode inodeOnPath : this.mInodeTree.collectInodes(path)) {
            fileInfos.add(inodeOnPath.generateClientFileInfo(this.mInodeTree.getPath(inodeOnPath).toString()));
        }
        String[] pathComponents = PathUtils.getPathComponents((String)path.getPath());
        if (pathComponents.length < fileInfos.size()) {
            throw new InvalidPathException(ExceptionMessage.PATH_INVALID.getMessage(new Object[]{path.getPath()}));
        }
        return fileInfos;
    }

    private final class LostFilesDetectionHeartbeatExecutor
    implements HeartbeatExecutor {
        private LostFilesDetectionHeartbeatExecutor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void heartbeat() {
            for (long fileId : FileSystemMaster.this.getLostFiles()) {
                InodeTree inodeTree = FileSystemMaster.this.mInodeTree;
                synchronized (inodeTree) {
                    try {
                        Inode inode = FileSystemMaster.this.mInodeTree.getInodeById(fileId);
                        if (inode.getPersistenceState() != PersistenceState.PERSISTED) {
                            inode.setPersistenceState(PersistenceState.LOST);
                        }
                    }
                    catch (FileDoesNotExistException e) {
                        // empty catch block
                    }
                }
            }
        }

        public void close() {
        }
    }

    private final class MasterInodeTtlCheckExecutor
    implements HeartbeatExecutor {
        private MasterInodeTtlCheckExecutor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void heartbeat() {
            InodeTree inodeTree = FileSystemMaster.this.mInodeTree;
            synchronized (inodeTree) {
                Set<TtlBucket> expiredBuckets = FileSystemMaster.this.mTtlBuckets.getExpiredBuckets(System.currentTimeMillis());
                for (TtlBucket bucket : expiredBuckets) {
                    for (InodeFile file : bucket.getFiles()) {
                        if (file.isDeleted()) continue;
                        try {
                            FileSystemMaster.this.deleteFile(FileSystemMaster.this.mInodeTree.getPath(file), false);
                        }
                        catch (Exception e) {
                            LOG.error("Exception trying to clean up {} for ttl check: {}", (Object)file.toString(), (Object)e.toString());
                        }
                    }
                }
                FileSystemMaster.this.mTtlBuckets.removeBuckets(expiredBuckets);
            }
        }

        public void close() {
        }
    }
}

