/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.file;

import alluxio.AlluxioURI;
import alluxio.exception.AlluxioException;
import alluxio.exception.FileDoesNotExistException;
import alluxio.exception.InvalidPathException;
import alluxio.master.file.FileSystemMaster;
import alluxio.master.file.options.CompleteFileOptions;
import alluxio.master.file.options.CreateDirectoryOptions;
import alluxio.master.file.options.CreateFileOptions;
import alluxio.master.file.options.SetAttributeOptions;
import alluxio.thrift.AlluxioTException;
import alluxio.thrift.CompleteFileTOptions;
import alluxio.thrift.CreateDirectoryTOptions;
import alluxio.thrift.CreateFileTOptions;
import alluxio.thrift.FileBlockInfo;
import alluxio.thrift.FileSystemMasterClientService;
import alluxio.thrift.SetAttributeTOptions;
import alluxio.thrift.ThriftIOException;
import alluxio.wire.FileInfo;
import alluxio.wire.ThriftUtils;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class FileSystemMasterClientServiceHandler
implements FileSystemMasterClientService.Iface {
    private final FileSystemMaster mFileSystemMaster;

    public FileSystemMasterClientServiceHandler(FileSystemMaster fileSystemMaster) {
        Preconditions.checkNotNull((Object)fileSystemMaster);
        this.mFileSystemMaster = fileSystemMaster;
    }

    public long getServiceVersion() {
        return 1L;
    }

    public void completeFile(String path, CompleteFileTOptions options) throws AlluxioTException {
        try {
            this.mFileSystemMaster.completeFile(new AlluxioURI(path), new CompleteFileOptions(options));
        }
        catch (AlluxioException e) {
            throw e.toAlluxioTException();
        }
    }

    public void createDirectory(String path, CreateDirectoryTOptions options) throws AlluxioTException, ThriftIOException {
        try {
            this.mFileSystemMaster.mkdir(new AlluxioURI(path), new CreateDirectoryOptions(options));
        }
        catch (AlluxioException e) {
            throw e.toAlluxioTException();
        }
        catch (IOException e) {
            throw new ThriftIOException(e.getMessage());
        }
    }

    public void createFile(String path, CreateFileTOptions options) throws AlluxioTException, ThriftIOException {
        try {
            this.mFileSystemMaster.create(new AlluxioURI(path), new CreateFileOptions(options));
        }
        catch (IOException e) {
            throw new ThriftIOException(e.getMessage());
        }
        catch (AlluxioException e) {
            throw e.toAlluxioTException();
        }
    }

    public void free(String path, boolean recursive) throws AlluxioTException {
        try {
            this.mFileSystemMaster.free(new AlluxioURI(path), recursive);
        }
        catch (AlluxioException e) {
            throw e.toAlluxioTException();
        }
    }

    public List<FileBlockInfo> getFileBlockInfoList(String path) throws AlluxioTException {
        try {
            ArrayList<FileBlockInfo> result = new ArrayList<FileBlockInfo>();
            for (alluxio.wire.FileBlockInfo fileBlockInfo : this.mFileSystemMaster.getFileBlockInfoList(new AlluxioURI(path))) {
                result.add(ThriftUtils.toThrift((alluxio.wire.FileBlockInfo)fileBlockInfo));
            }
            return result;
        }
        catch (AlluxioException e) {
            throw e.toAlluxioTException();
        }
    }

    public long getNewBlockIdForFile(String path) throws AlluxioTException {
        try {
            return this.mFileSystemMaster.getNewBlockIdForFile(new AlluxioURI(path));
        }
        catch (AlluxioException e) {
            throw e.toAlluxioTException();
        }
    }

    public alluxio.thrift.FileInfo getStatus(String path) throws AlluxioTException {
        try {
            return ThriftUtils.toThrift((FileInfo)this.mFileSystemMaster.getFileInfo(new AlluxioURI(path)));
        }
        catch (AlluxioException e) {
            throw e.toAlluxioTException();
        }
    }

    public alluxio.thrift.FileInfo getStatusInternal(long fileId) throws AlluxioTException {
        try {
            return ThriftUtils.toThrift((FileInfo)this.mFileSystemMaster.getFileInfo(fileId));
        }
        catch (AlluxioException e) {
            throw e.toAlluxioTException();
        }
    }

    public String getUfsAddress() {
        return this.mFileSystemMaster.getUfsAddress();
    }

    public List<alluxio.thrift.FileInfo> listStatus(String path) throws AlluxioTException {
        try {
            ArrayList<alluxio.thrift.FileInfo> result = new ArrayList<alluxio.thrift.FileInfo>();
            for (FileInfo fileInfo : this.mFileSystemMaster.getFileInfoList(new AlluxioURI(path))) {
                result.add(ThriftUtils.toThrift((FileInfo)fileInfo));
            }
            return result;
        }
        catch (AlluxioException e) {
            throw e.toAlluxioTException();
        }
    }

    public long loadMetadata(String alluxioPath, boolean recursive) throws AlluxioTException, ThriftIOException {
        try {
            return this.mFileSystemMaster.loadMetadata(new AlluxioURI(alluxioPath), recursive);
        }
        catch (AlluxioException e) {
            throw e.toAlluxioTException();
        }
        catch (IOException e) {
            throw new ThriftIOException(e.getMessage());
        }
    }

    public void mount(String alluxioPath, String ufsPath) throws AlluxioTException, ThriftIOException {
        try {
            this.mFileSystemMaster.mount(new AlluxioURI(alluxioPath), new AlluxioURI(ufsPath));
        }
        catch (AlluxioException e) {
            throw e.toAlluxioTException();
        }
        catch (IOException e) {
            throw new ThriftIOException(e.getMessage());
        }
    }

    public void remove(String path, boolean recursive) throws AlluxioTException, ThriftIOException {
        try {
            this.mFileSystemMaster.deleteFile(new AlluxioURI(path), recursive);
        }
        catch (AlluxioException e) {
            throw e.toAlluxioTException();
        }
        catch (IOException e) {
            throw new ThriftIOException(e.getMessage());
        }
    }

    public void rename(String srcPath, String dstPath) throws AlluxioTException, ThriftIOException {
        try {
            this.mFileSystemMaster.rename(new AlluxioURI(srcPath), new AlluxioURI(dstPath));
        }
        catch (AlluxioException e) {
            throw e.toAlluxioTException();
        }
        catch (IOException e) {
            throw new ThriftIOException(e.getMessage());
        }
    }

    public void scheduleAsyncPersist(String path) throws AlluxioTException {
        try {
            this.mFileSystemMaster.scheduleAsyncPersistence(new AlluxioURI(path));
        }
        catch (FileDoesNotExistException e) {
            throw e.toAlluxioTException();
        }
        catch (InvalidPathException e) {
            throw e.toAlluxioTException();
        }
    }

    public void setAttribute(String path, SetAttributeTOptions options) throws AlluxioTException {
        try {
            this.mFileSystemMaster.setAttribute(new AlluxioURI(path), new SetAttributeOptions(options));
        }
        catch (AlluxioException e) {
            throw e.toAlluxioTException();
        }
    }

    public void unmount(String alluxioPath) throws AlluxioTException, ThriftIOException {
        try {
            this.mFileSystemMaster.unmount(new AlluxioURI(alluxioPath));
        }
        catch (AlluxioException e) {
            throw e.toAlluxioTException();
        }
        catch (IOException e) {
            throw new ThriftIOException(e.getMessage());
        }
    }
}

