/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.file;

import alluxio.exception.AccessControlException;
import alluxio.exception.AlluxioException;
import alluxio.exception.FileDoesNotExistException;
import alluxio.exception.InvalidPathException;
import alluxio.master.file.FileSystemMaster;
import alluxio.thrift.AlluxioTException;
import alluxio.thrift.FileInfo;
import alluxio.thrift.FileSystemCommand;
import alluxio.thrift.FileSystemMasterWorkerService;
import alluxio.wire.ThriftUtils;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.thrift.TException;

@NotThreadSafe
public final class FileSystemMasterWorkerServiceHandler
implements FileSystemMasterWorkerService.Iface {
    private final FileSystemMaster mFileSystemMaster;

    public FileSystemMasterWorkerServiceHandler(FileSystemMaster fileSystemMaster) {
        Preconditions.checkNotNull((Object)fileSystemMaster);
        this.mFileSystemMaster = fileSystemMaster;
    }

    public long getServiceVersion() {
        return 1L;
    }

    public FileInfo getFileInfo(long fileId) throws AlluxioTException {
        try {
            return ThriftUtils.toThrift((alluxio.wire.FileInfo)this.mFileSystemMaster.getFileInfo(fileId));
        }
        catch (AlluxioException e) {
            throw e.toAlluxioTException();
        }
    }

    public Set<Long> getPinIdList() {
        return this.mFileSystemMaster.getPinIdList();
    }

    public FileSystemCommand heartbeat(long workerId, List<Long> persistedFiles) throws AlluxioTException, TException {
        try {
            return this.mFileSystemMaster.workerHeartbeat(workerId, persistedFiles);
        }
        catch (FileDoesNotExistException e) {
            throw e.toAlluxioTException();
        }
        catch (InvalidPathException e) {
            throw e.toAlluxioTException();
        }
        catch (AccessControlException e) {
            throw e.toAlluxioTException();
        }
    }
}

