/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.file;

import alluxio.AlluxioURI;
import alluxio.exception.AccessControlException;
import alluxio.exception.ExceptionMessage;
import alluxio.exception.InvalidPathException;
import alluxio.security.authorization.FileSystemAction;
import alluxio.security.authorization.FileSystemPermission;
import alluxio.util.io.PathUtils;
import alluxio.wire.FileInfo;
import com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class PermissionChecker {
    private static boolean sPermissionCheckEnabled;
    private static String sFileSystemOwner;
    private static String sFileSystemSuperGroup;

    public static synchronized void initializeFileSystem(boolean permissionCheckEnabled, String owner, String superGroup) {
        sPermissionCheckEnabled = permissionCheckEnabled;
        sFileSystemOwner = owner;
        sFileSystemSuperGroup = superGroup;
    }

    public static void checkParentPermission(String user, List<String> groups, FileSystemAction action, AlluxioURI path, List<FileInfo> fileInfoList) throws AccessControlException, InvalidPathException {
        if (PathUtils.isRoot((String)path.getPath())) {
            return;
        }
        String[] pathComponents = PathUtils.getPathComponents((String)path.getPath());
        if (pathComponents.length == fileInfoList.size()) {
            fileInfoList.remove(fileInfoList.size() - 1);
        }
        PermissionChecker.checkByFileInfoList(user, groups, action, path.getPath(), fileInfoList, false);
    }

    public static void checkPermission(String user, List<String> groups, FileSystemAction action, AlluxioURI path, List<FileInfo> fileInfoList) throws AccessControlException, InvalidPathException {
        String[] pathComponents = PathUtils.getPathComponents((String)path.getPath());
        for (int i = fileInfoList.size(); i < pathComponents.length; ++i) {
            fileInfoList.add(null);
        }
        PermissionChecker.checkByFileInfoList(user, groups, action, path.getPath(), fileInfoList, false);
    }

    public static void checkOwner(String user, List<String> groups, AlluxioURI path, List<FileInfo> fileInfoList) throws AccessControlException, InvalidPathException {
        String[] pathComponents = PathUtils.getPathComponents((String)path.getPath());
        for (int i = fileInfoList.size(); i < pathComponents.length; ++i) {
            fileInfoList.add(null);
        }
        PermissionChecker.checkByFileInfoList(user, groups, null, path.getPath(), fileInfoList, true);
    }

    public static void checkSuperuser(String user, List<String> groups) throws AccessControlException {
        if (sFileSystemOwner.equals(user) || groups.contains(sFileSystemSuperGroup)) {
            return;
        }
        throw new AccessControlException(ExceptionMessage.PERMISSION_DENIED.getMessage(new Object[]{user + " is not a super user or in super group"}));
    }

    private static void checkByFileInfoList(String user, List<String> groups, FileSystemAction action, String path, List<FileInfo> fileInfoList, boolean checkIsOwner) throws AccessControlException {
        int size = fileInfoList.size();
        Preconditions.checkArgument((size > 0 ? 1 : 0) != 0, (Object)"The passed-in file info list can not be empty when checking permission");
        if (!sPermissionCheckEnabled) {
            return;
        }
        if (sFileSystemOwner.equals(user) || groups.contains(sFileSystemSuperGroup)) {
            return;
        }
        for (int i = 0; i < size - 1; ++i) {
            PermissionChecker.check(user, groups, fileInfoList.get(i), FileSystemAction.EXECUTE, path);
        }
        if (checkIsOwner) {
            FileInfo fileInfo = fileInfoList.get(fileInfoList.size() - 1);
            if (fileInfo == null || user.equals(fileInfo.getUserName())) {
                return;
            }
            throw new AccessControlException(ExceptionMessage.PERMISSION_DENIED.getMessage(new Object[]{"user=" + user + " is not the owner of path=" + path}));
        }
        PermissionChecker.check(user, groups, fileInfoList.get(fileInfoList.size() - 1), action, path);
    }

    private static void check(String user, List<String> groups, FileInfo fileInfo, FileSystemAction action, String path) throws AccessControlException {
        if (fileInfo == null) {
            return;
        }
        short permission = (short)fileInfo.getPermission();
        if (user.equals(fileInfo.getUserName()) && FileSystemPermission.createUserAction((short)permission).imply(action)) {
            return;
        }
        if (groups.contains(fileInfo.getGroupName()) && FileSystemPermission.createGroupAction((short)permission).imply(action)) {
            return;
        }
        if (FileSystemPermission.createOtherAction((short)permission).imply(action)) {
            return;
        }
        throw new AccessControlException(ExceptionMessage.PERMISSION_DENIED.getMessage(new Object[]{PermissionChecker.toExceptionMessage(user, action, path, fileInfo)}));
    }

    private static String toExceptionMessage(String user, FileSystemAction action, String path, FileInfo fileInfo) {
        StringBuilder stringBuilder = new StringBuilder().append("user=").append(user).append(", ").append("access=").append(action).append(", ").append("path=").append(path).append(": ").append("failed at ").append(fileInfo.getName().equals("") ? "/" : fileInfo.getName());
        return stringBuilder.toString();
    }
}

