/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.file.meta;

import alluxio.exception.FileDoesNotExistException;
import alluxio.master.file.FileSystemMaster;
import alluxio.master.file.meta.PersistenceState;
import alluxio.wire.FileInfo;
import com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class FileSystemMasterView {
    private final FileSystemMaster mFileSystemMaster;

    public FileSystemMasterView(FileSystemMaster fileSystemMaster) {
        this.mFileSystemMaster = (FileSystemMaster)Preconditions.checkNotNull((Object)fileSystemMaster);
    }

    public synchronized PersistenceState getFilePersistenceState(long fileId) throws FileDoesNotExistException {
        return this.mFileSystemMaster.getPersistenceState(fileId);
    }

    public synchronized FileInfo getFileInfo(long fileId) throws FileDoesNotExistException {
        return this.mFileSystemMaster.getFileInfo(fileId);
    }

    public synchronized List<Long> getLostFiles() {
        return this.mFileSystemMaster.getLostFiles();
    }
}

