/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.file.meta;

import alluxio.master.file.meta.PersistenceState;
import alluxio.master.journal.JournalEntryRepresentable;
import alluxio.security.authorization.PermissionStatus;
import alluxio.wire.FileInfo;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class Inode
implements JournalEntryRepresentable {
    private final long mCreationTimeMs;
    private String mUserName;
    private String mGroupName;
    private short mPermission;
    private boolean mDeleted;
    protected final boolean mDirectory;
    private final long mId;
    private long mLastModificationTimeMs;
    private String mName;
    private long mParentId;
    private boolean mPinned;
    private PersistenceState mPersistenceState;

    protected Inode(Builder<?> builder) {
        this.mCreationTimeMs = ((Builder)builder).mCreationTimeMs;
        this.mDeleted = false;
        this.mDirectory = builder.mDirectory;
        this.mLastModificationTimeMs = ((Builder)builder).mCreationTimeMs;
        this.mId = builder.mId;
        this.mLastModificationTimeMs = ((Builder)builder).mLastModificationTimeMs;
        this.mName = ((Builder)builder).mName;
        this.mPersistenceState = ((Builder)builder).mPersistenceState;
        this.mParentId = ((Builder)builder).mParentId;
        this.mPinned = ((Builder)builder).mPinned;
        if (((Builder)builder).mPermissionStatus != null) {
            this.mUserName = ((Builder)builder).mPermissionStatus.getUserName();
            this.mGroupName = ((Builder)builder).mPermissionStatus.getGroupName();
            this.mPermission = ((Builder)builder).mPermissionStatus.getPermission().toShort();
        }
    }

    public synchronized boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Inode)) {
            return false;
        }
        Inode that = (Inode)o;
        return this.mId == that.mId;
    }

    public abstract FileInfo generateClientFileInfo(String var1);

    public synchronized long getCreationTimeMs() {
        return this.mCreationTimeMs;
    }

    public synchronized long getId() {
        return this.mId;
    }

    public synchronized long getLastModificationTimeMs() {
        return this.mLastModificationTimeMs;
    }

    public synchronized String getName() {
        return this.mName;
    }

    public synchronized PersistenceState getPersistenceState() {
        return this.mPersistenceState;
    }

    public synchronized long getParentId() {
        return this.mParentId;
    }

    public synchronized int hashCode() {
        return Long.valueOf(this.mId).hashCode();
    }

    public synchronized boolean isDeleted() {
        return this.mDeleted;
    }

    public synchronized boolean isDirectory() {
        return this.mDirectory;
    }

    public synchronized boolean isFile() {
        return !this.mDirectory;
    }

    public synchronized boolean isPinned() {
        return this.mPinned;
    }

    public synchronized boolean isPersisted() {
        return this.mPersistenceState == PersistenceState.PERSISTED;
    }

    public synchronized void setDeleted(boolean deleted) {
        this.mDeleted = deleted;
    }

    public synchronized void setLastModificationTimeMs(long lastModificationTimeMs) {
        this.mLastModificationTimeMs = lastModificationTimeMs;
    }

    public synchronized void setName(String name) {
        this.mName = name;
    }

    public synchronized void setParentId(long parentId) {
        this.mParentId = parentId;
    }

    public synchronized void setPersistenceState(PersistenceState persistenceState) {
        this.mPersistenceState = persistenceState;
    }

    public synchronized void setPinned(boolean pinned) {
        this.mPinned = pinned;
    }

    public synchronized String getUserName() {
        return this.mUserName;
    }

    public synchronized void setUserName(String userName) {
        this.mUserName = userName;
    }

    public synchronized String getGroupName() {
        return this.mGroupName;
    }

    public synchronized void setGroupName(String groupName) {
        this.mGroupName = groupName;
    }

    public synchronized short getPermission() {
        return this.mPermission;
    }

    public synchronized void setPermission(short permission) {
        this.mPermission = permission;
    }

    public synchronized String toString() {
        return "Inode(" + "ID:" + this.mId + ", NAME:" + this.mName + ", PARENT_ID:" + this.mParentId + ", CREATION_TIME_MS:" + this.mCreationTimeMs + ", PINNED:" + this.mPinned + "DELETED:" + this.mDeleted + ", LAST_MODIFICATION_TIME_MS:" + this.mLastModificationTimeMs + ", USER_NAME:" + this.mUserName + ", GROUP_NAME:" + this.mGroupName + ", PERMISSION:" + ")";
    }

    public static abstract class Builder<T extends Builder<T>> {
        private long mCreationTimeMs = System.currentTimeMillis();
        protected boolean mDirectory = false;
        protected long mId = 0L;
        private long mLastModificationTimeMs = this.mCreationTimeMs;
        private String mName = null;
        private long mParentId = -1L;
        private PersistenceState mPersistenceState = PersistenceState.NOT_PERSISTED;
        private PermissionStatus mPermissionStatus = null;
        private boolean mPinned = false;

        public T setCreationTimeMs(long creationTimeMs) {
            this.mCreationTimeMs = creationTimeMs;
            return this.getThis();
        }

        public T setId(long id) {
            this.mId = id;
            return this.getThis();
        }

        public T setLastModificationTimeMs(long lastModificationTimeMs) {
            this.mLastModificationTimeMs = lastModificationTimeMs;
            return this.getThis();
        }

        public T setName(String name) {
            this.mName = name;
            return this.getThis();
        }

        public T setParentId(long parentId) {
            this.mParentId = parentId;
            return this.getThis();
        }

        public T setPersistenceState(PersistenceState persistenceState) {
            this.mPersistenceState = persistenceState;
            return this.getThis();
        }

        public T setPermissionStatus(PermissionStatus ps) {
            this.mPermissionStatus = ps;
            return this.getThis();
        }

        public T setPinned(boolean pinned) {
            this.mPinned = pinned;
            return this.getThis();
        }

        public abstract Inode build();

        protected abstract T getThis();
    }
}

