/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.file.meta;

import alluxio.collections.IndexedSet;
import alluxio.master.file.meta.Inode;
import alluxio.master.file.meta.PersistenceState;
import alluxio.proto.journal.File;
import alluxio.proto.journal.Journal;
import alluxio.security.authorization.PermissionStatus;
import alluxio.wire.FileInfo;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class InodeDirectory
extends Inode {
    private IndexedSet.FieldIndex<Inode> mIdIndex = new IndexedSet.FieldIndex<Inode>(){

        public Object getFieldValue(Inode o) {
            return o.getId();
        }
    };
    private IndexedSet.FieldIndex<Inode> mNameIndex = new IndexedSet.FieldIndex<Inode>(){

        public Object getFieldValue(Inode o) {
            return o.getName();
        }
    };
    private IndexedSet<Inode> mChildren = new IndexedSet(this.mIdIndex, new IndexedSet.FieldIndex[]{this.mNameIndex});

    private InodeDirectory(Builder builder) {
        super(builder);
    }

    public synchronized void addChild(Inode child) {
        this.mChildren.add((Object)child);
    }

    @Override
    public synchronized FileInfo generateClientFileInfo(String path) {
        FileInfo ret = new FileInfo();
        ret.setFileId(this.getId());
        ret.setName(this.getName());
        ret.setPath(path);
        ret.setLength(0L);
        ret.setBlockSizeBytes(0L);
        ret.setCreationTimeMs(this.getCreationTimeMs());
        ret.setCompleted(true);
        ret.setFolder(true);
        ret.setPinned(this.isPinned());
        ret.setCacheable(false);
        ret.setPersisted(this.isPersisted());
        ret.setLastModificationTimeMs(this.getLastModificationTimeMs());
        ret.setTtl(-1L);
        ret.setUserName(this.getUserName());
        ret.setGroupName(this.getGroupName());
        ret.setPermission((int)this.getPermission());
        ret.setPersistenceState(this.getPersistenceState().toString());
        return ret;
    }

    public synchronized Inode getChild(long id) {
        return (Inode)this.mChildren.getFirstByField(this.mIdIndex, (Object)id);
    }

    public synchronized Inode getChild(String name) {
        return (Inode)this.mChildren.getFirstByField(this.mNameIndex, (Object)name);
    }

    public synchronized Set<Inode> getChildren() {
        return ImmutableSet.copyOf((Iterator)this.mChildren.iterator());
    }

    public synchronized Set<Long> getChildrenIds() {
        HashSet<Long> ret = new HashSet<Long>(this.mChildren.size());
        for (Inode child : this.mChildren) {
            ret.add(child.getId());
        }
        return ret;
    }

    public synchronized int getNumberOfChildren() {
        return this.mChildren.size();
    }

    public synchronized boolean removeChild(Inode child) {
        return this.mChildren.remove((Object)child);
    }

    public synchronized boolean removeChild(String name) {
        return this.mChildren.removeByField(this.mNameIndex, (Object)name);
    }

    @Override
    public synchronized String toString() {
        StringBuilder sb = new StringBuilder("InodeDirectory(");
        sb.append(super.toString()).append(",").append(this.getChildren()).append(")");
        return sb.toString();
    }

    public static InodeDirectory fromJournalEntry(File.InodeDirectoryEntry entry) {
        PermissionStatus permissionStatus = new PermissionStatus(entry.getUserName(), entry.getGroupName(), (short)entry.getPermission());
        InodeDirectory inode = ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)new Builder().setName(entry.getName())).setId(entry.getId())).setParentId(entry.getParentId())).setCreationTimeMs(entry.getCreationTimeMs())).setPersistenceState(PersistenceState.valueOf(entry.getPersistenceState()))).setPinned(entry.getPinned())).setLastModificationTimeMs(entry.getLastModificationTimeMs())).setPermissionStatus(permissionStatus)).build();
        return inode;
    }

    @Override
    public synchronized Journal.JournalEntry toJournalEntry() {
        File.InodeDirectoryEntry inodeDirectory = File.InodeDirectoryEntry.newBuilder().setCreationTimeMs(this.getCreationTimeMs()).setId(this.getId()).setName(this.getName()).setParentId(this.getParentId()).setPersistenceState(this.getPersistenceState().name()).setPinned(this.isPinned()).setLastModificationTimeMs(this.getLastModificationTimeMs()).setUserName(this.getUserName()).setGroupName(this.getGroupName()).setPermission(this.getPermission()).build();
        return Journal.JournalEntry.newBuilder().setInodeDirectory(inodeDirectory).build();
    }

    public static class Builder
    extends Inode.Builder<Builder> {
        public Builder() {
            this.mDirectory = true;
        }

        @Override
        public InodeDirectory build() {
            return new InodeDirectory(this);
        }

        @Override
        protected Builder getThis() {
            return this;
        }
    }
}

