/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.file.meta;

import alluxio.master.block.BlockId;
import alluxio.master.block.ContainerIdGenerable;
import alluxio.master.journal.JournalEntryRepresentable;
import alluxio.proto.journal.File;
import alluxio.proto.journal.Journal;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class InodeDirectoryIdGenerator
implements JournalEntryRepresentable {
    private final ContainerIdGenerable mContainerIdGenerator;
    private boolean mInitialized = false;
    private long mContainerId;
    private long mSequenceNumber;

    public InodeDirectoryIdGenerator(ContainerIdGenerable containerIdGenerator) {
        this.mContainerIdGenerator = (ContainerIdGenerable)Preconditions.checkNotNull((Object)containerIdGenerator);
    }

    synchronized long getNewDirectoryId() {
        this.initialize();
        long directoryId = BlockId.createBlockId((long)this.mContainerId, (long)this.mSequenceNumber);
        if (this.mSequenceNumber == BlockId.getMaxSequenceNumber()) {
            this.mContainerId = this.mContainerIdGenerator.getNewContainerId();
            this.mSequenceNumber = 0L;
        } else {
            ++this.mSequenceNumber;
        }
        return directoryId;
    }

    @Override
    public synchronized Journal.JournalEntry toJournalEntry() {
        File.InodeDirectoryIdGeneratorEntry inodeDirectoryIdGenerator = File.InodeDirectoryIdGeneratorEntry.newBuilder().setContainerId(this.mContainerId).setSequenceNumber(this.mSequenceNumber).build();
        return Journal.JournalEntry.newBuilder().setInodeDirectoryIdGenerator(inodeDirectoryIdGenerator).build();
    }

    public synchronized void initFromJournalEntry(File.InodeDirectoryIdGeneratorEntry entry) {
        this.mContainerId = entry.getContainerId();
        this.mSequenceNumber = entry.getSequenceNumber();
        this.mInitialized = true;
    }

    private void initialize() {
        if (!this.mInitialized) {
            this.mContainerId = this.mContainerIdGenerator.getNewContainerId();
            this.mSequenceNumber = 0L;
            this.mInitialized = true;
        }
    }
}

