/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.file.meta;

import alluxio.exception.BlockInfoException;
import alluxio.exception.FileAlreadyCompletedException;
import alluxio.exception.InvalidFileSizeException;
import alluxio.master.block.BlockId;
import alluxio.master.file.meta.Inode;
import alluxio.master.file.meta.PersistenceState;
import alluxio.proto.journal.File;
import alluxio.proto.journal.Journal;
import alluxio.security.authorization.FileSystemPermission;
import alluxio.security.authorization.PermissionStatus;
import alluxio.wire.FileInfo;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class InodeFile
extends Inode {
    private static final FileSystemPermission UMASK = new FileSystemPermission(73);
    private long mBlockContainerId;
    private long mBlockSizeBytes;
    private List<Long> mBlocks;
    private boolean mCacheable;
    private boolean mCompleted;
    private long mLength;
    private long mTtl;

    private InodeFile(Builder builder) {
        super(builder);
        this.mBlockContainerId = builder.mBlockContainerId;
        this.mBlockSizeBytes = builder.mBlockSizeBytes;
        this.mBlocks = new ArrayList<Long>(3);
        this.mCacheable = builder.mCacheable;
        this.mCompleted = false;
        this.mLength = 0L;
        this.mTtl = builder.mTtl;
    }

    @Override
    public synchronized FileInfo generateClientFileInfo(String path) {
        FileInfo ret = new FileInfo();
        ret.setFileId(this.getId());
        ret.setName(this.getName());
        ret.setPath(path);
        ret.setLength(this.getLength());
        ret.setBlockSizeBytes(this.getBlockSizeBytes());
        ret.setCreationTimeMs(this.getCreationTimeMs());
        ret.setCacheable(this.isCacheable());
        ret.setFolder(false);
        ret.setPinned(this.isPinned());
        ret.setCompleted(this.isCompleted());
        ret.setPersisted(this.isPersisted());
        ret.setBlockIds(this.getBlockIds());
        ret.setLastModificationTimeMs(this.getLastModificationTimeMs());
        ret.setTtl(this.mTtl);
        ret.setUserName(this.getUserName());
        ret.setGroupName(this.getGroupName());
        ret.setPermission((int)this.getPermission());
        ret.setPersistenceState(this.getPersistenceState().toString());
        return ret;
    }

    public synchronized void reset() {
        this.mBlocks = Lists.newArrayList();
        this.mLength = 0L;
        this.mCompleted = false;
        this.mCacheable = false;
    }

    public synchronized void setBlockSize(long blockSizeBytes) {
        Preconditions.checkArgument((blockSizeBytes >= 0L ? 1 : 0) != 0, (Object)"Block size cannot be negative");
        this.mBlockSizeBytes = blockSizeBytes;
    }

    public synchronized void setTtl(long ttl) {
        this.mTtl = ttl;
    }

    public synchronized List<Long> getBlockIds() {
        return new ArrayList<Long>(this.mBlocks);
    }

    public synchronized long getBlockSizeBytes() {
        return this.mBlockSizeBytes;
    }

    public synchronized long getLength() {
        return this.mLength;
    }

    public synchronized long getNewBlockId() {
        long blockId = BlockId.createBlockId((long)this.mBlockContainerId, (long)this.mBlocks.size());
        this.mBlocks.add(blockId);
        return blockId;
    }

    public synchronized long getBlockIdByIndex(int blockIndex) throws BlockInfoException {
        if (blockIndex < 0 || blockIndex >= this.mBlocks.size()) {
            throw new BlockInfoException("blockIndex " + blockIndex + " is out of range. File blocks: " + this.mBlocks.size());
        }
        return this.mBlocks.get(blockIndex);
    }

    public synchronized boolean isCacheable() {
        return this.mCacheable;
    }

    public synchronized boolean isCompleted() {
        return this.mCompleted;
    }

    public synchronized void setBlockIds(List<Long> blockIds) {
        this.mBlocks = Lists.newArrayList((Iterable)((Iterable)Preconditions.checkNotNull(blockIds)));
    }

    public synchronized void setCacheable(boolean cacheable) {
        this.mCacheable = cacheable;
    }

    public synchronized void setCompleted(boolean completed) {
        this.mCompleted = completed;
    }

    public synchronized void setLength(long length) {
        this.mLength = length;
    }

    public synchronized void complete(long length) throws InvalidFileSizeException, FileAlreadyCompletedException {
        if (this.mCompleted) {
            throw new FileAlreadyCompletedException("File " + this.getName() + " has already been completed.");
        }
        if (length < 0L) {
            throw new InvalidFileSizeException("File " + this.getName() + " cannot have negative length.");
        }
        this.mCompleted = true;
        this.mLength = length;
        this.mBlocks.clear();
        while (length > 0L) {
            long blockSize = Math.min(length, this.mBlockSizeBytes);
            this.getNewBlockId();
            length -= blockSize;
        }
    }

    @Override
    public synchronized String toString() {
        StringBuilder sb = new StringBuilder("InodeFile(");
        sb.append(super.toString()).append(", LENGTH: ").append(this.mLength);
        sb.append(", Cacheable: ").append(this.mCacheable);
        sb.append(", Completed: ").append(this.mCompleted);
        sb.append(", Cacheable: ").append(this.mCacheable);
        sb.append(", mBlocks: ").append(this.mBlocks);
        sb.append(", mTtl: ").append(this.mTtl);
        sb.append(")");
        return sb.toString();
    }

    public static InodeFile fromJournalEntry(File.InodeFileEntry entry) {
        PermissionStatus permissionStatus = new PermissionStatus(entry.getUserName(), entry.getGroupName(), (short)entry.getPermission());
        InodeFile inode = ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)new Builder().setName(entry.getName())).setBlockContainerId(BlockId.getContainerId((long)entry.getId())).setBlockSizeBytes(entry.getBlockSizeBytes()).setCacheable(entry.getCacheable()).setCreationTimeMs(entry.getCreationTimeMs())).setLastModificationTimeMs(entry.getLastModificationTimeMs())).setParentId(entry.getParentId())).setPersistenceState(PersistenceState.valueOf(entry.getPersistenceState()))).setPinned(entry.getPinned())).setTtl(entry.getTtl()).setPermissionStatus(permissionStatus).build();
        inode.setBlockIds(entry.getBlocksList());
        inode.setCompleted(entry.getCompleted());
        inode.setLength(entry.getLength());
        inode.setPinned(entry.getPinned());
        inode.setCacheable(entry.getCacheable());
        inode.setLastModificationTimeMs(entry.getLastModificationTimeMs());
        return inode;
    }

    @Override
    public synchronized Journal.JournalEntry toJournalEntry() {
        File.InodeFileEntry inodeFile = File.InodeFileEntry.newBuilder().setCreationTimeMs(this.getCreationTimeMs()).setId(this.getId()).setName(this.getName()).setParentId(this.getParentId()).setPersistenceState(this.getPersistenceState().name()).setPinned(this.isPinned()).setLastModificationTimeMs(this.getLastModificationTimeMs()).setBlockSizeBytes(this.getBlockSizeBytes()).setLength(this.getLength()).setCompleted(this.isCompleted()).setCacheable(this.isCacheable()).addAllBlocks(this.mBlocks).setTtl(this.mTtl).setUserName(this.getUserName()).setGroupName(this.getGroupName()).setPermission(this.getPermission()).build();
        return Journal.JournalEntry.newBuilder().setInodeFile(inodeFile).build();
    }

    public synchronized long getTtl() {
        return this.mTtl;
    }

    public static class Builder
    extends Inode.Builder<Builder> {
        private long mBlockContainerId = 0L;
        private long mBlockSizeBytes = 0L;
        private boolean mCacheable = false;
        private long mTtl;

        public Builder() {
            this.mDirectory = false;
            this.mTtl = -1L;
        }

        public Builder setBlockContainerId(long blockContainerId) {
            this.mBlockContainerId = blockContainerId;
            this.mId = BlockId.createBlockId((long)this.mBlockContainerId, (long)BlockId.getMaxSequenceNumber());
            return this;
        }

        public Builder setBlockSizeBytes(long blockSizeBytes) {
            this.mBlockSizeBytes = blockSizeBytes;
            return this;
        }

        public Builder setCacheable(boolean cacheable) {
            this.mCacheable = cacheable;
            return this;
        }

        @Override
        public Builder setId(long id) {
            return this;
        }

        public Builder setTtl(long ttl) {
            this.mTtl = ttl;
            return this;
        }

        @Override
        public InodeFile build() {
            return new InodeFile(this);
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        @Override
        public Builder setPermissionStatus(PermissionStatus ps) {
            return (Builder)super.setPermissionStatus(ps.applyUMask(UMASK));
        }
    }
}

