/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.file.meta;

import alluxio.AlluxioURI;
import alluxio.Configuration;
import alluxio.collections.IndexedSet;
import alluxio.exception.BlockInfoException;
import alluxio.exception.ExceptionMessage;
import alluxio.exception.FileAlreadyExistsException;
import alluxio.exception.FileDoesNotExistException;
import alluxio.exception.InvalidPathException;
import alluxio.master.MasterContext;
import alluxio.master.block.ContainerIdGenerable;
import alluxio.master.file.PermissionChecker;
import alluxio.master.file.meta.Inode;
import alluxio.master.file.meta.InodeDirectory;
import alluxio.master.file.meta.InodeDirectoryIdGenerator;
import alluxio.master.file.meta.InodeFile;
import alluxio.master.file.meta.MountTable;
import alluxio.master.file.meta.PersistenceState;
import alluxio.master.file.meta.options.CreatePathOptions;
import alluxio.master.journal.JournalCheckpointStreamable;
import alluxio.master.journal.JournalOutputStream;
import alluxio.master.journal.JournalProtoUtils;
import alluxio.proto.journal.File;
import alluxio.proto.journal.Journal;
import alluxio.security.authorization.PermissionStatus;
import alluxio.underfs.UnderFileSystem;
import alluxio.util.FormatUtils;
import alluxio.util.io.PathUtils;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.protobuf.Message;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class InodeTree
implements JournalCheckpointStreamable {
    public static final long NO_PARENT = -1L;
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private static final String ROOT_INODE_NAME = "";
    private InodeDirectory mRoot = null;
    private MountTable mMountTable;
    private final IndexedSet.FieldIndex<Inode> mIdIndex = new IndexedSet.FieldIndex<Inode>(){

        public Object getFieldValue(Inode o) {
            return o.getId();
        }
    };
    private final IndexedSet<Inode> mInodes = new IndexedSet(this.mIdIndex, new IndexedSet.FieldIndex[0]);
    private final Set<Long> mPinnedInodeFileIds = new HashSet<Long>();
    private final ContainerIdGenerable mContainerIdGenerator;
    private final InodeDirectoryIdGenerator mDirectoryIdGenerator;
    private InodeDirectory mCachedInode;

    public InodeTree(ContainerIdGenerable containerIdGenerator, InodeDirectoryIdGenerator directoryIdGenerator, MountTable mountTable) {
        this.mContainerIdGenerator = containerIdGenerator;
        this.mDirectoryIdGenerator = directoryIdGenerator;
        this.mMountTable = mountTable;
    }

    public void initializeRoot(PermissionStatus rootPermissionStatus) {
        if (this.mRoot == null) {
            this.mRoot = ((InodeDirectory.Builder)((InodeDirectory.Builder)((InodeDirectory.Builder)((InodeDirectory.Builder)new InodeDirectory.Builder().setName(ROOT_INODE_NAME)).setId(this.mDirectoryIdGenerator.getNewDirectoryId())).setPermissionStatus(rootPermissionStatus)).setParentId(-1L)).build();
            this.mInodes.add((Object)this.mRoot);
            this.mCachedInode = this.mRoot;
        }
        PermissionChecker.initializeFileSystem(MasterContext.getConf().getBoolean("alluxio.security.authorization.permission.enabled"), this.mRoot.getUserName(), MasterContext.getConf().get("alluxio.security.authorization.permission.supergroup"));
    }

    public int getSize() {
        return this.mInodes.size();
    }

    public int getPinnedSize() {
        return this.mPinnedInodeFileIds.size();
    }

    public Inode getInodeById(long id) throws FileDoesNotExistException {
        Inode inode = (Inode)this.mInodes.getFirstByField(this.mIdIndex, (Object)id);
        if (inode == null) {
            throw new FileDoesNotExistException("Inode id " + id + " does not exist.");
        }
        return inode;
    }

    public Inode getInodeByPath(AlluxioURI path) throws InvalidPathException {
        TraversalResult traversalResult = this.traverseToInode(PathUtils.getPathComponents((String)path.toString()), false);
        if (!traversalResult.isFound()) {
            throw new InvalidPathException(ExceptionMessage.PATH_DOES_NOT_EXIST.getMessage(new Object[]{path}));
        }
        return traversalResult.getInode();
    }

    public List<Inode> collectInodes(AlluxioURI path) throws InvalidPathException {
        TraversalResult traversalResult = this.traverseToInode(PathUtils.getPathComponents((String)path.getPath()), false);
        return traversalResult.getInodes();
    }

    public AlluxioURI getPath(Inode inode) {
        if (this.isRootId(inode.getId())) {
            return new AlluxioURI("/");
        }
        if (this.isRootId(inode.getParentId())) {
            return new AlluxioURI("/" + inode.getName());
        }
        return this.getPath((Inode)this.mInodes.getFirstByField(this.mIdIndex, (Object)inode.getParentId())).join(inode.getName());
    }

    public InodeDirectory getRoot() {
        return this.mRoot;
    }

    public CreatePathResult createPath(AlluxioURI path, CreatePathOptions options) throws FileAlreadyExistsException, BlockInfoException, InvalidPathException, IOException {
        Inode lastToPersistInode;
        String ufsPath;
        UnderFileSystem ufs;
        if (path.isRoot()) {
            LOG.info("FileAlreadyExistsException: {}", (Object)path);
            throw new FileAlreadyExistsException(path.toString());
        }
        if (!options.isDirectory() && options.getBlockSizeBytes() < 1L) {
            throw new BlockInfoException("Invalid block size " + options.getBlockSizeBytes());
        }
        LOG.debug("createPath {}", (Object)FormatUtils.parametersToString((Object[])new Object[]{path}));
        String[] pathComponents = PathUtils.getPathComponents((String)path.getPath());
        String name = path.getName();
        String[] parentPath = new String[pathComponents.length - 1];
        System.arraycopy(pathComponents, 0, parentPath, 0, parentPath.length);
        TraversalResult traversalResult = this.traverseToInode(parentPath, options.isPersisted());
        int pathIndex = parentPath.length;
        if (!traversalResult.isFound()) {
            if (!options.isRecursive()) {
                String msg = "File " + path + " creation failed. Component " + traversalResult.getNonexistentPathIndex() + "(" + parentPath[traversalResult.getNonexistentPathIndex()] + ") does not exist";
                LOG.info("InvalidPathException: {}", (Object)msg);
                throw new InvalidPathException(msg);
            }
            pathIndex = traversalResult.getNonexistentPathIndex();
        }
        if (!traversalResult.getInode().isDirectory()) {
            throw new InvalidPathException("Could not traverse to parent directory of path " + path + ". Component " + pathComponents[pathIndex - 1] + " is not a directory.");
        }
        InodeDirectory currentInodeDirectory = (InodeDirectory)traversalResult.getInode();
        ArrayList createdInodes = Lists.newArrayList();
        ArrayList modifiedInodes = Lists.newArrayList();
        ArrayList toPersistDirectories = Lists.newArrayList(traversalResult.getNonPersisted());
        if (pathIndex < parentPath.length || currentInodeDirectory.getChild(name) == null) {
            modifiedInodes.add(currentInodeDirectory);
        }
        for (int k = pathIndex; k < parentPath.length; ++k) {
            InodeDirectory dir = ((InodeDirectory.Builder)((InodeDirectory.Builder)((InodeDirectory.Builder)((InodeDirectory.Builder)((InodeDirectory.Builder)((InodeDirectory.Builder)new InodeDirectory.Builder().setName(pathComponents[k])).setId(this.mDirectoryIdGenerator.getNewDirectoryId())).setParentId(currentInodeDirectory.getId())).setPersistenceState(options.isPersisted() ? PersistenceState.PERSISTED : PersistenceState.NOT_PERSISTED)).setCreationTimeMs(options.getOperationTimeMs())).setPermissionStatus(options.getPermissionStatus())).build();
            dir.setPinned(currentInodeDirectory.isPinned());
            currentInodeDirectory.addChild(dir);
            currentInodeDirectory.setLastModificationTimeMs(options.getOperationTimeMs());
            if (options.isPersisted()) {
                toPersistDirectories.add(dir);
            }
            createdInodes.add(dir);
            this.mInodes.add((Object)dir);
            currentInodeDirectory = dir;
        }
        Inode lastInode = currentInodeDirectory.getChild(name);
        if (lastInode != null) {
            if (lastInode.isDirectory() && options.isDirectory() && !lastInode.isPersisted() && options.isPersisted()) {
                traversalResult.getNonPersisted().add(lastInode);
                toPersistDirectories.add(lastInode);
            } else if (!lastInode.isDirectory() || !options.isAllowExists()) {
                LOG.info(ExceptionMessage.FILE_ALREADY_EXISTS.getMessage(new Object[]{path}));
                throw new FileAlreadyExistsException(ExceptionMessage.FILE_ALREADY_EXISTS.getMessage(new Object[]{path}));
            }
        } else {
            if (options.isDirectory()) {
                lastInode = ((InodeDirectory.Builder)((InodeDirectory.Builder)((InodeDirectory.Builder)((InodeDirectory.Builder)new InodeDirectory.Builder().setName(name)).setId(this.mDirectoryIdGenerator.getNewDirectoryId())).setParentId(currentInodeDirectory.getId())).setPermissionStatus(options.getPermissionStatus())).build();
                if (options.isPersisted()) {
                    toPersistDirectories.add(lastInode);
                }
            } else {
                lastInode = ((InodeFile.Builder)((InodeFile.Builder)((InodeFile.Builder)((InodeFile.Builder)new InodeFile.Builder().setBlockContainerId(this.mContainerIdGenerator.getNewContainerId()).setBlockSizeBytes(options.getBlockSizeBytes()).setTtl(options.getTtl()).setName(name)).setParentId(currentInodeDirectory.getId())).setPersistenceState(options.isPersisted() ? PersistenceState.PERSISTED : PersistenceState.NOT_PERSISTED)).setCreationTimeMs(options.getOperationTimeMs())).setPermissionStatus(options.getPermissionStatus()).build();
                if (currentInodeDirectory.isPinned()) {
                    this.mPinnedInodeFileIds.add(lastInode.getId());
                }
            }
            lastInode.setPinned(currentInodeDirectory.isPinned());
            createdInodes.add(lastInode);
            this.mInodes.add((Object)lastInode);
            currentInodeDirectory.addChild(lastInode);
            currentInodeDirectory.setLastModificationTimeMs(options.getOperationTimeMs());
        }
        if (toPersistDirectories.size() > 0 && ((ufs = UnderFileSystem.get((String)(ufsPath = this.mMountTable.resolve(this.getPath(lastToPersistInode = (Inode)toPersistDirectories.get(toPersistDirectories.size() - 1))).toString()), (Configuration)MasterContext.getConf())).exists(ufsPath) || ufs.mkdirs(ufsPath, true))) {
            for (Inode inode : toPersistDirectories) {
                inode.setPersistenceState(PersistenceState.PERSISTED);
            }
        }
        LOG.debug("createFile: File Created: {} parent: ", (Object)lastInode, (Object)currentInodeDirectory);
        return new CreatePathResult(modifiedInodes, createdInodes, traversalResult.getNonPersisted());
    }

    public long reinitializeFile(AlluxioURI path, long blockSizeBytes, long ttl) throws InvalidPathException {
        InodeFile file = (InodeFile)this.getInodeByPath(path);
        file.setBlockSize(blockSizeBytes);
        file.setTtl(ttl);
        return file.getId();
    }

    public List<Inode> getInodeChildrenRecursive(InodeDirectory inodeDirectory) {
        ArrayList<Inode> ret = new ArrayList<Inode>();
        for (Inode i : inodeDirectory.getChildren()) {
            ret.add(i);
            if (!i.isDirectory()) continue;
            ret.addAll(this.getInodeChildrenRecursive((InodeDirectory)i));
        }
        return ret;
    }

    public void deleteInode(Inode inode, long opTimeMs) throws FileDoesNotExistException {
        InodeDirectory parent = (InodeDirectory)this.getInodeById(inode.getParentId());
        parent.removeChild(inode);
        parent.setLastModificationTimeMs(opTimeMs);
        this.mInodes.remove((Object)inode);
        this.mPinnedInodeFileIds.remove(inode.getId());
        inode.setDeleted(true);
    }

    public void deleteInode(Inode inode) throws FileDoesNotExistException {
        this.deleteInode(inode, System.currentTimeMillis());
    }

    public void setPinned(Inode inode, boolean pinned, long opTimeMs) {
        inode.setPinned(pinned);
        inode.setLastModificationTimeMs(opTimeMs);
        if (inode.isFile()) {
            if (inode.isPinned()) {
                this.mPinnedInodeFileIds.add(inode.getId());
            } else {
                this.mPinnedInodeFileIds.remove(inode.getId());
            }
        } else {
            assert (inode instanceof InodeDirectory);
            for (Inode child : ((InodeDirectory)inode).getChildren()) {
                this.setPinned(child, pinned, opTimeMs);
            }
        }
    }

    public void setPinned(Inode inode, boolean pinned) {
        this.setPinned(inode, pinned, System.currentTimeMillis());
    }

    public Set<Long> getPinIdSet() {
        return Sets.newHashSet(this.mPinnedInodeFileIds);
    }

    public boolean isRootId(long fileId) {
        Preconditions.checkNotNull((Object)this.mRoot, (Object)"Cannot call isRootId() before initializeRoot()");
        return fileId == this.mRoot.getId();
    }

    @Override
    public void streamToJournalCheckpoint(JournalOutputStream outputStream) throws IOException {
        LinkedList<Inode> inodes = new LinkedList<Inode>();
        inodes.add(this.mRoot);
        while (!inodes.isEmpty()) {
            Inode inode = (Inode)inodes.poll();
            outputStream.writeEntry(inode.toJournalEntry());
            if (!inode.isDirectory()) continue;
            inodes.addAll(((InodeDirectory)inode).getChildren());
        }
    }

    public void addInodeFromJournal(Journal.JournalEntry entry) {
        Message innerEntry = JournalProtoUtils.unwrap(entry);
        if (innerEntry instanceof File.InodeFileEntry) {
            InodeFile file = InodeFile.fromJournalEntry((File.InodeFileEntry)innerEntry);
            this.addInodeFromJournalInternal(file);
        } else if (innerEntry instanceof File.InodeDirectoryEntry) {
            InodeDirectory directory = InodeDirectory.fromJournalEntry((File.InodeDirectoryEntry)innerEntry);
            if (directory.getName().equals(ROOT_INODE_NAME)) {
                this.mInodes.clear();
                this.mPinnedInodeFileIds.clear();
                this.mCachedInode = this.mRoot = directory;
                this.mInodes.add((Object)this.mRoot);
            } else {
                this.addInodeFromJournalInternal(directory);
            }
        } else {
            LOG.error("Unexpected InodeEntry journal entry: {}", (Object)entry);
        }
    }

    private void addInodeFromJournalInternal(Inode inode) {
        InodeDirectory parentDirectory = this.mCachedInode;
        if (inode.getParentId() != this.mCachedInode.getId()) {
            this.mCachedInode = parentDirectory = (InodeDirectory)this.mInodes.getFirstByField(this.mIdIndex, (Object)inode.getParentId());
        }
        parentDirectory.addChild(inode);
        this.mInodes.add((Object)inode);
        if (inode.isFile() && inode.isPinned()) {
            this.mPinnedInodeFileIds.add(inode.getId());
        }
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mRoot, this.mIdIndex, this.mInodes, this.mPinnedInodeFileIds, this.mContainerIdGenerator, this.mDirectoryIdGenerator, this.mCachedInode});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InodeTree)) {
            return false;
        }
        InodeTree that = (InodeTree)o;
        return Objects.equal((Object)this.mRoot, (Object)that.mRoot) && Objects.equal(this.mIdIndex, that.mIdIndex) && Objects.equal(this.mInodes, that.mInodes) && Objects.equal(this.mPinnedInodeFileIds, that.mPinnedInodeFileIds) && Objects.equal((Object)this.mContainerIdGenerator, (Object)that.mContainerIdGenerator) && Objects.equal((Object)this.mDirectoryIdGenerator, (Object)that.mDirectoryIdGenerator) && Objects.equal((Object)this.mCachedInode, (Object)that.mCachedInode);
    }

    private TraversalResult traverseToInode(String[] pathComponents, boolean collectNonPersisted) throws InvalidPathException {
        ArrayList nonPersistedInodes = Lists.newArrayList();
        ArrayList inodes = Lists.newArrayList();
        if (pathComponents == null) {
            throw new InvalidPathException("passed-in pathComponents is null");
        }
        if (pathComponents.length == 0) {
            throw new InvalidPathException("passed-in pathComponents is empty");
        }
        if (pathComponents.length == 1) {
            if (pathComponents[0].equals(ROOT_INODE_NAME)) {
                inodes.add(this.mRoot);
                return TraversalResult.createFoundResult(this.mRoot, nonPersistedInodes, inodes);
            }
            throw new InvalidPathException("File name starts with " + pathComponents[0]);
        }
        Inode current = this.mRoot;
        inodes.add(current);
        for (int i = 1; i < pathComponents.length; ++i) {
            Inode next = current.getChild(pathComponents[i]);
            if (next == null) {
                return TraversalResult.createNotFoundResult(current, i, nonPersistedInodes, inodes);
            }
            if (next.isFile()) {
                if (i == pathComponents.length - 1) {
                    inodes.add(next);
                    return TraversalResult.createFoundResult(next, nonPersistedInodes, inodes);
                }
                throw new InvalidPathException("Traversal failed. Component " + i + "(" + next.getName() + ") is a file");
            }
            inodes.add(next);
            if (!next.isPersisted() && collectNonPersisted) {
                nonPersistedInodes.add(next);
            }
            current = next;
        }
        return TraversalResult.createFoundResult(current, nonPersistedInodes, inodes);
    }

    public static final class CreatePathResult {
        private final List<Inode> mModified;
        private final List<Inode> mCreated;
        private final List<Inode> mPersisted;

        CreatePathResult(List<Inode> modified, List<Inode> created, List<Inode> persisted) {
            this.mModified = (List)Preconditions.checkNotNull(modified);
            this.mCreated = (List)Preconditions.checkNotNull(created);
            this.mPersisted = (List)Preconditions.checkNotNull(persisted);
        }

        public List<Inode> getModified() {
            return this.mModified;
        }

        public List<Inode> getCreated() {
            return this.mCreated;
        }

        public List<Inode> getPersisted() {
            return this.mPersisted;
        }
    }

    private static final class TraversalResult {
        private final boolean mFound;
        private final int mNonexistentIndex;
        private final Inode mInode;
        private final List<Inode> mNonPersisted;
        private final List<Inode> mInodes;

        static TraversalResult createFoundResult(Inode inode, List<Inode> nonPersisted, List<Inode> inodes) {
            return new TraversalResult(true, -1, inode, nonPersisted, inodes);
        }

        static TraversalResult createNotFoundResult(Inode inode, int index, List<Inode> nonPersisted, List<Inode> inodes) {
            return new TraversalResult(false, index, inode, nonPersisted, inodes);
        }

        private TraversalResult(boolean found, int index, Inode inode, List<Inode> nonPersisted, List<Inode> inodes) {
            this.mFound = found;
            this.mNonexistentIndex = index;
            this.mInode = inode;
            this.mNonPersisted = nonPersisted;
            this.mInodes = inodes;
        }

        boolean isFound() {
            return this.mFound;
        }

        int getNonexistentPathIndex() {
            if (this.mFound) {
                throw new UnsupportedOperationException("The traversal is successful");
            }
            return this.mNonexistentIndex;
        }

        Inode getInode() {
            return this.mInode;
        }

        List<Inode> getNonPersisted() {
            return this.mNonPersisted;
        }

        List<Inode> getInodes() {
            return this.mInodes;
        }
    }
}

