/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.file.meta;

import alluxio.AlluxioURI;
import alluxio.exception.ExceptionMessage;
import alluxio.exception.FileAlreadyExistsException;
import alluxio.exception.InvalidPathException;
import alluxio.util.io.PathUtils;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class MountTable {
    public static final String ROOT = "/";
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private Map<String, AlluxioURI> mMountTable;

    public MountTable() {
        int initialCapacity = 10;
        this.mMountTable = new HashMap<String, AlluxioURI>(10);
    }

    public synchronized void add(AlluxioURI alluxioUri, AlluxioURI ufsUri) throws FileAlreadyExistsException, InvalidPathException {
        String alluxioPath = alluxioUri.getPath();
        LOG.info("Mounting {} at {}", (Object)ufsUri, (Object)alluxioPath);
        if (this.mMountTable.containsKey(alluxioPath)) {
            throw new FileAlreadyExistsException(ExceptionMessage.MOUNT_POINT_ALREADY_EXISTS.getMessage(new Object[]{alluxioPath}));
        }
        for (Map.Entry<String, AlluxioURI> entry : this.mMountTable.entrySet()) {
            String mountedUfsPath;
            String mountedAlluxioPath = entry.getKey();
            AlluxioURI mountedUfsUri = entry.getValue();
            if (!mountedAlluxioPath.equals(ROOT) && PathUtils.hasPrefix((String)alluxioPath, (String)mountedAlluxioPath)) {
                throw new InvalidPathException(ExceptionMessage.MOUNT_POINT_PREFIX_OF_ANOTHER.getMessage(new Object[]{mountedAlluxioPath, alluxioPath}));
            }
            if (ufsUri.getScheme() != null && !ufsUri.getScheme().equals(mountedUfsUri.getScheme()) || ufsUri.getAuthority() != null && !ufsUri.getAuthority().equals(mountedUfsUri.getAuthority())) continue;
            String ufsPath = ufsUri.getPath();
            if (PathUtils.hasPrefix((String)ufsPath, (String)(mountedUfsPath = mountedUfsUri.getPath()))) {
                throw new InvalidPathException(ExceptionMessage.MOUNT_POINT_PREFIX_OF_ANOTHER.getMessage(new Object[]{mountedUfsUri.toString(), ufsUri.toString()}));
            }
            if (!PathUtils.hasPrefix((String)mountedUfsPath, (String)ufsPath)) continue;
            throw new InvalidPathException(ExceptionMessage.MOUNT_POINT_PREFIX_OF_ANOTHER.getMessage(new Object[]{ufsUri.toString(), mountedUfsUri.toString()}));
        }
        this.mMountTable.put(alluxioPath, ufsUri);
    }

    public synchronized boolean delete(AlluxioURI uri) {
        String path = uri.getPath();
        LOG.info("Unmounting {}", (Object)path);
        if (path.equals(ROOT)) {
            LOG.warn("Cannot unmount the root mount point.");
            return false;
        }
        if (this.mMountTable.containsKey(path)) {
            this.mMountTable.remove(path);
            return true;
        }
        LOG.warn("Mount point {} does not exist.", (Object)path);
        return false;
    }

    public synchronized String getMountPoint(AlluxioURI uri) throws InvalidPathException {
        String path = uri.getPath();
        String mountPoint = null;
        for (Map.Entry<String, AlluxioURI> entry : this.mMountTable.entrySet()) {
            String alluxioPath = entry.getKey();
            if (!PathUtils.hasPrefix((String)path, (String)alluxioPath) || mountPoint != null && !PathUtils.hasPrefix((String)alluxioPath, (String)mountPoint)) continue;
            mountPoint = alluxioPath;
        }
        return mountPoint;
    }

    public synchronized boolean isMountPoint(AlluxioURI uri) {
        return this.mMountTable.containsKey(uri.getPath());
    }

    public synchronized AlluxioURI resolve(AlluxioURI uri) throws InvalidPathException {
        String path = uri.getPath();
        LOG.debug("Resolving {}", (Object)path);
        String mountPoint = this.getMountPoint(uri);
        if (mountPoint != null) {
            AlluxioURI ufsPath = this.mMountTable.get(mountPoint);
            return new AlluxioURI(ufsPath.getScheme(), ufsPath.getAuthority(), PathUtils.concatPath((Object)ufsPath.getPath(), (Object[])new Object[]{path.substring(mountPoint.length())}));
        }
        return uri;
    }
}

