/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.file.meta;

import alluxio.master.MasterContext;
import alluxio.master.file.meta.InodeFile;
import com.google.common.base.Objects;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class TtlBucket
implements Comparable<TtlBucket> {
    private static long sTtlIntervalMs = MasterContext.getConf().getInt("alluxio.master.ttl.checker.interval.ms");
    private long mTtlIntervalStartTimeMs;
    private Set<InodeFile> mFiles;

    public TtlBucket(long startTimeMs) {
        this.mTtlIntervalStartTimeMs = startTimeMs;
        this.mFiles = new HashSet<InodeFile>();
    }

    public long getTtlIntervalStartTimeMs() {
        return this.mTtlIntervalStartTimeMs;
    }

    public long getTtlIntervalEndTimeMs() {
        return this.mTtlIntervalStartTimeMs + sTtlIntervalMs;
    }

    public static long getTtlIntervalMs() {
        return sTtlIntervalMs;
    }

    public Set<InodeFile> getFiles() {
        return this.mFiles;
    }

    public void addFile(InodeFile file) {
        this.mFiles.add(file);
    }

    public void removeFile(InodeFile file) {
        this.mFiles.remove(file);
    }

    @Override
    public int compareTo(TtlBucket ttlBucket) {
        long startTime2;
        long startTime1 = this.getTtlIntervalStartTimeMs();
        if (startTime1 < (startTime2 = ttlBucket.getTtlIntervalStartTimeMs())) {
            return -1;
        }
        if (startTime1 == startTime2) {
            return 0;
        }
        return 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TtlBucket)) {
            return false;
        }
        TtlBucket that = (TtlBucket)o;
        return this.mTtlIntervalStartTimeMs == that.mTtlIntervalStartTimeMs;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mTtlIntervalStartTimeMs});
    }
}

