/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.file.meta;

import alluxio.master.file.meta.InodeFile;
import alluxio.master.file.meta.TtlBucket;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class TtlBucketList {
    private final ConcurrentSkipListSet<TtlBucket> mBucketList = new ConcurrentSkipListSet();

    private TtlBucket getBucketContaining(InodeFile file) {
        if (file.getTtl() == -1L) {
            return null;
        }
        long ttlEndTimeMs = file.getCreationTimeMs() + file.getTtl();
        TtlBucket bucket = this.mBucketList.floor(new TtlBucket(ttlEndTimeMs));
        if (bucket == null || bucket.getTtlIntervalEndTimeMs() < ttlEndTimeMs || bucket.getTtlIntervalEndTimeMs() == ttlEndTimeMs && TtlBucket.getTtlIntervalMs() != 0L) {
            return null;
        }
        return bucket;
    }

    public void insert(InodeFile file) {
        if (file.getTtl() == -1L) {
            return;
        }
        TtlBucket bucket = this.getBucketContaining(file);
        if (bucket == null) {
            long ttlEndTimeMs = file.getCreationTimeMs() + file.getTtl();
            long interval = TtlBucket.getTtlIntervalMs();
            bucket = new TtlBucket(interval == 0L ? ttlEndTimeMs : ttlEndTimeMs / interval * interval);
            this.mBucketList.add(bucket);
        }
        bucket.addFile(file);
    }

    public void remove(InodeFile file) {
        TtlBucket bucket = this.getBucketContaining(file);
        if (bucket != null) {
            bucket.removeFile(file);
        }
    }

    public Set<TtlBucket> getExpiredBuckets(long time) {
        return this.mBucketList.headSet(new TtlBucket(time - TtlBucket.getTtlIntervalMs()), true);
    }

    public void removeBuckets(Set<TtlBucket> buckets) {
        this.mBucketList.removeAll(buckets);
    }
}

