/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.file.meta.options;

import alluxio.Configuration;
import alluxio.master.MasterContext;
import alluxio.security.authorization.PermissionStatus;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class CreatePathOptions {
    private final boolean mAllowExists;
    private final long mBlockSizeBytes;
    private final boolean mDirectory;
    private final long mOperationTimeMs;
    private final boolean mPersisted;
    private final boolean mRecursive;
    private final long mTtl;
    private PermissionStatus mPermissionStatus;

    public static CreatePathOptions defaults() {
        return new Builder(MasterContext.getConf()).build();
    }

    private CreatePathOptions(Builder builder) {
        this.mAllowExists = builder.mAllowExists;
        this.mBlockSizeBytes = builder.mBlockSizeBytes;
        this.mDirectory = builder.mDirectory;
        this.mOperationTimeMs = builder.mOperationTimeMs;
        this.mPersisted = builder.mPersisted;
        this.mRecursive = builder.mRecursive;
        this.mTtl = builder.mTtl;
        this.mPermissionStatus = builder.mPermissionStatus;
    }

    public boolean isAllowExists() {
        return this.mAllowExists;
    }

    public long getBlockSizeBytes() {
        return this.mBlockSizeBytes;
    }

    public boolean isDirectory() {
        return this.mDirectory;
    }

    public long getOperationTimeMs() {
        return this.mOperationTimeMs;
    }

    public boolean isPersisted() {
        return this.mPersisted;
    }

    public boolean isRecursive() {
        return this.mRecursive;
    }

    public long getTtl() {
        return this.mTtl;
    }

    public PermissionStatus getPermissionStatus() {
        return this.mPermissionStatus;
    }

    public static class Builder {
        private boolean mAllowExists = false;
        private long mBlockSizeBytes;
        private boolean mDirectory;
        private long mOperationTimeMs;
        private boolean mPersisted;
        private boolean mRecursive;
        private long mTtl;
        private PermissionStatus mPermissionStatus;

        public Builder() {
            this(MasterContext.getConf());
        }

        public Builder(Configuration conf) {
            this.mBlockSizeBytes = conf.getBytes("alluxio.user.block.size.bytes.default");
            this.mDirectory = false;
            this.mOperationTimeMs = System.currentTimeMillis();
            this.mRecursive = false;
            this.mPersisted = false;
            this.mTtl = -1L;
            this.mPermissionStatus = PermissionStatus.getDirDefault();
        }

        public Builder setAllowExists(boolean allowExists) {
            this.mAllowExists = allowExists;
            return this;
        }

        public Builder setBlockSizeBytes(long blockSizeBytes) {
            this.mBlockSizeBytes = blockSizeBytes;
            return this;
        }

        public Builder setDirectory(boolean directory) {
            this.mDirectory = directory;
            return this;
        }

        public Builder setOperationTimeMs(long operationTimeMs) {
            this.mOperationTimeMs = operationTimeMs;
            return this;
        }

        public Builder setPersisted(boolean persisted) {
            this.mPersisted = persisted;
            return this;
        }

        public Builder setRecursive(boolean recursive) {
            this.mRecursive = recursive;
            return this;
        }

        public Builder setTtl(long ttl) {
            this.mTtl = ttl;
            return this;
        }

        public Builder setPermissionStatus(PermissionStatus permissionStatus) {
            this.mPermissionStatus = permissionStatus;
            return this;
        }

        public CreatePathOptions build() {
            return new CreatePathOptions(this);
        }
    }
}

