/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.file.options;

import alluxio.Configuration;
import alluxio.master.MasterContext;
import alluxio.thrift.CompleteFileTOptions;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class CompleteFileOptions {
    private long mUfsLength;
    private long mOperationTimeMs;

    public static CompleteFileOptions defaults() {
        return new Builder(MasterContext.getConf()).build();
    }

    private CompleteFileOptions(Builder builder) {
        this.mUfsLength = builder.mUfsLength;
        this.mOperationTimeMs = builder.mOperationTimeMs;
    }

    public CompleteFileOptions(CompleteFileTOptions options) {
        this.mUfsLength = options.getUfsLength();
        this.mOperationTimeMs = System.currentTimeMillis();
    }

    public long getUfsLength() {
        return this.mUfsLength;
    }

    public long getOperationTimeMs() {
        return this.mOperationTimeMs;
    }

    public static class Builder {
        private long mUfsLength = 0L;
        private long mOperationTimeMs = System.currentTimeMillis();

        public Builder(Configuration conf) {
        }

        public Builder setUfsLength(long ufsLength) {
            this.mUfsLength = ufsLength;
            return this;
        }

        public Builder setOperationTimeMs(long operationTimeMs) {
            this.mOperationTimeMs = operationTimeMs;
            return this;
        }

        public CompleteFileOptions build() {
            return new CompleteFileOptions(this);
        }
    }
}

