/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.file.options;

import alluxio.Configuration;
import alluxio.master.MasterContext;
import alluxio.thrift.CreateDirectoryTOptions;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class CreateDirectoryOptions {
    private boolean mAllowExists;
    private long mOperationTimeMs;
    private boolean mPersisted;
    private boolean mRecursive;

    public static CreateDirectoryOptions defaults() {
        return new Builder(MasterContext.getConf()).build();
    }

    private CreateDirectoryOptions(Builder builder) {
        this.mAllowExists = builder.mAllowExists;
        this.mOperationTimeMs = builder.mOperationTimeMs;
        this.mPersisted = builder.mPersisted;
        this.mRecursive = builder.mRecursive;
    }

    public CreateDirectoryOptions(CreateDirectoryTOptions options) {
        this.mAllowExists = options.isAllowExists();
        this.mOperationTimeMs = System.currentTimeMillis();
        this.mPersisted = options.isPersisted();
        this.mRecursive = options.isRecursive();
    }

    public boolean isAllowExists() {
        return this.mAllowExists;
    }

    public long getOperationTimeMs() {
        return this.mOperationTimeMs;
    }

    public boolean isPersisted() {
        return this.mPersisted;
    }

    public boolean isRecursive() {
        return this.mRecursive;
    }

    public static class Builder {
        private boolean mAllowExists;
        private long mOperationTimeMs = System.currentTimeMillis();
        private boolean mPersisted = false;
        private boolean mRecursive = false;

        public Builder(Configuration conf) {
        }

        public Builder setAllowExists(boolean allowExists) {
            this.mAllowExists = allowExists;
            return this;
        }

        public Builder setOperationTimeMs(long operationTimeMs) {
            this.mOperationTimeMs = operationTimeMs;
            return this;
        }

        public Builder setPersisted(boolean persisted) {
            this.mPersisted = persisted;
            return this;
        }

        public Builder setRecursive(boolean recursive) {
            this.mRecursive = recursive;
            return this;
        }

        public CreateDirectoryOptions build() {
            return new CreateDirectoryOptions(this);
        }
    }
}

