/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.file.options;

import alluxio.Configuration;
import alluxio.master.MasterContext;
import alluxio.thrift.CreateFileTOptions;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class CreateFileOptions {
    private long mBlockSizeBytes;
    private long mOperationTimeMs;
    private boolean mPersisted;
    private boolean mRecursive;
    private long mTtl;

    public static CreateFileOptions defaults() {
        return new Builder(MasterContext.getConf()).build();
    }

    private CreateFileOptions(Builder builder) {
        this.mBlockSizeBytes = builder.mBlockSizeBytes;
        this.mOperationTimeMs = builder.mOperationTimeMs;
        this.mPersisted = builder.mPersisted;
        this.mRecursive = builder.mRecursive;
        this.mTtl = builder.mTtl;
    }

    public CreateFileOptions(CreateFileTOptions options) {
        this.mBlockSizeBytes = options.getBlockSizeBytes();
        this.mOperationTimeMs = System.currentTimeMillis();
        this.mPersisted = options.isPersisted();
        this.mRecursive = options.isRecursive();
        this.mTtl = options.getTtl();
    }

    public long getBlockSizeBytes() {
        return this.mBlockSizeBytes;
    }

    public long getOperationTimeMs() {
        return this.mOperationTimeMs;
    }

    public boolean isPersisted() {
        return this.mPersisted;
    }

    public boolean isRecursive() {
        return this.mRecursive;
    }

    public long getTtl() {
        return this.mTtl;
    }

    public static class Builder {
        private long mBlockSizeBytes;
        private long mOperationTimeMs;
        private boolean mPersisted;
        private boolean mRecursive;
        private long mTtl;

        public Builder(Configuration conf) {
            this.mBlockSizeBytes = conf.getBytes("alluxio.user.block.size.bytes.default");
            this.mOperationTimeMs = System.currentTimeMillis();
            this.mPersisted = false;
            this.mRecursive = false;
            this.mTtl = -1L;
        }

        public Builder setBlockSizeBytes(long blockSizeBytes) {
            this.mBlockSizeBytes = blockSizeBytes;
            return this;
        }

        public Builder setOperationTimeMs(long operationTimeMs) {
            this.mOperationTimeMs = operationTimeMs;
            return this;
        }

        public Builder setPersisted(boolean persisted) {
            this.mPersisted = persisted;
            return this;
        }

        public Builder setRecursive(boolean recursive) {
            this.mRecursive = recursive;
            return this;
        }

        public Builder setTtl(long ttl) {
            this.mTtl = ttl;
            return this;
        }

        public CreateFileOptions build() {
            return new CreateFileOptions(this);
        }
    }
}

