/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.file.options;

import alluxio.Configuration;
import alluxio.master.MasterContext;
import alluxio.thrift.SetAttributeTOptions;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class SetAttributeOptions {
    private final Boolean mPinned;
    private final Long mTtl;
    private final Boolean mPersisted;
    private final String mOwner;
    private final String mGroup;
    private final Short mPermission;
    private final boolean mRecursive;
    private long mOperationTimeMs;

    public SetAttributeOptions(SetAttributeTOptions options) {
        this.mPinned = options.isSetPinned() ? Boolean.valueOf(options.isPinned()) : null;
        this.mTtl = options.isSetTtl() ? Long.valueOf(options.getTtl()) : null;
        this.mPersisted = options.isSetPersisted() ? Boolean.valueOf(options.isPersisted()) : null;
        this.mOwner = options.isSetOwner() ? options.getOwner() : null;
        this.mGroup = options.isSetGroup() ? options.getGroup() : null;
        this.mPermission = options.isSetPermission() ? (short)options.getPermission() : (short)-1;
        this.mRecursive = options.isRecursive();
        this.mOperationTimeMs = System.currentTimeMillis();
    }

    public static SetAttributeOptions defaults() {
        return new Builder(MasterContext.getConf()).build();
    }

    private SetAttributeOptions(Builder builder) {
        this.mPinned = builder.mPinned;
        this.mTtl = builder.mTtl;
        this.mPersisted = builder.mPersisted;
        this.mOwner = builder.mOwner;
        this.mGroup = builder.mGroup;
        this.mPermission = builder.mPermission;
        this.mRecursive = builder.mRecursive;
        this.mOperationTimeMs = builder.mOperationTimeMs;
    }

    public Boolean getPinned() {
        return this.mPinned;
    }

    public Long getTtl() {
        return this.mTtl;
    }

    public Boolean getPersisted() {
        return this.mPersisted;
    }

    public String getOwner() {
        return this.mOwner;
    }

    public String getGroup() {
        return this.mGroup;
    }

    public Short getPermission() {
        return this.mPermission;
    }

    public boolean isRecursive() {
        return this.mRecursive;
    }

    public long getOperationTimeMs() {
        return this.mOperationTimeMs;
    }

    public static class Builder {
        private Boolean mPinned = null;
        private Long mTtl = null;
        private Boolean mPersisted = null;
        private String mOwner = null;
        private String mGroup = null;
        private Short mPermission = -1;
        private boolean mRecursive = false;
        private long mOperationTimeMs = System.currentTimeMillis();

        public Builder() {
            this(MasterContext.getConf());
        }

        public Builder(Configuration conf) {
        }

        public Builder setPinned(boolean pinned) {
            this.mPinned = pinned;
            return this;
        }

        public Builder setTtl(long ttl) {
            this.mTtl = ttl;
            return this;
        }

        public Builder setPersisted(boolean persisted) {
            this.mPersisted = persisted;
            return this;
        }

        public Builder setOwner(String owner) {
            this.mOwner = owner;
            return this;
        }

        public Builder setGroup(String group) {
            this.mGroup = group;
            return this;
        }

        public Builder setPermission(short permission) {
            this.mPermission = permission;
            return this;
        }

        public Builder setRecursive(boolean recursive) {
            this.mRecursive = recursive;
            return this;
        }

        public Builder setOperationTimeMs(long operationTimeMs) {
            this.mOperationTimeMs = operationTimeMs;
            return this;
        }

        public SetAttributeOptions build() {
            return new SetAttributeOptions(this);
        }
    }
}

