/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.journal;

import alluxio.master.MasterContext;
import alluxio.master.journal.JournalFormatter;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class Journal {
    public static final long FIRST_COMPLETED_LOG_NUMBER = 1L;
    private static final String COMPLETED_DIRECTORY = "completed/";
    private static final String CURRENT_LOG_EXTENSION = ".out";
    private static final String CHECKPOINT_FILENAME = "checkpoint.data";
    private static final String ENTRY_LOG_FILENAME_BASE = "log";
    private final String mDirectory;
    private final JournalFormatter mJournalFormatter;

    public Journal(String directory) {
        if (!directory.endsWith("/")) {
            directory = directory + "/";
        }
        this.mDirectory = directory;
        this.mJournalFormatter = JournalFormatter.Factory.create(MasterContext.getConf());
    }

    public String getDirectory() {
        return this.mDirectory;
    }

    public String getCompletedDirectory() {
        return this.mDirectory + COMPLETED_DIRECTORY;
    }

    public String getCheckpointFilePath() {
        return this.mDirectory + CHECKPOINT_FILENAME;
    }

    public String getCurrentLogFilePath() {
        return this.mDirectory + ENTRY_LOG_FILENAME_BASE + CURRENT_LOG_EXTENSION;
    }

    public String getCompletedLogFilePath(long logNumber) {
        return this.getCompletedDirectory() + String.format("%s.%020d", ENTRY_LOG_FILENAME_BASE, logNumber);
    }

    public JournalFormatter getJournalFormatter() {
        return this.mJournalFormatter;
    }
}

