/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.journal;

import alluxio.exception.ExceptionMessage;
import alluxio.proto.journal.Journal;
import com.google.protobuf.Message;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class JournalProtoUtils {
    public static Message unwrap(Journal.JournalEntry entry) {
        switch (entry.getEntryCase()) {
            case ADD_MOUNT_POINT: {
                return entry.getAddMountPoint();
            }
            case BLOCK_CONTAINER_ID_GENERATOR: {
                return entry.getBlockContainerIdGenerator();
            }
            case BLOCK_INFO: {
                return entry.getBlockInfo();
            }
            case COMPLETE_FILE: {
                return entry.getCompleteFile();
            }
            case DELETE_FILE: {
                return entry.getDeleteFile();
            }
            case DELETE_LINEAGE: {
                return entry.getDeleteLineage();
            }
            case DELETE_MOUNT_POINT: {
                return entry.getDeleteMountPoint();
            }
            case INODE_DIRECTORY: {
                return entry.getInodeDirectory();
            }
            case INODE_DIRECTORY_ID_GENERATOR: {
                return entry.getInodeDirectoryIdGenerator();
            }
            case INODE_FILE: {
                return entry.getInodeFile();
            }
            case INODE_LAST_MODIFICATION_TIME: {
                return entry.getInodeLastModificationTime();
            }
            case LINEAGE: {
                return entry.getLineage();
            }
            case LINEAGE_ID_GENERATOR: {
                return entry.getLineageIdGenerator();
            }
            case PERSIST_DIRECTORY: {
                return entry.getPersistDirectory();
            }
            case ASYNC_PERSIST_REQUEST: {
                return entry.getAsyncPersistRequest();
            }
            case REINITIALIZE_FILE: {
                return entry.getReinitializeFile();
            }
            case RENAME: {
                return entry.getRename();
            }
            case SET_ATTRIBUTE: {
                return entry.getSetAttribute();
            }
            case ENTRY_NOT_SET: {
                throw new RuntimeException(ExceptionMessage.NO_ENTRY_TYPE.getMessage(new Object[]{entry.getUnknownFields().asMap().keySet()}));
            }
        }
        throw new IllegalStateException(ExceptionMessage.UNKNOWN_JOURNAL_ENTRY_TYPE.getMessage(new Object[]{entry.getEntryCase()}));
    }

    private JournalProtoUtils() {
    }
}

