/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.journal;

import alluxio.Configuration;
import alluxio.master.MasterContext;
import alluxio.master.journal.Journal;
import alluxio.master.journal.JournalInputStream;
import alluxio.underfs.UnderFileSystem;
import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class JournalReader {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private final Journal mJournal;
    private final UnderFileSystem mUfs;
    private final String mCheckpointPath;
    private boolean mCheckpointRead = false;
    private long mCheckpointOpenedTime = -1L;
    private long mCheckpointLastModifiedTime = -1L;
    private long mCurrentLogNumber = 1L;

    JournalReader(Journal journal) {
        this.mJournal = (Journal)Preconditions.checkNotNull((Object)journal);
        Configuration conf = MasterContext.getConf();
        this.mUfs = UnderFileSystem.get((String)this.mJournal.getDirectory(), (Configuration)conf);
        this.mCheckpointPath = this.mJournal.getCheckpointFilePath();
    }

    public boolean isValid() {
        return this.mCheckpointRead && this.mCheckpointOpenedTime == this.mCheckpointLastModifiedTime;
    }

    public JournalInputStream getCheckpointInputStream() throws IOException {
        if (this.mCheckpointRead) {
            throw new IOException("Checkpoint file has already been read.");
        }
        this.mCheckpointOpenedTime = this.getCheckpointLastModifiedTimeMs();
        LOG.info("Opening journal checkpoint file: {}", (Object)this.mCheckpointPath);
        JournalInputStream jis = this.mJournal.getJournalFormatter().deserialize(this.mUfs.open(this.mCheckpointPath));
        this.mCheckpointRead = true;
        return jis;
    }

    public JournalInputStream getNextInputStream() throws IOException {
        if (!this.mCheckpointRead) {
            throw new IOException("Must read the checkpoint file before getting input stream.");
        }
        if (this.getCheckpointLastModifiedTimeMs() != this.mCheckpointOpenedTime) {
            throw new IOException("Checkpoint file has been updated. This reader is no longer valid.");
        }
        String currentLogPath = this.mJournal.getCompletedLogFilePath(this.mCurrentLogNumber);
        if (!this.mUfs.exists(currentLogPath)) {
            LOG.debug("Journal log file: {} does not exist yet.", (Object)currentLogPath);
            return null;
        }
        LOG.info("Opening journal log file: {}", (Object)currentLogPath);
        JournalInputStream jis = this.mJournal.getJournalFormatter().deserialize(this.mUfs.open(currentLogPath));
        ++this.mCurrentLogNumber;
        return jis;
    }

    public long getCheckpointLastModifiedTimeMs() throws IOException {
        if (!this.mUfs.exists(this.mCheckpointPath)) {
            throw new IOException("Checkpoint file " + this.mCheckpointPath + " does not exist.");
        }
        this.mCheckpointLastModifiedTime = this.mUfs.getModificationTimeMs(this.mCheckpointPath);
        return this.mCheckpointLastModifiedTime;
    }
}

