/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.journal;

import alluxio.master.Master;
import alluxio.master.journal.Journal;
import alluxio.master.journal.JournalInputStream;
import alluxio.master.journal.JournalReader;
import alluxio.master.journal.ReadOnlyJournal;
import alluxio.proto.journal.Journal;
import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class JournalTailer {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private final Master mMaster;
    private final Journal mJournal;
    private final JournalReader mReader;
    private long mLatestSequenceNumber = 0L;

    public JournalTailer(Master master, Journal journal) {
        this.mMaster = (Master)Preconditions.checkNotNull((Object)master);
        this.mJournal = (Journal)Preconditions.checkNotNull((Object)journal);
        this.mReader = ((ReadOnlyJournal)this.mJournal).getNewReader();
    }

    public boolean isValid() {
        return this.mReader.isValid();
    }

    public boolean checkpointExists() {
        try {
            this.mReader.getCheckpointLastModifiedTimeMs();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public long getLatestSequenceNumber() {
        return this.mLatestSequenceNumber;
    }

    public void processJournalCheckpoint(boolean applyToMaster) throws IOException {
        LOG.info("{}: Loading checkpoint file: {}", (Object)this.mMaster.getName(), (Object)this.mJournal.getCheckpointFilePath());
        JournalInputStream is = this.mReader.getCheckpointInputStream();
        if (applyToMaster) {
            this.mMaster.processJournalCheckpoint(is);
        }
        this.mLatestSequenceNumber = is.getLatestSequenceNumber();
        is.close();
    }

    public int processNextJournalLogFiles() throws IOException {
        int numFilesProcessed = 0;
        while (this.mReader.isValid()) {
            JournalInputStream inputStream = this.mReader.getNextInputStream();
            if (inputStream != null) {
                Journal.JournalEntry entry;
                LOG.info("{}: Processing a completed log file.", (Object)this.mMaster.getName());
                while ((entry = inputStream.getNextEntry()) != null) {
                    this.mMaster.processJournalEntry(entry);
                    this.mLatestSequenceNumber = inputStream.getLatestSequenceNumber();
                }
                inputStream.close();
                ++numFilesProcessed;
                LOG.info("{}: Finished processing the log file.", (Object)this.mMaster.getName());
                continue;
            }
            return numFilesProcessed;
        }
        LOG.info("{}: The checkpoint is out of date. Must reload checkpoint file.", (Object)this.mMaster.getName(), (Object)this.mJournal.getCheckpointFilePath());
        return numFilesProcessed;
    }
}

